<?php defined('ABSPATH') || exit; ?>
<?php do_action('mh_after_content'); ?>
<?php if (is_page_template('page-template-blank.php') || (is_single() && 'mh_post_blank' === get_post_meta(get_the_ID(), '_mhc_post_custom_template', true))): ?>
    <footer id="main-footer" style="display:none;" itemscope itemtype="https://schema.org/WPFooter">
		<?php get_template_part('footer', 'copyright'); ?>
    </footer>
<?php else: ?>
    <footer id="main-footer" itemscope itemtype="https://schema.org/WPFooter">
        <?php get_sidebar('footer'); ?>
        
        <?php if (has_nav_menu('footer-menu')): ?>
            <div id="mh-footer-nav">
                <div class="container">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-menu',
                        'depth'          => '1',
                        'menu_class'     => 'bottom-nav',
                        'container'      => '',
                        'fallback_cb'    => '',
                        'walker'         => new mharty_walker(),
                    ));
            ?>
                </div>
            </div> <!-- #mh-footer-nav -->
        <?php endif; ?>
        
        <div id="footer-bottom">
            <div class="container clearfix">
                <?php if ('1' === get_theme_mod('show_footer_social_icons', '0')):
                    $colorclass = '';
                    if ('light' === get_theme_mod('footer_social_icons_color', 'dark')) {
                        $colorclass = ' mh-social-light-color';
                    }
                    if ('color' === get_theme_mod('footer_social_icons_color', 'dark')) {
                        $colorclass = ' mh-social-default-color';
                    }
                    echo '<div class="social-icons-wrapper' . esc_attr($colorclass) . '">';
                    get_template_part('includes/social_icons', 'footer');
                    echo '</div>';
                endif; ?>
                
                <div id="footer-info">
					<?php get_template_part('footer', 'copyright'); ?>
                </div>
            </div> <!-- .container -->
        </div> <!-- #footer-bottom -->
    </footer> <!-- #main-footer -->
<?php endif; // ! is_page_template( 'page-template-blank.php' )?>
</div> <!-- #mh-main-area -->

<?php do_action('mh_before_end_container'); ?>

<?php if ('1' === get_theme_mod('back_to_top', '0')): ?>
    <span class="mhc_scroll_top mh_adjust_corners" role="button" tabindex="0" aria-label="<?php echo esc_attr__('Scroll to top', 'mharty'); ?>"></span>
<?php endif; ?>


<?php if (true === get_theme_mod('app_icon_sticky', false)): ?>
    <div class="mobile-menu-sticky-icon mh_adjust_corners">
        <button class="sandwich sandwich--collapse" type="button" aria-label="Menu" aria-controls="app-navigation">
            <span class="sandwich-box">
                <span class="sandwich-inner"></span>
            </span>
        </button>
    </div>
<?php endif; ?>

</div> <!-- #page-container -->

<?php do_action('mh_after_end_container'); ?>
<?php wp_footer(); ?>
</body>
</html>