<?php
/**
 * Mharty Theme
 * @since 6.0
 */

/**
 * Definitions
 */
define('MHARTY_THEME', true);
define('MHARTY_THEME_DIR', get_template_directory());
define('MHARTY_THEME_ADMIN_ASSETS', get_template_directory_uri() . '/includes/assets/');

if (! isset($content_width)) {
    $content_width = 1080;
}

/**
 * Theme Version
 */
if (!function_exists('mh_get_mharty_version')) {
    function mh_get_mharty_version() {
        $theme_info = wp_get_theme('mharty');
        $theme_version = $theme_info->get('Version');
        return sanitize_text_field($theme_version);
    }
}

if (!function_exists('mh_get_theme_version')) {
    function mh_get_theme_version() {
        $theme_info = wp_get_theme();
        $theme_version = $theme_info->get('Version');

        if (is_child_theme() && '' === $theme_version) {
            $theme_info = wp_get_theme(get_template());
            $theme_version = $theme_info->get('Version');
        }

        return sanitize_text_field($theme_version);
    }
}

/**
 * Load "after_setup_theme"
 */
function mharty_theme_setup() {
    global $mh_options, $mh_theme_image_sizes;
    $theme_version = mh_get_theme_version();
    define('MHARTY_THEME_VER', $theme_version);

    //load textdomain
    load_theme_textdomain('mharty', MHARTY_THEME_DIR . '/lang');
    register_nav_menus([
        'primary-menu' => esc_html__('Primary Menu', 'mharty'),
        'secondary-menu' => esc_html__('Secondary Menu', 'mharty'),
        'footer-menu' => esc_html__('Footer Menu', 'mharty'),
        'app-menu' => esc_html__('Mobile Menu', 'mharty'),
    ]);

    //Theme supports
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-formats', [
        'video',
        'audio',
        'quote',
        'gallery',
        'link'
    ]);
    add_theme_support('custom-background', apply_filters('mh_custom_background_args', []));

    if (function_exists('add_post_type_support')) {
        add_post_type_support('page', 'excerpt');
    }
    require_once(MHARTY_THEME_DIR . '/includes/functions/mh_migration.php');
    require_once(MHARTY_THEME_DIR . '/includes/mh_panel/mh_get_option.php');
    require_once(MHARTY_THEME_DIR . '/includes/mh_panel/mh_panel.php');
    $mh_options = mh_get_settings();
    require_once(MHARTY_THEME_DIR . '/includes/mh_menu/class-admin-menu.php');
    require_once(MHARTY_THEME_DIR . '/includes/mh_menu/class-nav-walker.php');
    require_once(MHARTY_THEME_DIR . '/includes/helpers/sanitize.php');
    require_once(MHARTY_THEME_DIR . '/includes/functions/mh_functions.php');
    require_once(MHARTY_THEME_DIR . '/includes/functions/mh_fonts.php');
    require_once(MHARTY_THEME_DIR . '/includes/mh_menu/mh_menu.php');
    require_once(MHARTY_THEME_DIR . '/includes/functions/mh_sidebars.php');
    include_once(MHARTY_THEME_DIR . '/includes/mh_customizer/mh_customizer.php');
    include_once(MHARTY_THEME_DIR . '/includes/mh_menu/mh_menu_icons.php');
    require_once(MHARTY_THEME_DIR . '/includes/functions/mh_shortcodes.php');
    include(MHARTY_THEME_DIR . '/includes/widgets.php');

    if (is_admin()) {
        require MHARTY_THEME_DIR . '/includes/metabox.php';
        require_once(MHARTY_THEME_DIR . '/includes/functions/mh_notices.php');
        require_once(MHARTY_THEME_DIR . '/includes/functions/mh_status.php');
        require_once(MHARTY_THEME_DIR . '/includes/mh_updater/mh_installer.php');
        require_once(MHARTY_THEME_DIR . '/includes/mh_panel/panel.php');
        require_once(MHARTY_THEME_DIR . '/includes/mh_panel/start.php');
        require_once(MHARTY_THEME_DIR . '/includes/mh_panel/updated.php');
    }

    if (!is_admin()) {
        require_once(MHARTY_THEME_DIR . '/includes/mh_menu/breadcrumb.php');
    }

    // thumbnails
    add_theme_support('post-thumbnails');
    $mh_theme_image_sizes = [
        '80x80' => 'mhc-post-thumbnail',
        '400x250' => 'mhc-post-main-image',
        '1080x675' => 'mhc-post-main-image-fullwidth',
        '400x284' => 'mhc-portfolio-image',
        '510x382' => 'mhc-fullwidth-portfolio-image',
        '1080x9999' => 'mhc-portfolio-image-single',
    ];

    $mh_theme_image_sizes = apply_filters('mh_theme_image_sizes', $mh_theme_image_sizes);
    $crop = apply_filters('mh_post_thumbnails_crop', true);

    if (is_array($mh_theme_image_sizes)) {
        foreach ($mh_theme_image_sizes as $image_size_dimensions => $image_size_name) {
            $dimensions = explode('x', $image_size_dimensions);

            if (in_array($image_size_name, ['mhc-portfolio-image-single'])) {
                $crop = false;
            }

            add_image_size($image_size_name, $dimensions[0], $dimensions[1], $crop);

            $crop = apply_filters('mh_post_thumbnails_crop', true);
        }
    }
    if (function_exists('mh_device_breakpoints') && function_exists('mh_use_responsive_images') && !mh_use_responsive_images()) {
        // Register responsive image sizes.
        $mh_device_breakpoints = mh_device_breakpoints();
        if ($mh_device_breakpoints && is_array($mh_device_breakpoints)) {
            foreach ($mh_device_breakpoints as $breakpoint => $width) {
                // round to 16:9 aspect ratio
                $height = round(($width * (56.25 / 100)));
                add_image_size("mh-image--responsive--{$breakpoint}", $width, $height, $crop);
            }
        }
    }
    //Third party plugins support
    add_theme_support('bbpress');
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');

    add_filter('widget_text', 'do_shortcode');
    add_filter('the_excerpt', 'do_shortcode');

    // don't display the empty title bar if the widget title is not set
    remove_filter('widget_title', 'mh_widget_force_title');

    // in mh_functions.php
    remove_filter('body_class', 'mh_add_fullwidth_body_class');

    // woocommerce related
    remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
    remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
    add_action('woocommerce_before_main_content', 'mh_theme_output_content_wrapper', 10);
    remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
    add_action('woocommerce_after_main_content', 'mh_theme_output_content_wrapper_end', 10);
    add_action('woocommerce_before_single_product_summary', 'mh_woocommerce_output_product_wrapper', 0);
    add_action('woocommerce_after_single_product_summary', 'mh_woocommerce_output_product_wrapper_end', 0);
    add_filter('woocommerce_output_related_products_args', 'mh_woocommerce_output_related_products_args');

    //disable first image in cart page
    add_filter('mh_grab_image_option', 'disable_mh_grab_image_option', 1);

    //bbPress compatibility - add custom style
    if (class_exists('bbPress', false)) {
        require_once(MHARTY_THEME_DIR . '/includes/plugins/bbpress.php');
    }

    //fix for tinymce RTL
    add_filter('tiny_mce_before_init', 'mh_tinymce_fix_rtl');

}
add_action('after_setup_theme', 'mharty_theme_setup');

/**
 * Get Mharty plugin versions.
 *
 * @return array An associative array of plugin slugs and their versions.
 */
function mh_get_plugin_versions() {
    $premium_plugins = [
        'mh-composer/mh-composer.php',
        'mh-magazine/mh-magazine.php',
        'mh-shop/mh-shop.php',
        'mh-loveit/mh-loveit.php',
        'mh-more-icons/mh-more-icons.php',
        'mh-reviews/mh-reviews.php',
        'mh-author-page-cover/mh-author-page-cover.php',
        'mh-shortcodes/mh-shortcodes.php',
        'mh-social-proof/mh-social-proof.php',
    ];

    $versions = [];

    if (! function_exists('get_plugins')) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    $installed_plugins = get_plugins();

    foreach ($premium_plugins as $plugin_file) {
        if (isset($installed_plugins[$plugin_file])) {
            $slug = dirname($plugin_file);
            $versions[$slug] = $installed_plugins[$plugin_file]['Version'];
        }
    }

    return $versions;
}

/**
 * admin only
 */
if (is_admin()) {
    require MHARTY_THEME_DIR . '/includes/helpers/metabox.php';
    require_once MHARTY_THEME_DIR . '/includes/helpers/admin-scripts.php';
}
/**
 * helpers & custom functions
 */
require_once MHARTY_THEME_DIR . '/includes/helpers/install-data.php';
require_once MHARTY_THEME_DIR . '/includes/helpers/tinymce.php';
require_once MHARTY_THEME_DIR . '/includes/helpers/scripts.php';
require_once MHARTY_THEME_DIR . '/includes/helpers/compatibility.php';
require_once MHARTY_THEME_DIR . '/includes/helpers/composer.php';
require_once MHARTY_THEME_DIR . '/includes/helpers/classes.php';
require_once MHARTY_THEME_DIR . '/includes/helpers/meta.php';
require_once MHARTY_THEME_DIR . '/includes/functions/mh_hooks.php';
require_once MHARTY_THEME_DIR . '/includes/functions/mh_meta.php';
require_once MHARTY_THEME_DIR . '/includes/functions/mh_content.php';
require_once MHARTY_THEME_DIR . '/includes/mh_updater/mh_updater.php';
require_once MHARTY_THEME_DIR . '/includes/mh_updater/class-updater.php';
require_once MHARTY_THEME_DIR . '/includes/mh_updater/class-installer.php';

/**
 * Mharty Updater
 */
function mharty_init_updater() {
    $config = [
        'repo_slug' => 'mharty',
    ];
    new MH_Updater($config);
}
add_action('after_setup_theme', 'mharty_init_updater');
