<?php defined('ABSPATH') || exit; ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin />
    <meta name="theme-color" content="<?php echo mh_get_accent_color(); ?>" />
    <script type="text/javascript"> document.documentElement.className = 'js';</script>
    <?php wp_head(); ?>
    <?php do_action('mh_head_meta'); ?>
</head>
<body <?php body_class(); ?>>
    <?php if (function_exists('wp_body_open')) {
        wp_body_open();
    } ?>
    <div id="page-container" class="<?php echo ! is_page_template('page-template-trans.php') ? 'not-trans' : ''; ?>">
        <?php do_action('mh_before_start_container'); ?>
        <?php mh_header_menu(); ?>
        <div id="mh-main-area">
            <?php do_action('mh_before_content'); ?>
