<?php

if (! defined('ABSPATH')) {
    die('-1');
}
if (! function_exists('mh_get_google_fonts')) :
    //fonts list
    function mh_get_google_fonts()
    {
        $google_fonts = array(

          //STACK FONTS
          'Stack' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Arial' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Arial',
          ),
          'Arial Black' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Arial Black',
          ),
          'Baskerville' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Baskerville',
          ),
          'Courier' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Courier',
          ),
          'Georgia' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Georgia',
          ),
          'Lucida Bright' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Lucida Bright',
          ),
          'Palatino' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Palatino',
          ),
          'Tahoma' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Tahoma',
          ),
          'Times New Roman' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Times New Roman',
          ),
          'Trebuchet MS' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Trebuchet MS',
          ),
          'Verdana' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'Verdana',
          ),
          'End Stack' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //ARABIC FONTS - 41
          'Arabic' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Alexandria' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Alkalami' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Almarai' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Amiri' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'AraJozoor-Regular' => array(
            'styles' => '400',
            'character_set' => 'embedded',
            'type' => 'arabic-sans',
          ),
          'Aref Ruqaa' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Baloo Bhaijaan' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Beiruti' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Blaka' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Cairo' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Changa' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Dubai-Regular' => array(
            'styles' => '400',
            'character_set' => 'embedded',
            'type' => 'arabic-sans',
          ),
          'El Messiri' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Fustat' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Gulzar' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Handjet' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Harmattan' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'IBM Plex Sans Arabic' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'JF Flat' => array(
            'styles' => '400',
            'character_set' => 'embedded',
            'type' => 'arabic-sans',
          ),
          'Jomhuria' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Katibeh' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'kfc_naskh' => array(
            'styles' => '400',
            'character_set' => 'embedded',
            'type' => 'arabic-serif',
          ),
          'Kufam' => array(
            'styles' => '400, 700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Lalezar' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Lateef' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Lemonada' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Mada' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Marhey' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Markazi Text' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Mirza' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Noto Kufi Arabic' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Noto Naskh Arabic' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Noto Naskh Arabic UI' => array(
            'styles' => '400',
            'character_set' => 'earlyaccess',
            'type' => 'arabic-serif',
          ),
          'Noto Sans Arabic' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-sans',
          ),
          'Noto Nastaliq Urdu' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-sans',
          ),
          'Rakkas' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Readex Pro' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Reem Kufi' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'RobotoCondensed' => array(
            'styles' => '400',
            'character_set' => 'embedded',
            'type' => 'arabic-sans',
          ),
          'Ruwudu' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Qahiri' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Samim' => array(
            'styles' => '400, 700',
            'character_set' => 'embedded',
            'type' => 'arabic-sans',
          ),
          'Scheherazade New' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Simplified Arabic' => array(
            'styles' => '400',
            'character_set' => 'stack',
            'type' => 'arabic-serif',
          ),
          'Tajawal' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'Thabit' => array(
            'styles' => '400',
            'character_set' => 'earlyaccess',
            'type' => 'arabic-serif',
          ),
          'Vazirmatn' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-sans',
          ),
          'Zain' => array(
            'styles' => '400,700',
            'character_set' => 'arabic',
            'type' => 'arabic-sans',
          ),
          'End Arabic' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //LATIN FONTS

          //SANS_SERIF - 26
          'Sans-serif' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Abel' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ),
          'Afacad Flux' => array(
            'styles' => '400,700',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ),
          'Arimo' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,latin-ext,greek-ext,cyrillic,greek,vietnamese',
            'type' => 'sans-serif',
          ),
          'Comfortaa' => array(
            'styles' => '400,700',
            'character_set' => 'latin,cyrillic-ext,greek,latin-ext,cyrillic',
            'type' => 'cursive',
          ), //v
          'Cuprum' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,latin-ext,cyrillic',
            'type' => 'sans-serif',
          ),
          'Dosis' => array(
            'styles' => '400,700',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ), //v
          'Francois One' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ),
          'Fredoka' => array(
            'styles' => '400,700',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ),
          'Lato' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ),
          'Merriweather Sans' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ),
          'Montserrat' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ),
          'Nunito' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ),
          'Open Sans' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,greek-ext,greek,vietnamese,latin-ext,cyrillic',
            'type' => 'sans-serif',
          ),
          'Open Sans Condensed' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,latin-ext,greek-ext,greek,vietnamese,cyrillic',
            'type' => 'sans-serif',
          ),
          'Oswald' => array(
            'styles' => '400,700',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ), //v
          'Play' => array(
            'styles' => '400,700',
            'character_set' => 'latin,cyrillic-ext,cyrillic,greek-ext,greek,latin-ext',
            'type' => 'sans-serif',
          ),
          'PT Sans' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,latin-ext,cyrillic',
            'type' => 'sans-serif',
          ),
          'PT Sans Narrow' => array(
            'styles' => '400,700',
            'character_set' => 'latin,latin-ext,cyrillic',
            'type' => 'sans-serif',
          ),
          'Quattrocento Sans' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ),
          'Raleway' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ), //v
          'Roboto' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,latin-ext,cyrillic,greek-ext,greek,vietnamese',
            'type' => 'sans-serif',
          ),
          'Roboto Condensed' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,latin-ext,greek-ext,cyrillic,greek,vietnamese',
            'type' => 'sans-serif',
          ),
          'Source Sans Pro' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ),
          'Spartan' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ), //v
          'Tenor Sans' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext,cyrillic',
            'type' => 'sans-serif',
          ),
          'Ubuntu' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,cyrillic,greek-ext,greek,latin-ext',
            'type' => 'sans-serif',
          ),
          'Work Sans' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ), //v
          'Yanone Kaffeesatz' => array(
            'styles' => '400,700',
            'character_set' => 'latin,latin-ext',
            'type' => 'sans-serif',
          ), //v
          'End Sans-serif' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //SLAB-SERIF - 11
          'Serif-slab' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Arvo' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Bree Serif' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'serif',
          ),
          'Bitter' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,latin-ext',
            'type' => 'serif',
          ), //v
          'Crete Round' => array(
            'styles' => '400,400italic',
            'character_set' => 'latin,latin-ext',
            'type' => 'serif',
          ),
          'Josefin Slab' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Kreon' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'serif',
          ), //v
          'Noticia Text' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,vietnamese,latin-ext',
            'type' => 'serif',
          ),
          'Rokkitt' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'serif',
          ), //v
          'Sanchez' => array(
            'styles' => '400,400italic',
            'character_set' => 'latin,latin-ext',
            'type' => 'serif',
          ),
          'Slabo 27px' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Zilla Slab' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'End Serif-slab' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //SERIF - 18
          'Serif' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Antic Didone' => array(
            'styles' => '400,400italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Caladea' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Cantata One' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'serif',
          ),
          'Cardo' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,greek-ext,greek,latin-ext',
            'type' => 'serif',
          ),
          'Cormorant Garamond' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Crimson Text' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Judson' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Libre Baskerville' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Lora' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ), //v
          'Merriweather' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Old Standard TT' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Playfair Display' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,latin-ext,cyrillic',
            'type' => 'serif',
          ), //v
          'Playfair Display SC' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,latin-ext,cyrillic',
            'type' => 'serif',
          ),
          'PT Serif' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic',
            'type' => 'serif',
          ),
          'Quattrocento' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Spectral' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Vollkorn' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ), //v
          'Vollkorn SC' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'End Serif' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //MONOSPACE - 10
          'Monospace' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Anonymous Pro' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'monospace',
          ),
        /* edit */
          'IBM Plex Mono' => array(
           'styles' 		=> '400,400italic,700,700italic',
           'character_set' => 'latin',
           'type'			=> 'monospace',
          ),
          'Inconsolata' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'monospace',
          ), //v
        /* edit */
          'Courier Prime' => array(
            'styles' 		=> '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type'			=> 'monospace',
           ),
        /* edit */
          'Roboto Mono' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,latin-ext,cyrillic,greek-ext,greek,vietnamese',
            'type' => 'monospace',
          ), //v
        /* edit */
          'Source Code Pro' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin,cyrillic-ext,latin-ext,cyrillic,greek-ext,greek,vietnamese',
            'type' => 'monospace',
          ),
          'Space Mono' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'monospace',
          ),
        /* edit */
          'Ubuntu Mono' => array(
            'styles' 		=> '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type'			=> 'monospace',
           ),
        /* edit */
           'VT323' => array(
            'styles' 		=> '400',
            'character_set' => 'latin',
            'type'			=> 'monospace',
           ),
        /* edit */
          'Xanh Mono' => array(
            'styles' => '400,400italic',
            'character_set' => 'latin',
            'type' => 'monospace',
          ),
          'End Monospace' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //DECORATIVE, DISPLAY, FATFACE - 25
          'Display' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Abril Fatface' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'cursive',
          ),
          'Aclonica' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ),
          'Artifika' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Bevan' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Black Ops One' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'cursive',
          ),
          'Boogaloo' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Changa One' => array(
            'styles' => '400,400italic',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Cherry Cream Soda' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Chewy' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Fredericka the Great' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Fredoka One' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Gravitas One' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Happy Monkey' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'cursive',
          ),
          'Lobster' => array(
            'styles' => '400',
            'character_set' => 'latin,cyrillic-ext,latin-ext,cyrillic',
            'type' => 'cursive',
          ),
          'Lobster Two' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Luckiest Guy' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Metamorphous' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'cursive',
          ),
          'Nova Square' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Passion One' => array(
            'styles' => '400,700',
            'character_set' => 'latin,latin-ext',
            'type' => 'cursive',
          ),
          'Poiret One' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext,cyrillic',
            'type' => 'cursive',
          ),
          'Righteous' => array(
            'styles' => '400',
            'character_set' => 'latin,latin-ext',
            'type' => 'cursive',
          ),
          'Special Elite' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Squada One' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Tangerine' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Unkempt' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'End Decorative' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //CURSIVE & HANDWRITING - 19
          'Cursive' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Amatic SC' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Calligraffitti' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Coming Soon' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Covered By Your Grace' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Crafty Girls' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Dancing Script' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Gloria Hallelujah' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Indie Flower' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Leckerli One' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Pacifico' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Patrick Hand' => array(
            'styles' => '400',
            'character_set' => 'latin,vietnamese,latin-ext',
            'type' => 'cursive',
          ),
          'Permanent Marker' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Reenie Beanie' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Rock Salt' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Satisfy' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Schoolbell' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Shadows Into Light' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'The Girl Next Door' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'Walter Turncoat' => array(
            'styles' => '400',
            'character_set' => 'latin',
            'type' => 'cursive',
          ),
          'End Cursive' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),

          //deprecated/ moved or deleted from source.
          'Deprecated' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
          'Droid Arabic Kufi' => array(
            'styles' => '400,700',
            'character_set' => 'earlyaccess',
            'type' => 'arabic-serif',
          ),
          'Droid Arabic Naskh' => array(
            'styles' => '400,700',
            'character_set' => 'earlyaccess',
            'type' => 'arabic-serif',
          ),
          'Droid Sans' => array(
            'styles' => '400,700',
            'character_set' => 'latin',
            'type' => 'sans-serif',
          ),
          'Droid Serif' => array(
            'styles' => '400,400italic,700,700italic',
            'character_set' => 'latin',
            'type' => 'serif',
          ),
          'Noto Nastaliq Urdu Draft' => array(
            'styles' => '400',
            'character_set' => 'earlyaccess',
            'type' => 'arabic-serif',
          ),
          'Scheherazade' => array(
            'styles' => '400',
            'character_set' => 'arabic',
            'type' => 'arabic-serif',
          ),
          'End Deprecated' => array(
            'styles' => '',
            'character_set' => '',
            'type' => '',
          ),
        );

        return apply_filters('mh_google_fonts', $google_fonts);
    }
endif;

if (! function_exists('mh_get_websafe_font_stack')) :
    //fonts stack
    function mh_get_websafe_font_stack($type = 'sans-serif')
    {
        $font_stack = '';

        switch ($type) {
            case 'sans-serif':
                $font_stack = 'Helvetica, Arial, Lucida, sans-serif';
                break;
            case 'serif':
                $font_stack = 'Georgia, "Times New Roman", serif';
                break;
            case 'cursive':
                $font_stack = 'cursive';
                break;
            case 'arabic-serif':
                $font_stack = 'Tahoma, Arial, "Times New Roman", serif';
                break;
            case 'arabic-sans':
                $font_stack = 'Tahoma, Arial, "Times New Roman", sans-serif';
                break;
            case 'Palatino':
                $font_stack = 'Palatino Linotype,Palatino LT STD,Book Antiqua,Georgia,serif;';
                break;
            case 'Verdana':
                $font_stack = 'Geneva,sans-serif;';
                break;
            case 'Tahoma':
                $font_stack = 'Verdana,Segoe,sans-serif;';
                break;
            case 'Trebuchet MS':
                $font_stack = 'Lucida Grande,Lucida Sans Unicode,Lucida Sans,Tahoma,sans-serif;';
                break;
            case 'Georgia':
                $font_stack = 'Times,Times New Roman,serif;';
                break;
            case 'Arial':
                $font_stack = 'Helvetica Neue,Helvetica,sans-serif;';
                break;
            case 'Arial Black':
                $font_stack = 'Arial Bold,Gadget,sans-serif;';
                break;
            case 'Times New Roman':
                $font_stack = 'TimesNewRoman,Times,Baskerville,Georgia,serif;';
                break;
            case 'Courier':
                $font_stack = 'Courier New,Lucida Sans Typewriter,Lucida Typewriter,monospace;';
                break;
            case 'Baskerville':
                $font_stack = 'Baskerville Old Face,Hoefler Text,Garamond,Times New Roman,serif;';
                break;
            case 'Lucida Bright':
                $font_stack = 'Georgia,serif;';
                break;
            case 'Simplified Arabic':
                $font_stack = ';';
        }

        return $font_stack;
    }
endif;

if (! function_exists('mh_gf_attach_font')) :
    function mh_gf_attach_font($mh_gf_font_name, $elements)
    {
        $google_fonts = mh_get_google_fonts();

        printf(
            '%s { font-family: \'%s\', %s; }',
            esc_html($elements),
            esc_html($mh_gf_font_name),
            mh_get_websafe_font_stack($google_fonts[$mh_gf_font_name]['type'])
        );
    }
endif;

if (! function_exists('mh_gf_enqueue_fonts')) :
    function mh_gf_enqueue_fonts($mh_gf_font_names)
    {

        if (! is_array($mh_gf_font_names) || empty($mh_gf_font_names)) {
            return;
        }

        $google_fonts = mh_get_google_fonts();
        $protocol = is_ssl() ? 'https' : 'http';

        foreach ($mh_gf_font_names as $mh_gf_font_name) {
            $google_font_character_set = $google_fonts[$mh_gf_font_name]['character_set'];
            // By default, only latin and latin-ext subsets
            // All available subsets for some fonts can be enabled in Theme Panel
            // Also, do not subset for Arabic, embeded or system fonts
            if (false == mh_get_option('mharty_gf_enable_all_character_sets', false) && false !== strpos($google_fonts[$mh_gf_font_name]['character_set'], 'latin')) {
                $latin_ext = '';
                if (false !== strpos($google_fonts[$mh_gf_font_name]['character_set'], 'latin-ext')) {
                    $latin_ext = ',latin-ext';
                }

                $google_font_character_set = "latin{$latin_ext}";
            }
            $query_args = array(
                'family' => sprintf(
                    '%s:%s&display=swap',
                    str_replace(' ', '+', $mh_gf_font_name),
                    apply_filters('mh_gf_set_styles', $google_fonts[$mh_gf_font_name]['styles'], $mh_gf_font_name)
                ),
                'subset' => apply_filters('mh_gf_set_character_set', $google_font_character_set, $mh_gf_font_name),
            );
            // if it is a google font
            if (false !== strpos($google_fonts[$mh_gf_font_name]['character_set'], 'latin')) {
                $mh_gf_font_name_slug = strtolower(str_replace(' ', '-', $mh_gf_font_name));
                wp_enqueue_style('mh-gf-' . $mh_gf_font_name_slug, esc_url(add_query_arg($query_args, "$protocol://fonts.googleapis.com/css")), array(), null);
                //if it is an arabic google font
            } elseif (false !== strpos($google_fonts[$mh_gf_font_name]['character_set'], 'arabic')) {
                $mh_gf_font_name_slug = strtolower(str_replace(' ', '-', $mh_gf_font_name));
                wp_enqueue_style('mh-gf-' . $mh_gf_font_name_slug, esc_url(add_query_arg($query_args, "$protocol://fonts.googleapis.com/css")), array(), null);
                // if it is a earlyaccess font
            } elseif (false !== strpos($google_fonts[$mh_gf_font_name]['character_set'], 'earlyaccess')) {
                $mh_gf_font_name_slug = strtolower(str_replace(' ', '', $mh_gf_font_name));
                wp_enqueue_style('mh-gf-' . $mh_gf_font_name_slug, "$protocol://fonts.googleapis.com/earlyaccess/$mh_gf_font_name_slug.css", array(), null);
                //if it is an embedded font
            } elseif (false !== strpos($google_fonts[$mh_gf_font_name]['character_set'], 'embedded')) {
                $mh_gf_font_name_slug = strtolower(str_replace(' ', '', $mh_gf_font_name));
                $theme_uri = get_template_directory_uri();
                wp_enqueue_style('mh-gf-' . $mh_gf_font_name_slug, "$theme_uri/css/fonts/$mh_gf_font_name_slug.css", array(), null);

            } //if it is a stack font do nothing.
        }
    }
endif;

/**
 * custom font per language
 */
function mh_get_language_fonts()
{
    $fonts_per_locale = array(
        'ar' => array(
            'language_name'   => 'Arabic',
            'google_font_url' => '//fonts.googleapis.com/css?family=Noto+Kufi+Arabic:400,700&display=swap&subset=arabic',
            'h'     => "'Noto Kufi Arabic', Tahoma, Geneva, sans-serif", //header
            'body'  => "Tahoma, Geneva, sans-serif" //body
        ),
    );

    return $fonts_per_locale;
}

/**
 * get default fonts
 */
function mh_get_default_fonts()
{
    $default_fonts = array(
        'h' => array(
            'font_name'	   => 'Raleway',
            'google_font_url' => '//fonts.googleapis.com/css?family=Raleway:400,700&display=swap',
            'font_family'     => "'Raleway', Helvetica, Arial, sans-serif"
        ),
        'body' => array(
            'font_name'   => 'Open Sans',
            'google_font_url' => '//fonts.googleapis.com/css?family=Open+Sans:400,700,400italic,700italic&display=swap',
            'font_family'     => "'Open Sans', Helvetica, Arial, sans-serif"
        ),
    );

    return $default_fonts;
}
