<?php
if ( ! defined( 'ABSPATH' ) ) { die( '-1' );}
/**
 * Get the author avatar
 */
if ( ! function_exists( 'mh_get_the_author_avatar' ) ) :
function mh_get_the_author_avatar($size = false){
	global $authordata;

	$link = sprintf(
		'<a class="mh_author_avatar_40" href="%1$s">%2$s</a>',
		esc_url( get_author_posts_url( $authordata->ID, $authordata->user_nicename ) ),
		get_avatar( get_the_author_meta('email'), $size )
	);
	return apply_filters( 'the_author_posts_link', $link );
}
endif;

/**
 * Get the author link
 */
if ( ! function_exists( 'mh_get_the_author_posts_link' ) ) :
function mh_get_the_author_posts_link(){
	global $authordata;

	$link = sprintf(
		'<a class="mh_author_link" href="%1$s" title="%2$s" rel="author">%3$s</a>',
		esc_url( get_author_posts_url( $authordata->ID, $authordata->user_nicename ) ),
		esc_attr( sprintf( __( 'Posts by %s', 'mharty' ), get_the_author() ) ),
		get_the_author()
	);
	return apply_filters( 'the_author_posts_link', $link );
}
endif;

/**
 * Get the author popup_link
 */
if ( ! function_exists( 'mh_get_comments_popup_link' ) ) :
function mh_get_comments_popup_link( $zero = false, $one = false, $more = false ){

	$id = get_the_ID();
	$number = get_comments_number( $id );

	if ( 0 == $number && !comments_open() && !pings_open() ) return;

	if ( $number > 1 )
		$output = str_replace('%', number_format_i18n($number), ( false === $more ) ? __('% Comments', 'mharty') : $more);
	elseif ( $number == 0 )
		$output = ( false === $zero ) ? __('0 Comments', 'mharty') : $zero;
	else // must be one
		$output = ( false === $one ) ? __('1 Comment', 'mharty') : $one;

	do_action( 'mh_before_comments_number');
	
	$link = '<span class="comments-number">' . '<a href="' . esc_url( get_permalink() . '#respond' ) . '">' . apply_filters('comments_number', esc_html( $output ), esc_html( $number ) ) . '</a>' . '</span>';

	do_action( 'mh_after_comments_number');

	return $link;
	
}
endif;

/**
 * Get the post meta info separator
 */
if ( ! function_exists( 'mh_get_post_info_sep' ) ) :
function mh_get_post_info_sep(){
		$postinfosep =  esc_html( get_theme_mod( 'mharty_postinfo_sep', ' | ' ) );
        return $postinfosep;
}
endif;

/**
 * Get the pre author string
 */
if ( ! function_exists( 'mh_get_post_author_pre' ) ) :
function mh_get_post_author_pre(){
		$postinfopre =  esc_html( get_theme_mod( 'mharty_postinfo_pre' ) );
        return $postinfopre;
}
endif;

/**
 * Post meta
 */
if ( ! function_exists( 'mh_postinfo_meta' ) ) :
function mh_postinfo_meta( $postinfo, $date_format, $comment_zero, $comment_one, $comment_more){
	$postinfostyle = get_theme_mod('mharty_postinfo1_style' );
	$postinfo_meta = '';

	if ( in_array( 'avatar', $postinfo ) )
		$postinfo_meta .=  mh_get_the_author_avatar('40');
		
	if (true === $postinfostyle){
		$postinfo_meta .= '<div class="post-meta-inline">';
	}
	if ( in_array( 'author', $postinfo ) )
		$postinfo_meta .= ' ' . mh_get_post_author_pre() . ' ' . mh_get_the_author_posts_link();
	if (true === $postinfostyle){
		$postinfo_meta .= '<p>';
	}
	if ( in_array( 'date', $postinfo ) ) {
		if ( in_array( 'author', $postinfo ) && true !== $postinfostyle){
				$postinfo_meta .= mh_get_post_info_sep();
		}
		$postinfo_meta .= esc_html( get_the_time( wp_unslash( $date_format ) ) );
	}
	if ( in_array( 'categories', $postinfo ) ){
		$categories_list = sprintf( '%1$s', is_rtl() ? get_the_category_list('، ') : get_the_category_list(', ') );
		// do not output anything if no categories retrieved
		if ( '' !== $categories_list ) {
			if ( (in_array( 'author', $postinfo ) && true !== $postinfostyle) || in_array( 'date', $postinfo ) ) 
			$postinfo_meta .= mh_get_post_info_sep();
			
			$postinfo_meta .= $categories_list;
		}
	}

	if ( in_array( 'comments', $postinfo ) ){
		if ( in_array( 'author', $postinfo ) || in_array( 'date', $postinfo ) || in_array( 'categories', $postinfo ) ) 			
		$postinfo_meta .= mh_get_post_info_sep();
		$postinfo_meta .= mh_get_comments_popup_link( $comment_zero, $comment_one, $comment_more );
	}
	
	if (function_exists('the_views')){
		if ( in_array( 'author', $postinfo ) || in_array( 'date', $postinfo ) || in_array( 'categories', $postinfo ) || in_array( 'comments', $postinfo ) ) $postinfo_meta .= mh_get_post_info_sep();
		$postinfo_meta .= '<span class="mhc_the_views">' . do_shortcode('[views]') . '</span>';
	}
	
	if (true === $postinfostyle){
			$postinfo_meta .= '</p></div>';
		}
	return $postinfo_meta;
}
endif;

/**
 * Post meta styles
 */
if ( ! function_exists( 'mh_mharty_post_meta' ) ) :
function mh_mharty_post_meta() {
	$mharty_postinfo1 = !is_array( get_theme_mod( 'mharty_postinfo1' ) ) ? explode( ',', get_theme_mod( 'mharty_postinfo1' ) ) : get_theme_mod( 'mharty_postinfo1' );
	$mharty_postinfo2 = !is_array( get_theme_mod( 'mharty_postinfo2' ) ) ? explode( ',', get_theme_mod( 'mharty_postinfo2' ) ) : get_theme_mod( 'mharty_postinfo2' );
	$postinfo = is_single() ? $mharty_postinfo2 : $mharty_postinfo1;
	$postinfostyle =  get_theme_mod('mharty_postinfo1_style' );
	$date = '' !== get_theme_mod( 'mharty_date_format') ? get_theme_mod( 'mharty_date_format', 'd/m/Y' ): 'd/m/Y';
	if ( $postinfo ) :
		$output = sprintf( '<div class="post-meta%2$s">%1$s</div>',
			mh_postinfo_meta( $postinfo, $date , esc_html__( 'Leave a comment', 'mharty' ), esc_html__( '1 comment', 'mharty' ), '% ' . esc_html__( 'comments', 'mharty' ) ),
			(true === $postinfostyle ? ' post-meta-alt' : '')
			
		);
		echo $output;
	endif;
}
endif;

/**
 * Portfolio meta
 */
if ( ! function_exists( 'mhc_portfolio_meta_box' ) ) :
function mhc_portfolio_meta_box() { ?>
	<div class="mh_project_meta">
  		<?php if(function_exists('mh_loveit') && true === get_theme_mod( 'mharty_project_show_loveit', true )) mh_loveit(); ?>
		
		<?php 
		$mh_project_tag_title = ( '' !== get_theme_mod('mharty_project_tag_title', '') ? esc_html( get_theme_mod('mharty_project_tag_title') ) : esc_html__('Skills', 'mharty' ));
		echo get_the_term_list( get_the_ID(), 'project_tag', '<p><strong class="mh_project_meta_title">' . $mh_project_tag_title .'</strong>', mh_wp_kses( _x( ' ,', 'This is a comma preceded by a space.', 'mharty') ), '</p>'); ?>

		<strong class="mh_project_meta_title"><?php echo esc_html__( 'Posted on', 'mharty' ); ?></strong>
		<p><?php echo get_the_date(); ?></p>
	</div>
<?php }
endif;