<?php
if ( !defined( 'ABSPATH' ) ) { die( '-1' ); }
/**
 * Migrate theme options to theme_mod
 * since 10.0.0
 */
if ( !function_exists( 'mharty_theme_migrate_options' ) ) {
  function mharty_theme_migrate_options() {
    $migrated = get_theme_mod( 'mh_migrate_options_6', 'no' );
    $mh_theme_options = get_option( 'mh_mharty' );
    if ( 'yes' !== $migrated && !empty( $mh_theme_options ) ) {

      $theme_panel_options = array(
        'mharty_color_scheme',
        'mharty_google_maps_api_key',
        'mharty_mailchimp_api_key',
        'mharty_regenerate_mailchimp_lists',
        'mharty_customizer_dark_mode',
        'mharty_scroll_to_anchor_fix',
        'mharty_smooth_scroll',
        'mharty_disable_toptier',
        'mharty_gf_enable_all_character_sets',
        'mharty_integrate_header_enable',
        'mharty_integration_head',
        'mharty_integrate_body_enable',
        'mharty_integration_body',
        'mharty_integrate_singletop_enable',
        'mharty_integration_single_top',
        'mharty_integrate_singlebottom_enable',
        'mharty_integration_single_bottom',
        'mharty_seo_home_title',
        'mharty_seo_home_description',
        'mharty_seo_home_keywords',
        'mharty_seo_home_titletext',
        'mharty_seo_home_descriptiontext',
        'mharty_seo_home_keywordstext',
        'mharty_seo_home_type',
        'mharty_seo_home_separate',
        'mharty_seo_home_canonical',
        'mharty_seo_single_title',
        'mharty_seo_single_description',
        'mharty_seo_single_keywords',
        'mharty_seo_single_field_title',
        'mharty_seo_single_field_description',
        'mharty_seo_single_field_keywords',
        'mharty_seo_single_type',
        'mharty_seo_single_separate',
        'mharty_seo_single_canonical',
        'mharty_seo_index_description',
        'mharty_seo_index_type',
        'mharty_seo_index_separate',
        'mharty_seo_index_canonical',
        'mharty_use_steadysets',
        'mharty_use_awesome',
        'mharty_use_lineicons',
        'mharty_use_etline',
        'mharty_use_icomoon',
        'mharty_use_linearicons',
      );

      foreach ( $mh_theme_options as $key => $value ) {

        if ( 'off' === $value ) {
          $value = false;
        } elseif ( 'on' === $value ) {
          $value = true;
        } elseif ( 'false' === $value ) {
          $value = false;
        }
			
			if ('mharty_activate_id' === $key){
				if ( !empty( $value ) ){
					update_option( 'mharty_activation_key', trim($value) );
				}
			}elseif ( in_array( $key, $theme_panel_options ) ) {
          mh_update_option( $key, $value );
        } else {
          set_theme_mod( $key, $value );
        }
      }

      if ( '' !== get_theme_mod( 'mharty_custom_css' ) ) {
        $get_customizer_custom_css = get_theme_mod( 'customizer_custom_css' );
        $get_mharty_custom_css = get_theme_mod( 'mharty_custom_css' );

        $all_css_value = $get_mharty_custom_css . $get_customizer_custom_css;
        set_theme_mod( 'customizer_custom_css', $all_css_value );
      }
    }

    set_theme_mod( 'mh_migrate_options_6', 'yes' );
  }
}
add_action( 'admin_init', 'mharty_theme_migrate_options' );