<?php
if ( !defined( 'ABSPATH' ) )exit;

function mh_show_admin_notices() {
  $notices = array(
    'updated' => array(),
    'error' => array(),
  );

  if ( (in_array('composer', mharty_active_plugins()) && in_array('classiceditor', mharty_active_plugins() ) && in_array('classicwidgets', mharty_active_plugins() )) && 'valid' !== get_option( 'mharty_activation_key_status', '' )  && 'expired' !== get_option( 'mharty_activation_key_status', '' ) && current_user_can( 'switch_themes' ) && !get_user_meta( get_current_user_id(), '_mh_activation_key_dismissed' ) ) {
    ob_start();
    ?>
<div class="update-nag mh-update-nag mh-activation-notice">
  <p><?php printf ( __( 'Hello, %s to get all premium features and important updates.', 'mharty' ),
		sprintf ('<a href="%1$s">%2$s</a>',
    admin_url( 'admin.php?page=mh_start' ),
		__('validate your Licence Key now', 'mharty')
						)
  );
  ?></p>
  </div>
<?php
    echo ob_get_clean();
    }

  if ( (!in_array('composer', mharty_active_plugins())  || !in_array('classiceditor', mharty_active_plugins() ) || !in_array('classicwidgets', mharty_active_plugins() )) && current_user_can( 'switch_themes' ) && !get_user_meta( get_current_user_id(), '_mh_required_plugins_dismissed' ) ) {
    ob_start();
    ?>
  <div class="update-nag mh-update-nag mh-activation-notice">
    <p><?php printf ( __( 'Get started now by <a href="%1$s">installing required plugins</a>.', 'mharty' ),
      admin_url( 'admin.php?page=mh_start' )
    );
  ?></p>
  </div>
  <?php
  echo ob_get_clean();
  }

  if ( 'expired' === get_option( 'mharty_activation_key_status', '' ) && current_user_can( 'switch_themes' ) && !get_user_meta( get_current_user_id(), '_mh_required_plugins_dismissed' ) ) {
    ob_start();
    $login = 'https://mharty.com/vip';
    ?>
  <div class="update-nag mh-update-nag mh-expired-notice mh-activation-notice">
    <p><?php printf( __( 'Your theme subscription has expired. Please <a href="%1$s" title="Renew your subscription" target="_blank">login</a> and renew it today to access important updates and all premium features.', 'mharty' ), $login );
  ?></p>
  </div>
  <?php
  echo ob_get_clean();
  }

if ( count( $notices[ 'updated' ] ) > 0 ) {
  foreach ( $notices[ 'updated' ] as $notice => $message ) {
    add_settings_error( 'mh-notices', $notice, $message, 'updated' );
  }
}

if ( count( $notices[ 'error' ] ) > 0 ) {
  foreach ( $notices[ 'error' ] as $notice => $message ) {
    add_settings_error( 'mh-notices', $notice, $message, 'error' );
  }
}

settings_errors( 'mh-notices' );
}
add_action( 'admin_notices', 'mh_show_admin_notices' );

function mh_dismiss_admin_notices() {
  if ( isset( $_GET[ 'mh_notice' ] ) ) {
    update_user_meta( get_current_user_id(), '_mh_' . $_GET[ 'mh_notice' ] . '_dismissed', 1 );
    wp_redirect( remove_query_arg( array( 'mh_action', 'mh_notice' ) ) );
    exit;
  }
}
add_action( 'mh_dismiss_admin_notices', 'mh_dismiss_admin_notices' );