<?php
if ( !defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Breadcrumbs Shortcode
 * [mh_breadcrumbs show_title="true" separator="/" ]
 */
function mh_breadcrumbs_shortcode( $atts ) {
  extract( shortcode_atts( array(
    'show_title' => true,
    'separator' => mh_wp_kses( _x( ' / ', 'This is the breadcrumb separator.', 'mharty' ) )
  ), $atts ) );
  return mh_breadcrumb( array(
    'show_browse' => false,
    'separator' => $separator,
    'show_home' => esc_html__( 'Home', 'mharty' ),
    'echo' => false,
    'post_taxonomy' => array(
      'post' => 'category',
    ),
    'rich_snippet' => true === get_theme_mod( 'mharty_enable_breadcrumbs_rich_snippet', true ) ? true : false,
    'show_title' => $show_title,
  ) );
}
add_shortcode( 'mh_breadcrumbs', 'mh_breadcrumbs_shortcode' );
/**
 * Search Bar Shortcode
 * [mh_search_bar placeholder="Search &hellip;" post_type="all"]
 */
function mh_search_bar_shortcode( $atts ) {
  extract( shortcode_atts( array(
    'placeholder' => esc_html__( 'Search &hellip;', 'mharty' ),
    'post_type' => 'all',
  ), $atts ) );
  
  $output = sprintf(
    '<div class="mhc_search_bar mh_search_bar_shortcode mh_adjust_corners clearfix">
				<div class="mhc_search_bar_inner">
					<form role="search" method="get" class="mhc_search_bar_form mh-hidden" action="%1$s">
						<div class="mhc_search_bar_input">
							<input id="s" type="search" class="mhc_search_bar_field mh_adjust_corners" autocomplete="off" placeholder="%2$s" value="%3$s" name="s" title="%4$s" />
							<span class="mhc_search_bar_btn">
								<button type="submit" class="button mhc_search_bar_submit"><i class="mh-icon-before"></i></button>
							</span>
							%5$s
						</div>
					</form>
				</div>
			</div> <!-- .mhc_search_bar -->',
    esc_url( home_url( '/' ) ),
    $placeholder,
    get_search_query(),
    esc_html__( 'Search for:', 'mharty' ),
    'all' !== $post_type ? sprintf(
      '<input type="hidden" value="%1$s" name="post_type" id="post_type" />', esc_attr( $post_type )
    ) : ''
  );

  return $output;

}
add_shortcode( 'mh_search_bar', 'mh_search_bar_shortcode' );
/**
 * Single Post Tags Shortcode
 * [mh_post_tags]
 */
function mh_post_tags_shortcode() {
  //works only on posts
  if ( !is_singular( array( 'post' ) ) ) return;

  ob_start();
  the_tags( '<div class="mh-tags mh-tags-shortcode"><span class="tag-links">', '', '</span></div>' );
  $output = ob_get_clean();
  return $output;
}
add_shortcode( 'mh_post_tags', 'mh_post_tags_shortcode' );

/**
 * Single Related Posts Shortcode
 * [mh_post_related]
 * see mh_function.php
 */
  function mh_related_posts_shortcode() {
    global $post;
    if ( is_attachment() ) return;
    if ( !is_singular(array('post')) ) return;
  
    $current_post = get_the_ID();
    $categories = is_singular('post') ? get_the_category() : '';
    $cat = $related_title = '';
    if ( ! empty($categories) ) {
      foreach ($categories as $category) :
      $cat = $category->term_id;
      endforeach;
      if (is_singular('post')){
        $related_title = get_theme_mod( 'mharty_related_posts_title' );
        $related_count = get_theme_mod( 'mharty_related_posts_count', 3 );
        $args = array(
        'category__and' => $cat,
        'posts_per_page' => $related_count,
        'post__not_in' => array($post->ID),
        'ignore_sticky_posts' => 1,
        'post_status' => 'publish',
        );
      }else{
        $related_title = get_theme_mod( 'mharty_related_projects_title' );
        $related_count = get_theme_mod( 'mharty_related_projects_count', 3 );
        $args = array(
        'post_type'      => 'project',
        'posts_per_page' => $related_count,
        'post__not_in' => array($post->ID),
        'ignore_sticky_posts' => 1,
        'post_status' => 'publish',
        'tax_query' => array( 
          array(
            'taxonomy' => 'project_category',
            'field' => 'id',
            'terms' => explode( ',', $cat ),
            'operator' => 'IN',
          )
        ),
        );
      }
      $related = new WP_Query( $args );
      ob_start();
        if ( $related-> have_posts() ) :?>
          <div id="mh-related-posts" class="mh_list_posts">
        <?php  if ( '' !== $related_title ) {
              echo '<h2>' . $related_title . '</h2>';
        } ?>
      <ul>
        <?php
          while ( $related-> have_posts() ) : $related -> the_post(); ?> 
        <li class="list-post">
        
        <?php 
        //get the thumbnail
        $thumb = '';
        $width = 80;
        $width = (int) apply_filters( 'mhc-post-thumbnail', $width );
        $height = 80;
        $height = (int) apply_filters( 'mhc-post-thumbnail', $height );
        $classtext = '';
        $titletext = get_the_title();
        $thumbnail = get_thumbnail( $width, $height, $classtext, $titletext, $titletext, false, 'Blogimage' );
        $thumb = $thumbnail["thumb"];
        $no_thumb_class = '';
      
        //thumbnail class
        if ( '' === $thumb ){
          $no_thumb_class = ' post-no-thumb';
        }
        
        if ( '' !== $thumb  ) : ?>
        <a class="list-post-thumb" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
        <?php print_thumbnail( $thumb, $thumbnail["use_timthumb"], $titletext, $width, $height ); ?>
        </a>
        <?php endif; ?>
              <div class="list-post-info <?php echo $no_thumb_class; ?>">
              
          <h4 class="list-post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a><?php mh_after_post_title(); ?></h4>
              <div class="list-post-content">
                <?php echo get_the_excerpt() ?>
              <?php
          $readbutton = get_theme_mod('mharty_readmore_button', false);
          $more = sprintf(
            '%5$s <a href="%1$s" class="more-link%4$s" title="%2$s">%3$s</a>%6$s',
              esc_url( get_permalink() ),
              esc_attr( get_the_title() ),
              apply_filters( 'mh_read_more_text_filter', esc_html__( 'Read more', 'mharty' )),
              true === $readbutton ? ' mhc_contact_submit' : '',
              true === $readbutton ? '<div class="mhc_more_link">' : '',
              true === $readbutton ? '</div>' : ''
            );
           echo $more;
          ?>
              </div>
          
            </div>
            </li>
      <?php  endwhile;  ?>
      </ul></div>
      <?php endif; 
      wp_reset_postdata();
      $posts = ob_get_clean();
      return $posts;
    } 
  }
  add_shortcode( 'mh_post_related', 'mh_related_posts_shortcode' );