<?php
function mh_site_status(){ 
global $wpdb;
?>

<div class="mh-site-status-wrapper">
		<h3><?php esc_html__( 'Site Status', 'mharty' );?></h3>
		<?php
		$statuses = array();

		//php version
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';
		$php_version = PHP_VERSION;
		$message     = $php_version;
		$recommendation = '| ' . esc_html__( 'WordPress recommends PHP 7.4', 'mharty' );
						  
		if ( version_compare( $php_version, '7.4', '<' ) ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$recommendation = '| ' . esc_html__( 'You are using an unsupported version of PHP. WordPress recommends PHP 7.4', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'PHP Version', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation' => $recommendation,
		);

		//Memory limit
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';
		$memory      = ini_get( 'memory_limit' );
		$message     = $memory;
		$recommendation     = '';				  
		if ( $memory < 128 ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$recommendation   = '| ' . esc_html__( 'For best experience, we recommend increasing "memory_limit" to at least 128M.', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'PHP Memory limit', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation' => $recommendation,
		);

		//max execution time
		$message     = '';
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';

		$time_limit = @ini_get( 'max_execution_time' );
		$message    = $time_limit;
		$recommendation     = '';

		if ( $time_limit < 180 && $time_limit != 0 ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$recommendation = '| ' . esc_html__( 'For best experience, we recommend increasing "max_execution_time" to 180.', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'Time limit', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation' => $recommendation,
		);
		
		//Post Max Size
		$message     = '';
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';

		$post_size = @ini_get( 'post_max_size' );
		$message    = $post_size;
		$recommendation     = '';

		if ( $post_size < 64 && $post_size != 0 ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$recommendation = '| ' . esc_html__( 'For best experience, we recommend increasing "post_max_size" to 64M.', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'Post Max Size', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation' => $recommendation,
		);
	
		// Upload Max Size
		$message     = '';
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';

		$upload_limit = @ini_get( 'upload_max_filesize' );
		$message    = $upload_limit;
		$recommendation     = '';

		if ( $upload_limit < 64 && $upload_limit != 0 ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$recommendation = '| ' . esc_html__( 'For best experience, we recommend increasing "upload_max_filesize" to 64M.', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'Upload Max Size', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation' => $recommendation,
		);	 

		//max input vars
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';
		$input_vars  = ini_get( 'max_input_vars' );

		$message = $input_vars;
		$recommendation     = '';				  
		if ( $input_vars < 2000 ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$recommendation = '| ' . esc_html__( 'For best experience, we recommend increasing "max_input_vars" to 2000.', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'Max Input Vars', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation' => $recommendation,
		);
						  
		// WP DEBUG MODE
		$message     = esc_html__( 'OFF', 'mharty' );
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';
		$recommendation     = '';
						  
		if ( defined( 'WP_DEBUG' ) && WP_DEBUG === true ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$message = 'ON';
			$recommendation = '| ' . esc_html__( 'We recommend disabling WordPress debugging on your live site.', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'WP Debug', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation'     => $recommendation,
		);
		
		//writable directory
		$icon        = 'dashicons-yes';
		$color_class = 'mh-site-status-ok';
		$message     = esc_html__( 'OK', 'mharty' );
		$recommendation = '';

		if ( ! wp_is_writable( WP_CONTENT_DIR ) ) {
			$icon        = 'dashicons-warning';
			$color_class = 'mh-site-status-notok';
			$message     = esc_html__( 'not writable', 'mharty' );
			$recommendation = '| ' . esc_html__( 'wp-content folder is not writable. Please check with your hosting provider.', 'mharty' );
		}

		$statuses[] = array(
			'title'        => esc_html__( 'File permissions', 'mharty' ),
			'icon'        => $icon,
			'color_class' => $color_class,
			'message'     => $message,
			'recommendation' => $recommendation,

		);
		?>
			
		<?php
			
			foreach ( $statuses as $status ) : ?>
			
			<div class="mh-site-status-row">
				<div
					class="mh-site-status-col mh-site-status-col-title"><?php echo esc_html( $status['title'] ); ?></div>
				<div class="mh-site-status-col"><span
						class="mh-site-status-col-icon tooltip-me dashicons-before <?php echo esc_html( $status['icon'] ); ?>"></span></div>
				<div
					class="mh-site-status-col mh-site-status-col-value <?php echo esc_html( $status['color_class'] ); ?>"><?php echo wp_kses_post( $status['message'] ); ?> <span><?php echo wp_kses_post( $status['recommendation'] ); ?></span></div>
			</div>

		<?php endforeach; ?>
</div>
<div class="mh-site-status-advanced-wrapper">
	<h4><?php echo esc_html__( 'Advanced Report', 'mharty' );?></h4>
	<?php
	echo '<a id="mh-site-status-copy">' . esc_html__( 'Copy Report', 'mharty' ) . '</a><span id="mh-site-status-copied" class="mh-site-status-col-icon tooltip-me dashicons-before dashicons-yes"></span>';
	
	$theme_data   = wp_get_theme();
	$theme        = $theme_data->Name . ' ' . $theme_data->Version;
	$parent_theme = $theme_data->Template;
	if ( ! empty( $parent_theme ) ) {
		$parent_theme_data = wp_get_theme( $parent_theme );
		$parent_theme      = $parent_theme_data->Name . ' ' . $parent_theme_data->Version;
	}

			$return  = '### Site Info (Generated ' . date( 'Y-m-d H:i:s' ) . ') ###' . "\n\n";
			foreach ( $statuses as $status ) :
		    $return .= esc_attr( $status['title'] )  . ' ' .wp_kses_post( $status['message'] ) . "\n";
			endforeach;
	
			$return .= "\n" . '-- WordPress & theme' . "\n\n";
						  
			$return .= 'WP Version:                  ' . get_bloginfo( 'version' ) . "\n";
			$return .= 'Language:                 ' . ( !empty( $locale ) ? $locale : 'en_US' ) . "\n";
			$return .= 'Permalink Structure:      ' . ( get_option( 'permalink_structure' ) ? get_option( 'permalink_structure' ) : 'Default' ) . "\n";
			$return .= 'Active Theme:             ' . $theme . "\n";
			if ( $parent_theme !== $theme ) {
				$return .= 'Parent Theme:             ' . $parent_theme . "\n";
			}
		// Get plugins that have an update
	$updates = get_plugin_updates();

	// Must-use plugins //these can't show updates!
	$muplugins = get_mu_plugins();
	if( count( $muplugins ) > 0 ) {
		$return .= "\n" . '-- must-use plugins' . "\n\n";

		foreach( $muplugins as $plugin => $plugin_data ) {
			$return .= $plugin_data['Name'] . ': ' . $plugin_data['Version'] . "\n";
		}
	}

	// WordPress active plugins
	$return .= "\n" . '-- active plugins' . "\n\n";

	$plugins = get_plugins();
	$active_plugins = get_option( 'active_plugins', array() );

	foreach( $plugins as $plugin_path => $plugin ) {
		if( !in_array( $plugin_path, $active_plugins ) )
			continue;

		$update = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[$plugin_path]->update->new_version . ')' : '';
		$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
	}

	// WordPress inactive plugins
	$return .= "\n" . '-- inactive plugins' . "\n\n";

	foreach( $plugins as $plugin_path => $plugin ) {
		if( in_array( $plugin_path, $active_plugins ) )
			continue;

		$update = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[$plugin_path]->update->new_version . ')' : '';
		$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
	}

	if( is_multisite() ) {
		// WordPress Multisite active plugins
		$return .= "\n" . '-- multisite active plugins' . "\n\n";

		$plugins = wp_get_active_network_plugins();
		$active_plugins = get_site_option( 'active_sitewide_plugins', array() );

		foreach( $plugins as $plugin_path ) {
			$plugin_base = plugin_basename( $plugin_path );

			if( !array_key_exists( $plugin_base, $active_plugins ) )
				continue;

			$update = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[$plugin_path]->update->new_version . ')' : '';
			$plugin  = get_plugin_data( $plugin_path );
			$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
		}
	}	
  
  if (get_site_transient( 'mharty_activation_key_error' )){
    // Key activation
    $return .= "\n" . '-- key' . "\n\n";
    $key_error = get_site_transient( 'mharty_activation_key_error' );
    $return .= 'recent key error:             ' . $key_error . "\n";
  }
  
  $return .= "\n" . '### Site Info ###';
  echo '<textarea readonly="readonly" onclick="this.focus(); this.select()" name="mh-site-status-report" id="mh-site-status-report-textarea">' . $return . '</textarea>';
		
	//	} ?>

</div>
<?php
}
add_action('mharty_site_status_hook', 'mh_site_status');