<?php
/**
 * admin styles and scripts
 */
function mh_mharty_post_admin_scripts_styles( $hook ) {
	global $typenow;
	
	$theme_version = mh_get_theme_version();

	if ( ! in_array( $hook, array( 'post-new.php', 'post.php' ) ) ) return;

	if ( ! isset( $typenow ) ) return;
  
  $picker_l10n_strings = array(
    'defaultString' => esc_html__( 'Default', 'mharty' ),
		'clear'         => esc_html__( 'Clear', 'mharty' ),
		'pick'          => esc_html__( 'Select Colour', 'mharty' ),
	);

	if ( in_array( $typenow, array( 'post' ) ) ) {
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'mh-admin-post-script', MHARTY_THEME_ADMIN_ASSETS . 'js/admin_post_settings.js', array( 'jquery', 'wp-color-picker' ), $theme_version, true  );
	}
	if ( in_array( $typenow, array( 'page' ) ) ) {
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'mh-admin-post-script', MHARTY_THEME_ADMIN_ASSETS . 'js/admin_page_settings.js', array( 'jquery', 'wp-color-picker' ), $theme_version, true );
	}
	wp_localize_script( 'mh-admin-post-script', 'mh_admin_settigs', array(
		'default_color_scheme'                    => implode( '|', mh_default_color_scheme() ),
	));
  wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $picker_l10n_strings );
}
add_action( 'admin_enqueue_scripts', 'mh_mharty_post_admin_scripts_styles' );


function mh_is_custom_menu()
{
     if ('nav-menus.php' == basename($_SERVER['PHP_SELF'])) {
          return true;
     }
     return false;
}

function mh_custom_menu_hook() {
  $theme_version = mh_get_theme_version();
	wp_enqueue_script( 'mh-admin-menu-js', MHARTY_THEME_ADMIN_ASSETS . 'js/admin_menu_settings.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_style( 'mh-admin-menu-css', MHARTY_THEME_ADMIN_ASSETS . 'css/admin_menu_settings.css', array(), $theme_version);
    wp_enqueue_media();
}


if ( mh_is_custom_menu() ) {
	add_action( 'admin_init', 'mh_custom_menu_hook' );
}