<?php
/**
 * add wp class to body
 */
function mh_add_wp_version( $classes ) {
  global $wp_version;

  // add 'mh-wp-pre-3_8' class if the current WordPress version is less than 3.8
  if ( version_compare( $wp_version, '3.7.2', '<=' ) ) {
    if ( 'body_class' === current_filter() )
      $classes[] = 'mh-wp-pre-3_8';
    else
      $classes .= 'mh-wp-pre-3_8';
  } else {
    if ( 'admin_body_class' === current_filter() )
      $classes .= 'mh-wp-after-3_8';
  }

  return $classes;
}
add_filter( 'body_class', 'mh_add_wp_version' );
add_filter( 'admin_body_class', 'mh_add_wp_version' );

/**
 * add layout classes to body
 */
function mh_layout_body_class( $classes ) {
  global $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;

  if ( '1' === get_theme_mod( 'vertical_nav', '0' ) ) {
    $classes[] = 'mh_vertical_nav';

  } else {
    $classes[] = 'mh_horizontal_nav';
    
    if ( 'off' !== ( $fixed = get_theme_mod( 'fixed_menu', 'off' ) ) ) {
      $classes[] = esc_attr("mh_fixed_{$fixed}" );
    }
    if ( 'right' !== ( $header_style = get_theme_mod( 'header_style', 'right' ) ) ) {
      $classes[] = esc_attr( "mh_header_style_{$header_style}" );
    }
    if ( 'centeredx' === ( $header_style ) ) {
      $classes[] = esc_attr( "mh_header_style_centered" );
    }
   if ( 'middle' === ( $mobile_header_style = get_theme_mod( 'mobile_header_style', 'right' ) ) ) {
      $classes[] = esc_attr( "mh_mobile_header_mid" );
    }

  }
  if ( true === get_theme_mod( 'mharty_smooth_scroll', false ) ) {
    $classes[] = 'mh_smooth_scroll';
  }
  if ( true !== get_theme_mod( 'mharty_mobile_animation', true ) ) {
    $classes[] = 'mh_mobile_no_animation';
  }
  if ( '1' === get_theme_mod( 'boxed_layout', '0' ) ) {
    $classes[] = 'mh_boxed_layout';
  }
  if ( '1' === get_theme_mod( 'site_width', '0' ) ) {
    $classes[] = 'mh_w7_9_5';
  }
  if ( '1' === get_theme_mod( 'secondary_nav_position', '0' ) || is_page_template( 'page-template-trans.php' ) ) {
    $classes[] = 'mh_secondary_nav_above';
  }
  if ( true === get_theme_mod( 'hide_nav_menu', false ) ) {
    $classes[] = 'mh_hide_menu';
  }
  if ( true === get_theme_mod( 'cover_background', true ) ) {
    $classes[] = 'mh_cover_background';
  }
  $mh_secondary_nav_items = mh_mharty_get_top_nav_items();
  if ( $mh_secondary_nav_items->top_info_defined ) {
    $classes[] = 'mh_secondary_nav_enabled';
  }
  if ( $mh_secondary_nav_items->two_info_panels ) {
    $classes[] = 'mh_secondary_nav_two_panels';
  }
  if ( $mh_secondary_nav_items->secondary_nav && !( $mh_secondary_nav_items->contact_info_defined || $mh_secondary_nav_items->show_header_social_icons ) ) {
    $classes[] = 'mh_secondary_nav_only_menu';
  }
  if ( 'right' !== ( $footer_style = get_theme_mod( 'footer_style', 'right' ) ) ) {
    $classes[] = esc_attr( "mh_footer_style_{$footer_style}" );
  }
  if ( 'only' !== ( $icons_style = get_theme_mod( 'icons_style', 'only' ) ) ) {
    $classes[] = esc_attr( "mh_icons_{$icons_style}" );
  }
  if ( 'square' !== ( $round_style = get_theme_mod( 'round_style', 'square' ) ) ) {
    $classes[] = esc_attr( "mh_{$round_style}_corners" );
  }
  if ( 'none' !== ( $sidebar_titles = get_theme_mod( 'sidebar_titles', 'none' ) ) ) {
    $classes[] = esc_attr( "mh_widget_title_style_{$sidebar_titles}" );
  }
  if ( $is_iphone )$classes[] = 'iphone';
  if ( true === get_theme_mod( 'mharty_show_quick_contact', false ) ) {
    $classes[] = 'mh_quick_form_active';
  }
  if ( is_page_template( 'page-template-trans.php' ) ) {
    $classes[] = 'mh_transparent_header';
  }
  if ( false === get_theme_mod( 'header_padding', false ) ) {
    $classes[] = 'mh_header_padding';
  } else {
    $classes[] = 'mh_no_header_padding';
  }
  if ( '0' === get_theme_mod( 'promo_bar_logged_in', '1' ) ) {
    $classes[] = 'mh_promo_bar_logged_in';
  }

  $secondary_nav_style = get_theme_mod( 'secondary_nav_style', 'none' );
  $classes[] = esc_attr( "mh_secondary_nav_style_{$secondary_nav_style}" );

  $widget_style = get_theme_mod( 'footer_widget_columns', 'four' );
  $classes[] = esc_attr( "mh_widget_style_{$widget_style}" );

  $subnav_animation = get_theme_mod( 'subnav_animation', 'fadein' );
  $classes[] = esc_attr( "mh_subnav_animation_{$subnav_animation}" );

  $website_width = get_theme_mod( 'website_width', 'fixed' );
  $classes[] = esc_attr( "mh_{$website_width}_width" );

  if ( true === get_theme_mod( 'ss_blog_grid_2_pr_row', false ) ) {
    $classes[] = esc_attr( "mh_blog_2pr" );
  }
  if ( true === get_theme_mod( 'ss_projects_grid_2_pr_row', false ) ) {
    $classes[] = esc_attr( "mh_projects_2pr" );
  }
  if ( true === get_theme_mod( 'ss_gallery_grid_2_pr_row', false ) ) {
    $classes[] = esc_attr( "mh_gallery_2pr" );
  }
  if ( true === get_theme_mod( 'ss_widgets_grid_2_pr_row', false ) ) {
    $classes[] = esc_attr( "mh_widgets_2pr" );
  }

  $link_style = get_theme_mod( 'link_style', 'accent' );
  $classes[] = esc_attr( "link_style_{$link_style}" );
  //user agent
  if ( isset( $_SERVER[ 'HTTP_USER_AGENT' ] ) ) {
    if ( stristr( $_SERVER[ 'HTTP_USER_AGENT' ], "mac" ) ) {
      $classes[] = 'osx';
    } elseif ( stristr( $_SERVER[ 'HTTP_USER_AGENT' ], "linux" ) ) {
      $classes[] = 'linux';
    } elseif ( stristr( $_SERVER[ 'HTTP_USER_AGENT' ], "windows" ) ) {
      $classes[] = 'windows';
    }
  }
  //browsers
  if ( $is_lynx )$classes[] = 'lynx';
  elseif ( $is_gecko )$classes[] = 'gecko';
  elseif ( $is_opera )$classes[] = 'opera';
  elseif ( $is_NS4 )$classes[] = 'ns4';
  elseif ( $is_safari )$classes[] = 'safari';
  elseif ( $is_chrome )$classes[] = 'chrome';
  elseif ( $is_IE )$classes[] = 'ie';
  else $classes[] = 'unknown';

  return $classes;
}
add_filter( 'body_class', 'mh_layout_body_class' );

/**
 * add sidebar classes to body
 */
function mh_mharty_sidebar_class( $classes ) {

  if ( mh_composer_is_active( get_queried_object_id() ) ) {
    $classes[] = 'mh_full_width_page';
  } else {
    if ( is_single() || is_page() || ( class_exists( 'woocommerce', false ) && is_product() ) ) {
      $page_layout = '';

      $sidebar_default = is_rtl() ? 'mh_left_sidebar' : 'mh_right_sidebar';
      $sidebar = '' !== ( $layout = get_post_meta( get_queried_object_id(), '_mhc_page_layout', true ) ) ? $layout : $sidebar_default;

      if ( is_page() )
        $page_layout = 'mh_default_sidebar' !== ( $page_sidebar = get_theme_mod( 'mharty_pages_sidebar', 'mh_default_sidebar' ) ) ? $page_sidebar : $sidebar;
      if ( is_single() )
        $page_layout = 'mh_default_sidebar' !== ( $post_sidebar = get_theme_mod( 'mharty_posts_sidebar', 'mh_default_sidebar' ) ) ? $post_sidebar : $sidebar;

      if ( is_singular( 'project' ) )
        $page_layout = 'mh_default_sidebar' !== ( $project_sidebar = get_theme_mod( 'mharty_projects_sidebar', 'mh_default_sidebar' ) ) ? $project_sidebar : $sidebar;

      if ( class_exists( 'woocommerce', false ) && is_product() )
        $page_layout = 'mh_default_sidebar' !== ( $product_sidebar = get_theme_mod( 'mharty_products_sidebar', 'mh_default_sidebar' ) ) ? $product_sidebar : $sidebar;
    }


    if ( class_exists( 'woocommerce', false ) && ( is_shop() || is_product() || is_product_category() || is_product_tag() || is_account_page() ) ) {
      if ( mh_composer_is_active( get_queried_object_id() ) && ( is_shop() || is_product() || is_account_page() ) ) {
        $classes[] = 'mh_full_width_page';

      } elseif ( is_shop() || is_product_category() || is_product_tag() ) {
        $classes[] = get_theme_mod( 'mharty_shop_page_sidebar', is_rtl() ? 'mh_left_sidebar' : 'mh_right_sidebar' );
      } elseif ( is_product() ) {
        $classes[] = $page_layout;
      }
    } else if ( is_home() ) {
      $classes[] = get_theme_mod( 'mharty_index_page_sidebar', is_rtl() ? 'mh_left_sidebar' : 'mh_right_sidebar' );
    } else if ( is_archive() || is_search() || is_404() ) {
      $classes[] = get_theme_mod( 'mharty_archive_page_sidebar', is_rtl() ? 'mh_left_sidebar' : 'mh_right_sidebar' );
    } else if ( is_singular( 'project' ) ) {
      if ( 'mh_full_width_page' === $page_layout ) {
        $page_layout = is_rtl() ? 'mh_left_sidebar mh_full_width_portfolio_page' : 'mh_right_sidebar mh_full_width_portfolio_page';
      }
      $classes[] = $page_layout;
    } else if ( is_single() || is_page() ) {
      $classes[] = $page_layout;
    }
  }

  return $classes;
}
add_filter( 'body_class', 'mh_mharty_sidebar_class' );

/**
 * Add ltr class to admin body as we might need it to style some elements
 */
function mh_add_admin_body_class( $classes ) {
  if ( !is_rtl() ) {
    $classes .= 'ltr';
  }
  return $classes;
}
add_filter( 'admin_body_class', 'mh_add_admin_body_class' );