<?php

// Send install data to the api endpoint
function mh_send_install_data($license_key) {
    if (empty($license_key)) {
        return;
    }

    $versions = [
        'theme' => mh_get_mharty_version(),
        'plugins' => mh_get_plugin_versions(),
    ];

    $data = [
        'license_key' => $license_key,
        'domain' => home_url(),
        'wp_version' => get_bloginfo('version') ?? '',
        'php_version' => phpversion() ?? '',
        'locale' => get_locale() ?? '',
        'multisite' => is_multisite() ? 1 : 0,
        'versions' => $versions ?? []
    ];
    wp_remote_post('https://api.mharty.com/actions/install', [
        'timeout' => 10,
        'headers' => ['Content-Type' => 'application/json'],
        'body' => wp_json_encode($data),
    ]);
}
