<?php
function mh_add_theme_info_meta(){
  echo '<meta name="generator" content="Mharty ' . esc_attr( mh_get_mharty_version() ) . '"/>';
  if ( is_child_theme()){
    echo '<meta name="generator" content="Mharty Child ' . esc_attr( mh_get_theme_version() ) . '"/>';
  }
}
add_action( 'wp_head', 'mh_add_theme_info_meta', 7 );

/*this function controls the meta description display*/
if ( ! function_exists( 'mharty_description' ) ){
	function mharty_description() {
		// Don't use mhPanel SEO if WordPress SEO or All In One SEO Pack plugins are active
		if ( class_exists( 'WPSEO_Frontend', false ) || class_exists( 'All_in_One_SEO_Pack', false ) ) {
			return;
		}

		#homepage descriptions
		if ( mh_get_option('mharty_seo_home_description') == true && ( ( is_home() || is_front_page() ) && ! mharty_is_blog_posts_page() ) ) {
			echo '<meta name="description" content="' . esc_attr( mh_get_option('mharty_seo_home_descriptiontext') ) .'" />';
			echo '<meta property="og:description" content="' . esc_attr( mh_get_option('mharty_seo_home_descriptiontext') ) .'" />';
			echo '<meta name="twitter:description" content="' . esc_attr( mh_get_option('mharty_seo_home_descriptiontext') ) .'">';
		}

		#single page descriptions
		if ( mh_get_option('mharty_seo_single_description') == true && ( is_single() || is_page() || mharty_is_blog_posts_page() ) ) {
			global $wp_query;

			if ( isset($wp_query->post->ID) || mharty_is_blog_posts_page() ) {
				$postid = mharty_is_blog_posts_page() ? intval( get_option( 'page_for_posts' ) ) : $wp_query->post->ID;
			}

			$key2 = mh_get_option('mharty_seo_single_field_description');

			if ( isset($postid) ) $exists = get_post_meta($postid, ''.$key2.'', true);

			if ( $exists !== '' ) {
				echo '<meta name="description" content="' . esc_attr( $exists ) . '" />';
				echo '<meta property="og:description" content="' . esc_attr( $exists ) . '" />';
				echo '<meta name="twitter:description" content="' . esc_attr( $exists ) . '">';
			}
		}

		#index descriptions
		$seo_index_description = mh_get_option('mharty_seo_index_description');
		if ( $seo_index_description == true ) {
			$title_before_4_4 = version_compare( $GLOBALS['wp_version'], '4.4', '<' );
			$description_added = false;

			if ( is_category() ) {
				remove_filter( 'term_description', 'wpautop' );
				$cat = get_query_var( 'cat' );
				$exists2 = category_description( $cat );

				if ( $exists2 !== '' ) {
					echo '<meta name="description" content="' . esc_attr( $exists2 ) . '" />';
					echo '<meta property="og:description" content="' . esc_attr( $exists2 ) . '" />';
					echo '<meta name="twitter:description" content="' . esc_attr( $exists2 ) . '">';
					$description_added = true;
				}
			}

			if ( is_archive() && ! $description_added ) {
				$description = $title_before_4_4
					? sprintf( esc_html__( 'Currently viewing archives from %1$s', 'mharty' ),
						wp_title( '', false, '' )
					)
					: get_the_archive_title();
			
				printf( '<meta name="description" content="%1$s" />
				<meta property="og:description" content="%1$s" />
				<meta name="twitter:description" content="%1$s">',
					esc_attr( $description )
				);
			
				$description_added = true;
			}
			
			if ( is_search() && ! $description_added ) {
				$description = $title_before_4_4
					? wp_title( '', false, '' )
					: sprintf(
						esc_html__( 'Search Results for: %s', 'mharty' ),
						get_search_query()
					);
			
				echo '<meta name="description" content="' . esc_attr( $description ) . '" />';
				echo '<meta property="og:description" content="' . esc_attr( $description ) . '" />';
				echo '<meta name="twitter:description" content="' . esc_attr( $description ) . '">';
				$description_added = true;
			}
		}
	}
}

/*this function controls the meta keywords display*/
if ( ! function_exists( 'mharty_keywords' ) ){
	function mharty_keywords() {
		// Don't use mhPanel SEO if WordPress SEO or All In One SEO Pack plugins are active
		if ( class_exists( 'WPSEO_Frontend', false ) || class_exists( 'All_in_One_SEO_Pack', false ) ) {
			return;
		}

		#homepage keywords
		if ( mh_get_option('mharty_seo_home_keywords') == true && ( ( is_home() || is_front_page() ) && ! mharty_is_blog_posts_page() ) ) {
			echo '<meta name="keywords" content="' . esc_attr( mh_get_option('mharty_seo_home_keywordstext') ) . '" />';
		}

		#single page keywords
		if ( mh_get_option('mharty_seo_single_keywords') == true ) {
			global $wp_query;
			if ( isset( $wp_query->post->ID ) || mharty_is_blog_posts_page() ) {
				$postid = mharty_is_blog_posts_page() ? intval( get_option( 'page_for_posts' ) ) : $wp_query->post->ID;
			}

			$key3 = mh_get_option('mharty_seo_single_field_keywords');

			if (isset($postid)) $exists4 = get_post_meta($postid, ''.$key3.'', true);

			if ( isset($exists4) && $exists4 !== '' ) {
				if ( is_single() || is_page() || mharty_is_blog_posts_page() ) echo '<meta name="keywords" content="' . esc_attr( $exists4 ) . '" />';
			}
		}
	}
}

//add open graph
if (!function_exists('mharty_opengraph')) {
	function mharty_opengraph() {
		global $post; // Ensures we can use post variables outside the loop
		$user_logo = '' !== get_theme_mod( 'mharty_og_logo' ) ? get_theme_mod( 'mharty_og_logo' ) : get_theme_mod( 'mharty_logo' );
		$twitter_id = ('' !== get_theme_mod( 'mharty_twitter_url', '#' ) && '#' !== get_theme_mod( 'mharty_twitter_url', '#' ) && true === get_theme_mod( 'mharty_show_twitter_icon', true )) ? esc_url( get_theme_mod( 'mharty_twitter_url', '#' ) ) : '';

		echo '<meta property="og:site_name" content="'. get_bloginfo('name') .'"/>'; 
		echo '<meta property="og:url" content="' . get_permalink() . '"/>';
		echo '<meta property="og:locale" content="' . get_bloginfo('language') .'" />';
		echo '<meta name="twitter:card" content="summary_large_image">';
		echo '' !== $twitter_id ? '<meta name="twitter:site" content="' . $twitter_id . '">' : '';
		if (is_singular()) {
			$user =  $post->post_author;
			$the_user =  get_userdata($user);
	        echo '<meta property="og:title" content="' . get_the_title() . '"/>';
			//echo '<meta property="og:description" content="">';
	        echo '<meta property="og:type" content="article"/>';
			echo '<meta name="twitter:title" content="' . get_the_title() . '">';
			// Check if the user has a Twitter account, otherwise use the default Twitter ID
			$author_twitter_id = (isset($the_user->twitter) && '' !== $the_user->twitter) ? esc_url( $the_user->twitter ) : $twitter_id;
			echo '' !== $author_twitter_id ? '<meta name="twitter:creator" content="' . $author_twitter_id . '">' : '';
	    } elseif(is_front_page() || is_home()) {
	    	echo '<meta property="og:title" content="' . get_bloginfo("name") . '"/>';
			//echo '<meta property="og:description" content="">';
	    	echo '<meta property="og:type" content="website"/>';
			echo '<meta name="twitter:title" content="' . get_bloginfo("name") . '">';
			echo '' !== $twitter_id ? '<meta name="twitter:creator" content="' . $twitter_id . '">' : '';
	    }
		
		if(is_singular() && has_post_thumbnail( $post->ID )) { 
			$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'large' );
      if (empty($thumbnail))
        return;
      
			echo '<meta property="og:image" content="' . esc_attr( $thumbnail[0] ) . '"/>';
			$secure_url = is_ssl() ? '<meta property="og:image:secure_url" content="' . esc_attr( $thumbnail[0] ) . '"/>' : '';
			echo $secure_url;
			echo '<meta property="og:image:width" content="' . esc_attr( $thumbnail[1] ) . '"/>';
			echo '<meta property="og:image:height" content="' . esc_attr( $thumbnail[2] ) . '"/>';
			echo '<meta property="og:image:alt" content="' . get_the_title() . '"/>';
			echo '<meta name="twitter:image" content="' . esc_attr( $thumbnail[0] ) . '">';
		//if post doesn't have a featured image use the logo
		}elseif ('' != $user_logo){
			echo '<meta property="og:image" content="' . esc_url( $user_logo ) . '"/>';
			echo '<meta name="twitter:image" content="' . esc_url( $user_logo ) . '">';
			echo '<meta property="og:image:alt" content="' . get_bloginfo("name") . '"/>';
		}
	}
}

/*this function controls canonical urls*/
if ( ! function_exists( 'mharty_canonical' ) ){
	function mharty_canonical() {
		// Don't use mhPanel SEO if WordPress SEO or All In One SEO Pack plugins are active
		if ( class_exists( 'WPSEO_Frontend', false ) || class_exists( 'All_in_One_SEO_Pack', false ) ) {
			return;
		}

		#homepage urls
		if ( mh_get_option('mharty_seo_home_canonical') == true && is_home() && ! mharty_is_blog_posts_page() ) {
			echo '<link rel="canonical" href="'. esc_url( home_url() ).'" />';
		}

		#single page urls
		if ( mh_get_option('mharty_seo_single_canonical') == true ) {
			global $wp_query;
			if ( isset( $wp_query->post->ID ) || mharty_is_blog_posts_page() ) {
				$postid = mharty_is_blog_posts_page() ? intval( get_option( 'page_for_posts' ) ) : $wp_query->post->ID;
			}

			if ( ( is_single() || is_page() || mharty_is_blog_posts_page() ) && ! is_front_page() ) {
				echo '<link rel="canonical" href="' . esc_url( get_permalink( $postid ) ) . '" />';
			}
		}

		#index page urls
		if ( mh_get_option('mharty_seo_index_canonical') == true ) {
			$current_page_url = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
			if ( is_archive() || is_category() || is_search() ) echo '<link rel="canonical" href="'. esc_url( $current_page_url ).'" />';
		}
	}
}
add_action( 'wp_head', 'mharty_canonical', 1);

$using_jetpack_publicize = ( class_exists( 'Jetpack' ) && in_array( 'publicize', Jetpack::get_active_modules()) ) ? true : false;

//output all 
if ( !defined('WPSEO_VERSION') && !class_exists('RankMath') && !class_exists('NY_OG_Admin') && !class_exists('Wpsso') && $using_jetpack_publicize == false) {
	add_action( 'wp_head', 'mharty_description', 1 );
	add_action( 'wp_head', 'mharty_keywords', 1 );
	add_action( 'wp_head', 'mharty_opengraph', 1 );
}