<?php
if ( ! defined( 'ABSPATH' ) ) { die( '-1' ); }
/**
 * Pass thru  unescaped values
 */
if ( ! function_exists( 'mh_passthru_unescaped' ) ) :
function mh_passthru_unescaped( $passthru, $reason ) {
	$all_reasons = array(
		'html',
		//'underscore_template',
        //'cap_based_sanitized',
		//'fixed_string',
	);

	if ( ! in_array( $reason, $all_reasons ) ) {
		_doing_it_wrong( __FUNCTION__, 'This is not a valid reason to not escape this value.', esc_html( mh_get_theme_version() ) );
	}

	return $passthru;
}
endif;

 function mh_starts_with( $string, $substring ) {
		return 0 === strpos( $string, $substring );
}

/**
 * Sanitize text input
 */
function mh_sanitize_text_input( $string ) {
	return wp_kses( $string, mh_sanitize_text_input_allowed_html_elements() );
}

/**
 * allowed html elements in our custom text input
 */
function mh_sanitize_text_input_allowed_html_elements() {
	$allowed_tags = array(
		'div' => array(
			'class' => array(),
			'id'    => array(),
		),
		'span' => array(
			'class' => array(),
			'id'    => array(),
		),
		'ol' => array(
			'class' => array(),
			'id'    => array(),
		),
		'ul' => array(
			'class' => array(),
			'id'    => array(),
		),
		'li' => array(
			'class' => array(),
			'id'    => array(),
		),
		'p' => array(
			'class' => array(),
			'id'    => array(),
		),
		'a' => array(
			'href'  	=> array(),
			'class' 	=> array(),
			'id'    	=> array(),
			'title' 	=> array(),
			'target'    => array(),
		),
		'br' => array(),
		'em' => array(),
		'strong' => array(),
    'img' => array(
      'src'  	=> array(),
      'height'  	=> array(),
      'width'  	=> array(),
      'alt'  	=> array(),
    ),
	);

	return apply_filters( 'mh_sanitize_text_input_allowed_html_elements', $allowed_tags );
}

/**
 * custom wp_kses to allow some html elements
 */
if ( ! function_exists( 'mh_wp_kses' ) ) :
function mh_wp_kses( $string ) {
	return apply_filters( 'mh_wp_kses', wp_kses( $string, mh_wp_kses_allowed_html_elements() ) );
}
endif;

/**
 * allowed html elements in our custom mh_wp_kses
 */
if ( ! function_exists( 'mh_wp_kses_allowed_html_elements' ) ) :
	function mh_wp_kses_allowed_html_elements() {
		$whitelisted_attributes = array(
			'id'    => array(),
			'class' => array(),
			'style' => array(),
		);
		
		$whitelisted_attributes = apply_filters( 'mh_wp_kses_allowed_html_attributes', $whitelisted_attributes );

		$elements = array(
			'a'      => array(
				'href'  => array(),
				'title' => array(),
				'target' => array(),
				'rel'    => array(),
			),
			'b'      => array(),
			'em'     => array(),
			'p'      => array(),
			'br'     => array(),
			'span'   => array(),
			'div'    => array(),
			'strong' => array(),
		);
		
		$elements = apply_filters( 'mh_wp_kses_allowed_html_elements', $elements );

		foreach ( $elements as $tag => $attributes ) {
			$elements[ $tag ] = array_merge( $attributes, $whitelisted_attributes );
		}

		return $elements;
	}
endif;

/**
 * Convert &amp; into & (so far: used in contact form component only)
 */
if ( ! function_exists( 'mh_allow_ampersand' ) ) :
function mh_allow_ampersand( $string ) {
	return str_replace('&amp;', '&', $string);
}
endif;

//Sanitizes a string key for MH Settings
function mh_sanitize_key( $key ) {
	$raw_key = $key;
	$key = preg_replace( '/[^a-zA-Z0-9_\-\.\:\/]/', '', $key );
	return apply_filters( 'mh_sanitize_key', $key, $raw_key );
}

//Sanitize HTML Class Names
function mh_sanitize_html_class( $class = '' ) {

	if ( is_string( $class ) ) {
		$class = sanitize_html_class( $class );
	} else if ( is_array( $class ) ) {
		$class = array_values( array_map( 'sanitize_html_class', $class ) );
		$class = implode( ' ', array_unique( $class ) );
	}

	return $class;
}