<?php
/**
 * frontend styles and scripts
 */
function mh_mharty_load_scripts_styles(){
	global $wp_styles;
	$ltr = is_rtl() ? '' : '-ltr';
	$template_dir = get_template_directory_uri();
	$theme_version = mh_get_theme_version();
	$dependencies = array( 'jquery', 'jquery-effects-core' );
	//register script
  wp_register_script( 'mharty-script', $template_dir . '/js/theme-bundle.js', $dependencies, $theme_version, true );
	wp_register_script(  'smooth-scroll', $template_dir . '/js/smoothscroll.min.js', $dependencies, $theme_version, true );

	// enqueue scripts
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' );
  
  wp_enqueue_script( 'mharty-script');
	
	wp_localize_script( 'mharty-script', 'mh_theme', array(
		'ajaxurl'         => admin_url( 'admin-ajax.php' ),
		//magnificPopup translation
		'mp_close'        => esc_html__( 'Close (Esc)', 'mharty' ),
		'mp_loading'      => esc_html__( 'Loading...', 'mharty' ),
		'mp_prev'         => esc_html__( 'Previous (Left arrow key)', 'mharty' ),
		'mp_next'         => esc_html__( 'Next (Right arrow key)', 'mharty' ),
		'mp_counter'      => esc_html__( '%curr% of %total%', 'mharty' ),
		'mp_error_image'  => esc_html__( '<a href="%url%">The image</a> could not be loaded.', 'mharty' ),
		'mp_error_ajax'   => esc_html__( '<a href="%url%">The content</a> could not be loaded.', 'mharty' ),
	) );

	if ( true == mh_get_option( 'mharty_smooth_scroll' ) ) {
		wp_enqueue_script( 'smooth-scroll' );
	}
  
	$mh_gf_enqueue_fonts = array();
	$mh_gf_heading_font = sanitize_text_field( get_theme_mod( 'heading_font', 'none' ) );
	$mh_gf_body_font = sanitize_text_field( get_theme_mod( 'body_font', 'none' ) );
	$mh_language_fonts = mh_get_language_fonts();
	$mh_default_fonts = mh_get_default_fonts();
	$site_locale = get_locale();
	$protocol = is_ssl() ? 'https:' : 'http:';
	if ( 'none' != $mh_gf_heading_font ) $mh_gf_enqueue_fonts[] = $mh_gf_heading_font;
	if ( 'none' != $mh_gf_body_font ) $mh_gf_enqueue_fonts[] = $mh_gf_body_font;
	
	if ( 'none' == $mh_gf_heading_font){
		if ( isset( $mh_language_fonts[$site_locale] )) {
			$mh_gf_font_name_slug = strtolower( str_replace( ' ', '-', $mh_language_fonts[$site_locale]['language_name'] ) );
			wp_enqueue_style( 'mh-gf-' . $mh_gf_font_name_slug, esc_url_raw($protocol . $mh_language_fonts[$site_locale]['google_font_url']), array(), null );
		}else{
			$mh_gf_font_name_slug = strtolower( str_replace( ' ', '-', $mh_default_fonts['h']['font_name'] ) );
			wp_enqueue_style( 'mh-gf-' . $mh_gf_font_name_slug, esc_url_raw($protocol . $mh_default_fonts['h']['google_font_url']), array(), null );
		}	
	}
	if ( 'none' == $mh_gf_body_font){
		if ( !isset( $mh_language_fonts[$site_locale] )) {	
			$mh_gf_font_name_slug = strtolower( str_replace( ' ', '-', $mh_default_fonts['body']['font_name'] ) );
			wp_enqueue_style( 'mh-gf-' . $mh_gf_font_name_slug, esc_url_raw($protocol . $mh_default_fonts['body']['google_font_url']), array(), null );
		}	
	}

	if ( ! empty( $mh_gf_enqueue_fonts ) ) mh_gf_enqueue_fonts( $mh_gf_enqueue_fonts );

	/*
	 * Loads the main stylesheet.
	 */
		wp_enqueue_style( 'mharty-style', $template_dir . '/css/style'. $ltr . '.css', array(), $theme_version );
  
		//decalre child theme style
		if (is_child_theme()) {
			wp_enqueue_style( 'mharty-child', get_stylesheet_directory_uri() . '/style.css', array(), $theme_version );
		}

		// hook extra styles to this if needed
		do_action('mh_load_extra_styles');
}
add_action( 'wp_enqueue_scripts', 'mh_mharty_load_scripts_styles' );