<?php
/**
 * tinymce fix
 */
if ( ! function_exists( 'mh_tinymce_fix_rtl' ) ) {
	function mh_tinymce_fix_rtl( $settings ) {
		// This fix has to be applied to all editor instances for RTL Admin areas
		if ( is_rtl() && isset( $settings['plugins'] ) && ',directionality' == $settings['plugins'] ) {
			unset( $settings['plugins'] );
		}
		return $settings;
	}
}

/**
 * tinymce add font size button
 */
if ( ! function_exists( 'mh_tinymce_fontsize' ) ) {
	function mh_tinymce_fontsize( $buttons ) {
        array_shift( $buttons );
        array_unshift( $buttons, 'fontsizeselect');
        array_unshift( $buttons, 'formatselect');
        return $buttons;
	}
}
add_filter('mce_buttons_2', 'mh_tinymce_fontsize');

/**
 * tinymce add custom font sizes
 */
if ( ! function_exists( 'mh_mce_text_sizes' ) ) {
	function mh_mce_text_sizes( $initArray ){
		$initArray['fontsize_formats'] = "12px 14px 16px 18px 20px 22px 24px 26px 28px 30px 34px 38px 42px 52px 62px 72px";
		return $initArray;
	}
}
add_filter( 'tiny_mce_before_init', 'mh_mce_text_sizes' );

/**
 * tinymce add our custom color scheme
 */
function mh_tinymce_color_scheme( $initArray ) {
    $default_colours = '
        "000000", "Black",
        "993300", "Burnt orange",
        "333300", "Dark olive",
        "003300", "Dark green",
        "003366", "Dark azure",
        "000080", "Navy Blue",
        "333399", "Indigo",
        "333333", "Very dark gray",
        "800000", "Maroon",
        "FF6600", "Orange",
        "808000", "Olive",
        "008000", "Green",
        "008080", "Teal",
        "0000FF", "Blue",
        "666699", "Grayish blue",
        "808080", "Gray",
        "FF0000", "Red",
        "FF9900", "Amber",
        "99CC00", "Yellow green",
        "339966", "Sea green",
        "33CCCC", "Turquoise",
        "3366FF", "Royal blue",
        "800080", "Purple",
        "999999", "Medium gray",
        "FF00FF", "Magenta",
        "FFCC00", "Gold",
        "FFFF00", "Yellow",
        "00FF00", "Lime",
        "00FFFF", "Aqua",
        "00CCFF", "Sky blue",
        "993366", "Brown",
        "C0C0C0", "Silver",
        "FF99CC", "Pink",
        "FFCC99", "Peach",
        "FFFF99", "Light yellow",
        "CCFFCC", "Pale green",
        "CCFFFF", "Pale cyan",
        "99CCFF", "Light sky blue",
        "CC99FF", "Plum",
        "FFFFFF", "White"
        ';
    $custom_colours = '"' . implode( '","","', mh_default_color_scheme() ) . '"';
		$custom_colours = str_replace('#', '', $custom_colours);
    $initArray['textcolor_map'] = '[' . $default_colours . ',' . $custom_colours . ']';
    $initArray['textcolor_rows'] = 6;
    return $initArray;
}
add_filter('tiny_mce_before_init', 'mh_tinymce_color_scheme');