<?php

if (! defined('ABSPATH')) {
    die('-1');
}

/**
* Panels & Sections
*/
function mh_mharty_customize_register($wp_customize)
{
    $wp_customize->remove_section('colors');
    $wp_customize->remove_section('custom_css');
    $wp_customize->remove_control('background-color');
    $wp_customize->remove_setting('background-color');
    $wp_customize->get_section('background_image')->title = esc_html__('Background Colour & Image', 'mharty');

    $wp_customize->add_section('mh_mharty_settings', array(
        'title'		  => esc_html__('Site Settings', 'mharty'),
        'priority'	  => 20,
    ));
    $wp_customize->add_panel('mh_header_panel', array(
        'title'       => _x('Header', 'Customizer Panel Title', 'mharty'),
    'priority'    => 21,
    ));
    $wp_customize->add_section('mh_primary_nav', array(
        'title'		=> esc_html__('Primary Navigation', 'mharty'),
        'panel'     => 'mh_header_panel',
    ));
    $wp_customize->add_section('mh_secondary_nav', array(
        'title'		=> esc_html__('Secondary Navigation', 'mharty'),
        'panel'     => 'mh_header_panel',
    ));
    $wp_customize->add_section('mh_promo_bar', array(
        'title'		=> esc_html__('Promo Bar', 'mharty'),
        'panel'     => 'mh_header_panel',
    ));
    $wp_customize->add_panel('mh_content', array(
        'title'       => _x('Content', 'Customizer Panel Title', 'mharty'),
        'priority'    => 22,
    ));
    $wp_customize->add_section('mh_content_general', array(
          'title'		=> esc_html__('Content: General', 'mharty'),
          'panel'     => 'mh_content',
      ));
    $wp_customize->add_section('mh_content_archive', array(
        'title'		=> esc_html__('Content: Archive', 'mharty'),
        'panel'     => 'mh_content',
    ));
    $wp_customize->add_section('mh_content_post', array(
        'title'		=> esc_html__('Content: Post', 'mharty'),
        'panel'     => 'mh_content',
    ));
    $wp_customize->add_section('mh_content_project', array(
        'title'		=> esc_html__('Content: Project', 'mharty'),
        'panel'     => 'mh_content',
    ));
    $wp_customize->add_section('mh_content_page', array(
        'title'		=> esc_html__('Content: Page', 'mharty'),
        'panel'     => 'mh_content',
    ));
    $wp_customize->add_section('mh_content_sidebar', array(
          'title'		=> esc_html__('Content: Sidebar', 'mharty'),
          'panel'     => 'mh_content',
      ));
    $wp_customize->add_section('mh_footer', array(
        'title'		=> _x('Footer', 'Customizer Panel Title', 'mharty'),
        'priority'	=> 23,
    ));
    $wp_customize->add_panel('mh_colors', array(
        'title'       => esc_html__('Colours', 'mharty'),
        'priority'    => 24,
    ));
    $wp_customize->add_section('colors', array(
        'title'		=> esc_html__('Text & Accent Colours', 'mharty'),
        'panel'     => 'mh_colors',
    ));
    $wp_customize->add_section('mh_primary_colors', array(
        'title'		=> esc_html__('Primary Navigation Colours', 'mharty'),
        'panel'     => 'mh_colors',
    ));
    $wp_customize->add_section('mh_secondary_colors', array(
        'title'		=> esc_html__('Secondary Navigation Colours', 'mharty'),
        'panel'     => 'mh_colors',
    ));
    $wp_customize->add_section('mh_app_colors', array(
        'title'		=> esc_html__('Mobile Menu Colours', 'mharty'),
        'panel'     => 'mh_colors',
    ));
    $wp_customize->add_section('mh_promo_colors', array(
        'title'		=> esc_html__('Promo Bar Colours', 'mharty'),
        'panel'     => 'mh_colors',
    ));
    $wp_customize->add_section('mh_footer_colors', array(
        'title'		=> esc_html__('Footer Colours', 'mharty'),
        'panel'     => 'mh_colors',
    ));
    $wp_customize->add_section('mh_quick_colors', array(
          'title'		=> esc_html__('Quick Contact Colours', 'mharty'),
          'panel'     => 'mh_colors',
      ));
    $wp_customize->add_section('mh_google_fonts', array(
        'title'		=> esc_html__('Fonts', 'mharty'),
        'priority'	=> 25,
    ));
    $wp_customize->add_panel('mh_mobile_styles_panel', array(
        'title'       => esc_html__('Mobile Devices', 'mharty'),
        'priority'	  => 26,
    ));
    $wp_customize->add_section('mh_mobile_styles_general', array(
        'title'		=> esc_html__('Mobile Settings', 'mharty'),
        'panel'     => 'mh_mobile_styles_panel',
    'description' => esc_html__('Some mobile settings will only show when they are enabled and configured in other corresponding Customizer options.', 'mharty'),
    ));
    $wp_customize->add_section('mh_app_nav', array(
          'title'     => esc_html__('Mobile Menu', 'mharty'),
      'panel'     => 'mh_mobile_styles_panel',
      ));
    $wp_customize->add_section('mh_mobile_styles_fonts', array(
        'title'		=> esc_html__('Mobile Fonts', 'mharty'),
        'panel'     => 'mh_mobile_styles_panel',
    ));
    $wp_customize->add_section('mh_social_icons', array(
          'title'		=> esc_html__('Social Icons', 'mharty'),
      'priority'	=> 27,
      ));
    $wp_customize->add_panel('mh_quick_panel', array(
          'title'       => esc_html__('Quick Contact', 'mharty'),
          'priority'	  => 28,
      ));
    $wp_customize->add_section('mh_quick_contact', array(
          'title'		=> esc_html__('Quick Contact Form', 'mharty'),
      'panel'     => 'mh_quick_panel',
      ));
    $wp_customize->add_section('mh_quick_social', array(
          'title'		=> esc_html__('Quick Social Icon', 'mharty'),
      'panel'     => 'mh_quick_panel',
      ));
    $wp_customize->add_section('mh_ads', array(
      'title'		=> esc_html__('Ads', 'mharty'),
      'priority'	=> 29,
      ));
    $wp_customize->add_section('mh_css', array(
          'title'		=> esc_html__('Custom CSS', 'mharty'),
      'priority'	=> 35,
      ));
}
add_action('customize_register', 'mh_mharty_customize_register');

/**
* Settings
*/
function mh_mharty_customize_setting($controls) {

    //pages and cats ids
    $cats_array = get_categories('hide_empty=0');
    $pages_array = get_pages('hide_empty=0');
    $pages_number = count($pages_array);

    $site_pages = array();
    $site_cats = array();
    $pages_ids = array();
    $cats_ids = array();

    foreach ($pages_array as $pagg) {
        $site_pages[$pagg->ID] = htmlspecialchars($pagg->post_title);
        $pages_ids[] = $pagg->ID;
    }

    foreach ($cats_array as $categs) {
        $site_cats[$categs->cat_ID] = $categs->cat_name;
        $cats_ids[] = $categs->cat_ID;
    }

    $pages_ids 	= array_map('intval', $pages_ids);
    $cats_ids 	= array_map('intval', $cats_ids);

    //fonts
    $google_fonts = mh_get_google_fonts();
    $font_choices = array();
    $font_choices['none'] = esc_html__('Default', 'mharty');
    foreach ($google_fonts as $google_font_name => $google_font_properties) {
        $font_choices[ $google_font_name ] = $google_font_name;
    }

    //sidebar options
    $override_sidebar_options = array(
      'mh_default_sidebar'    => esc_html__('Default', 'mharty'),
      'mh_left_sidebar'    => esc_html__('Left Sidebar', 'mharty'),
      'mh_right_sidebar'   => esc_html__('Right Sidebar', 'mharty'),
      'mh_full_width_page' => esc_html__('Full-width', 'mharty'),
          );
    if (is_rtl()) {
        $sidebar_options = array(
            'mh_left_sidebar'    => esc_html__('Left Sidebar', 'mharty'),
            'mh_right_sidebar'   => esc_html__('Right Sidebar', 'mharty'),
            'mh_full_width_page' => esc_html__('Full-width', 'mharty'),
        );
    } else {
        $sidebar_options = array(
            'mh_right_sidebar'   => esc_html__('Right Sidebar', 'mharty'),
            'mh_left_sidebar'    => esc_html__('Left Sidebar', 'mharty'),
            'mh_full_width_page' => esc_html__('Full-width', 'mharty'),
        );
    }
    ///////////////////////////
    //////Layouts: general//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_date_format',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Date Format', 'mharty'),
        'default'  =>	'd/m/Y',
        'section'  =>	'mh_content_general',
        'description' =>  __('This option allows you to change how your dates are displayed. For more information please refer to the WordPress codex here:<a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank">Formatting Date and Time</a>', 'mharty'),

        //validation:date_format
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_enable_breadcrmbs',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Enable Breadcrumbs', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_general',
        'description' => esc_html__('This option will show a breadcrumb in your site.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_enable_breadcrumbs_rich_snippet',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Enable Breadcrumbs Rich Snippet', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_general',
        'description' => esc_html__('This option will enable the breadcrumb rich snippet markup in the code.', 'mharty'),
        'active_callback' => function () {
            return false != get_theme_mod('mharty_enable_breadcrmbs');
        },

    );

    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_comments_form_position',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Comments Form Placement', 'mharty'),
        'default'  =>	'after',
        'section'  =>	'mh_content_general',
        'description' => esc_html__('Choose where to place the comments form.', 'mharty'),
        'choices'     => array(
            'after' 	=> esc_html__('After comments', 'mharty'),
            'before'    => esc_html__('Before comments', 'mharty'),
        ),
    );
    ///////////////////////////
    //////Layouts: archive//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_archive_page_style',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Archive Pages Style', 'mharty'),
        'default'  =>	'fullwidth',
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Here you can choose Archive Pages Style such as Categories, tags, search pages etc', 'mharty'),
        'choices'     => array(
            'fullwidth'		=> esc_html__('Default', 'mharty'),
            'grid'			=> esc_html__('Grid', 'mharty'),
            'horizontal'	=> esc_html__('Horizontal', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'posts_num_heading',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Number of Posts', 'mharty'),
        'section'  =>	'mh_content_archive',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_catnum_posts',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Category Pages', 'mharty'),
        'default'  =>	'6',
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Specify the number of recent articles displayed on the Category page. This option works independently from the Settings &gt; Reading Settings in wp-admin.', 'mharty'),

        //validation:number
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_archivenum_posts',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Archive Pages', 'mharty'),
        'default'  =>	'5',
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Specify the number of recent articles displayed on the Archive pages. This option works independently from the Settings &gt; Reading Settings in wp-admin.', 'mharty'),

        //validation:number
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_searchnum_posts',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Search Pages', 'mharty'),
        'default'  =>	'5',
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Specify the number of recent articles displayed on the Search results pages. This option works independently from the Settings &gt; Reading Settings in wp-admin.', 'mharty'),

        //validation:number
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_tagnum_posts',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Tag Pages', 'mharty'),
        'default'  =>	'5',
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Specify the number of recent articles displayed on the the Tag pages. This option works independently from the Settings &gt; Reading Settings in wp-admin.', 'mharty'),

        //validation:number
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'archive_elements_heading',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Elements', 'mharty'),
        'section'  =>	'mh_content_archive',
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_archive_title',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Archive Titles', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Enable this option to show Archive Pages title e.g category, tag, search results page.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_archive_description',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Archive Description', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Enable this option to show Archive Pages description e.g category, tag.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_archive_terms',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Sub Categories', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Enable this option to show a list of sub categories.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'multiple-checkbox-image',
        'setting'  =>	'mharty_postinfo1',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Post Info', 'mharty'),
        'default'  =>	array(
            'author' => esc_html__('Author', 'mharty'),
            'date' => esc_html__('Date', 'mharty'),
            'categories' => esc_html__('Categories', 'mharty'),
            ),
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Here you can choose which items appear in the post info section on archive pages. This is usually below or above the post title.', 'mharty'),
        'choices'     => array(
            'avatar' => esc_html__('Avatar', 'mharty'),
            'author' => esc_html__('Author', 'mharty'),
            'date' => esc_html__('Date', 'mharty'),
            'categories' => esc_html__('Categories', 'mharty'),
            'comments' => esc_html__('Comments', 'mharty'),
            )

    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_postinfo1_position',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Post info position', 'mharty'),
        'default'  =>	'above',
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Here you can choose where you want the post info block.', 'mharty'),
        'choices'     => array(
            'above'		=> esc_html__('Above title and media', 'mharty'),
            'middle'	=> esc_html__('Above title', 'mharty'),
            'below'		=> esc_html__('Below title', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_postinfo1_style',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Post info alternative style', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('This option will change the look for your post info to be in a stylish two-line format.', 'mharty'),
    );
    $controls[] = array(
      'type'     =>	'text',
      'setting'  =>	'mharty_postinfo_sep',
      'priority' =>	1.0,
      'label'    =>	esc_html__('Post info separator', 'mharty'),
      'default'  =>	' | ',
      'section'  =>	'mh_content_archive',
      'description' => esc_html__('Here you can change which character separates your post info. Default value is |', 'mharty'),

      //validation:nohtml
    );
    $controls[] = array(
      'type'     =>	'text',
      'setting'  =>	'mharty_postinfo_pre',
      'priority' =>	1.0,
      'label'    =>	esc_html__('Pre post author', 'mharty'),
      'default'  =>	esc_html__('By', 'mharty'),
      'section'  =>	'mh_content_archive',
      'description' => esc_html__("Here you can change the word before the post author. Default is 'By'.", "mharty"),

      //validation:nohtml
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_thumbnails_index',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Thumbnails', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Enable this option to show thumbnails on Archive Pages.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_content_index',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Content', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Enable this option to show post content on Archive Pages.', 'mharty'),
    );
    $controls[] = array(
      'type'     =>	'switch',
      'setting'  =>	'mharty_use_excerpt',
      'priority' =>	1.0,
      'label'    =>	esc_html__('Use excerpts when defined', 'mharty'),
      'default'  =>	false,
      'section'  =>	'mh_content_archive',
      'description' => esc_html__('This will enable the use of excerpts in posts or pages.', 'mharty'),
          'active_callback' => function () {
              return false != get_theme_mod('mharty_content_index');
          },
);
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_blog_style',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Blog Style Mode', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('By default the theme truncates your posts on index/homepages automatically to create post previews. If you would rather show your posts in full on index pages, like a traditional blog, then you can activate this feature.', 'mharty'),
          'active_callback' => function () {
              return false != get_theme_mod('mharty_content_index');
          },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_readmore_index',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Read More', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Enable this option to show read more link on Archive Pages.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_readmore_button',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Read More Button Style', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_archive',
        'description' => esc_html__('Here you can define whether to display "read more" link as a button.', 'mharty'),
        'active_callback' => function () {
            return false != get_theme_mod('mharty_readmore_index');
        },

    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_readmore_text',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Read More Text', 'mharty'),
        'default'  =>	esc_html__('Read more', 'mharty'),
        'section'  =>	'mh_content_archive',
        'description' => esc_html__("Here you can change 'Read more'.", 'mharty'),
      'active_callback' => function () {
          return false != get_theme_mod('mharty_readmore_index');
      },
    );

    ///////////////////////////
    //////Layouts: post//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'multiple-checkbox-image',
        'setting'  =>	'mharty_postinfo2',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Post Info', 'mharty'),
        'default'  =>	array(
            'author' => esc_html__('Author', 'mharty'),
            'date' => esc_html__('Date', 'mharty'),
            'categories' => esc_html__('Categories', 'mharty'),
            'comments' => esc_html__('Comments', 'mharty'),
        ),
        'section'  =>	'mh_content_post',
        'description' => esc_html__('Here you can choose which items appear in the post info section on single pages. This is usually below or above the post title.', 'mharty'),
        'choices'     => array(
            'avatar' => esc_html__('Avatar', 'mharty'),
            'author' => esc_html__('Author', 'mharty'),
            'date' => esc_html__('Date', 'mharty'),
            'categories' => esc_html__('Categories', 'mharty'),
            'comments' => esc_html__('Comments', 'mharty'),
            )
    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_postinfo2_position',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Post info position', 'mharty'),
        'default'  =>	'above',
        'section'  =>	'mh_content_post',
        'description' => esc_html__('Here you can choose where you want the post info block.', 'mharty'),
        'choices'     => array(
            'above'	 => esc_html__('Above title and media', 'mharty'),
            'below'	 => esc_html__('Below title', 'mharty'),
            'middle'	=> esc_html__('Below title and media', 'mharty'),
        ),

    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_thumbnails',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Place Thumbnails on Posts', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_post',
        'description' => esc_html__('By default thumbnails are placed at the beginning of your post on single post pages. If you would like to remove this initial thumbnail image to avoid repetition simply disable this option.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_grab_image',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Grab the First Post Image', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_post',
        'description' => esc_html__('By default thumbnail images are created using custom fields. However, if you would rather use the images that are already in your post for your thumbnail (and bypass using custom fields) you can activate this option. Once activcated thumbnail images will be generated automatically using the first image in your post. The image must be hosted on your own server.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_video_cover',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Video Cover Style', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_post',
        'description' => esc_html__('By default videos are placed at the beginning of your post on single post pages. If you would like to feature the video enable this option. This will work only on video post format.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_tags',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Tags', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_post',
        'description' => esc_html__('You can enable this option if you want to display tags on single post.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_related_posts',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Related Posts', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_post',
        'description' => esc_html__('You can enable this option if you want to display the related posts section on single post.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_related_posts_title',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Related Posts Title', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_content_post',
        'description' => esc_html__('If you have enabled related posts on your posts you can add your custom title here.', 'mharty'),
        'active_callback' => function () {
            return false != get_theme_mod('mharty_show_related_posts');
        },
    );
    $controls[] = array(
        'type'     => 'range',
        'setting' => 'mharty_related_posts_count',
        'label' => esc_html__('Maximum Related Posts Count', 'mharty'),
        'section'  =>	'mh_content_post',
        'default'  => '3',
        'input_attrs' => array(
            'min'  => 1,
            'max'  => 10,
            'step' => 1
        ),
        'priority' => 1.0,
        'active_callback' => function () {
            return false != get_theme_mod('mharty_show_related_posts');
        },
      );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_postcomments',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Comments on Posts', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_post',
        'description' => esc_html__('You can disable this option if you want to remove the comment form and the comments from all single post pages.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_post_nav',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Post Navigation', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_post',
        'description' => esc_html__('Enable this option If you want to display the post navigation.', 'mharty'),
    );
    ///////////////////////////
    //////Layouts: project//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_thumbnails_project',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Place Thumbnails on Projects', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_project',
        'description' => esc_html__('By default thumbnails are placed at the beginning of your post on single project pages. If you would like to remove this initial thumbnail image to avoid repetition simply disable this option.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_projectcomments',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Comments on Projects', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_content_project',
        'description' => esc_html__('You can disable this option if you want to remove the comment form and the comments from all single project pages.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_project_nav',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Project Navigation', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_project',
        'description' => esc_html__('Enable this option If you want to display the project navigation.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_project_tag_title',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Project Tags Title', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_content_project',
        'description' => esc_html__('Here you can change the title. Default value is: Skills', 'mharty'),

        //validation:nohtml
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_related_projects',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Related Projects', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_project',
        'description' => esc_html__('You can enable this option if you want to display the related projects section on single project.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_related_projects_title',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Related Projects Title', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_content_project',
        'description' => esc_html__('If you have enabled related projetcs, you can add your custom title here.', 'mharty'),
        'active_callback' => function () {
            return false != get_theme_mod('mharty_show_related_projects');
        },
    );
    $controls[] = array(
        'type'     => 'range',
        'setting' => 'mharty_related_projects_count',
        'label' => esc_html__('Maximum Related Projects Count', 'mharty'),
        'section'  =>	'mh_content_project',
        'default'  => '3',
        'input_attrs' => array(
            'min'  => 1,
            'max'  => 10,
            'step' => 1
        ),
        'priority' => 1.0,
        'active_callback' => function () {
            return false != get_theme_mod('mharty_show_related_projects');
        },
      );
    ///////////////////////////
    //////Layouts: page//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_page_thumbnails',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Place Thumbnails on Pages', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_page',
        'description' => esc_html__('By default thumbnails are not placed on pages (they are only used on posts). However, if you want to use thumbnails on pages you can! Just enable this option.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_pagescomments',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Comments on Pages', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_content_page',
        'description' => esc_html__('By default comments are not placed on pages, however, if you would like to allow people to comment on your pages simply enable this option.', 'mharty'),


    );
    ///////////////////////////
    //////Layouts: sidebar//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_index_page_sidebar',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Home Page Archive Layout', 'mharty'),
        'default'  =>	is_rtl() ? 'mh_left_sidebar' : 'mh_right_sidebar',
        'section'  =>	'mh_content_sidebar',
        'description' => esc_html__('Here you can choose Home Page Layout. This option will only work if you have the default homepage on your site.', 'mharty'),
        'choices'     => $sidebar_options,
    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_archive_page_sidebar',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Archive Pages Layout', 'mharty'),
        'default'  =>	is_rtl() ? 'mh_left_sidebar' : 'mh_right_sidebar',
        'section'  =>	'mh_content_sidebar',
        'description' => esc_html__('Here you can choose Archive Pages Layout such as Categories, tags, search pages etc', 'mharty'),
        'choices'     => $sidebar_options,
    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_pages_sidebar',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Pages Sidebar', 'mharty'),
        'default'  =>	'mh_default_sidebar',
        'section'  =>	'mh_content_sidebar',
        'description' => esc_html__('This will only work on pages without Mharty Composer. It will override individual page settings.', 'mharty'),
        'choices'     => $override_sidebar_options,
    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_posts_sidebar',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Posts Sidebar', 'mharty'),
        'default'  =>	'mh_default_sidebar',
        'section'  =>	'mh_content_sidebar',
        'description' => esc_html__('This will only work on posts without Mharty Composer. It will override individual post settings.', 'mharty'),
        'choices'     => $override_sidebar_options,
    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_projects_sidebar',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Projects Sidebar', 'mharty'),
        'default'  =>	'mh_default_sidebar',
        'section'  =>	'mh_content_sidebar',
        'description' => esc_html__('This will only work on projects without Mharty Composer. It will override individual project settings.', 'mharty'),
        'choices'     => $override_sidebar_options,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'icon',
        'setting'  => 'sidebar_titles',
        'label'    => esc_html__('Widgets Title Style', 'mharty'),
        'section'  => 'mh_content_sidebar',
        'default'  => 'none',
        'priority' => 1.0,
        'description' => esc_html__('Toggle between the various styles.', 'mharty'),
        'choices'  => array(
            'none' => 'sidebar_titles_none',
            'line' => 'sidebar_titles_line',
            'box' => 'sidebar_titles_box',
            'arrow' => 'sidebar_titles_arrow',
            'border' => 'sidebar_titles_border',
            'smallborder' => 'sidebar_titles_smallborder',
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'sidebar_border',
        'label'    => esc_html__('Sidebar Border', 'mharty'),
        'section'  => 'mh_content_sidebar',
        'default'  => 1,
        'priority' => 1.0,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
        'description' => esc_html__('Use this option to hide the sidebar border.', 'mharty'),
    );

    ///////////////////////////
    //////social icons//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_facebook_icon',
        'priority' =>	1.0,
        'label'    =>	'Facebook',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
    'type'     =>	'text',
    'setting'  =>	'mharty_facebook_url',
    'priority' =>	1.0,
    'label'    =>	esc_html__('URL', 'mharty'),
    'default'  =>	'#',
    'section'  =>	'mh_social_icons',
    'active_callback' => function () {
        return true == get_theme_mod('mharty_show_facebook_icon', true);
    },
);

    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_twitter_icon',
        'priority' =>	1.0,
        'label'    =>	'Twitter',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_twitter_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_twitter_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_instagram_icon',
        'priority' =>	1.0,
        'label'    =>	'Instagram',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_instagram_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_instagram_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_youtube_icon',
        'priority' =>	1.0,
        'label'    =>	'YouTube',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_youtube_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'description' => esc_html__('Enter the URL of your YouTube Channel.', 'mharty'),
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_youtube_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_linkedin_icon',
        'priority' =>	1.0,
        'label'    =>	'LinkedIn',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_linkedin_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_linkedin_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_behance_icon',
        'priority' =>	1.0,
        'label'    =>	'Behance',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_behance_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_behance_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_dribbble_icon',
        'priority' =>	1.0,
        'label'    =>	'Dribbble',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_dribbble_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_dribbble_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_flickr_icon',
        'priority' =>	1.0,
        'label'    =>	'Flickr',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_flickr_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_flickr_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_soundcloud_icon',
        'priority' =>	1.0,
        'label'    =>	'SoundCloud',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_soundcloud_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_soundcloud_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_skype_icon',
        'priority' =>	1.0,
        'label'    =>	'Skype',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_skype_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Username', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'description' => esc_html__('Enter your Skype Username.', 'mharty'),
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_skype_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_telegram_icon',
        'priority' =>	1.0,
        'label'    =>	'Telegram',
        'default'  =>	true,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_telegram_url',
        'priority' =>	1.0,
        'label'    => esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_telegram_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_mixlr_icon',
        'priority' =>	1.0,
        'label'    =>	'Mixlr',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_mixlr_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_mixlr_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_periscope_icon',
        'priority' =>	1.0,
        'label'    =>	'Periscope',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_periscope_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_periscope_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_younow_icon',
        'priority' =>	1.0,
        'label'    =>	'YouNow',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_younow_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_younow_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_snapchat_icon',
        'priority' =>	1.0,
        'label'    =>	'Snapchat',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_snapchat_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
       'active_callback' => function () {
           return true === get_theme_mod('mharty_show_snapchat_icon', false);
       },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_tripadvisor_icon',
        'priority' =>	1.0,
        'label'    =>	'TripAdvisor',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_tripadvisor_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_tripadvisor_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_pinterest_icon',
        'priority' =>	1.0,
        'label'    =>	'Pinterest',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_pinterest_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_pinterest_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_whatsapp_icon',
        'priority' =>	1.0,
        'label'    =>	'WhatsApp',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_whatsapp_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'description' =>  esc_html__('Enter the URL of your WhatsApp here. For more info', 'mharty') . ' <a href="https://faq.whatsapp.com/general/26000030?lang=ar" target="_blank">' . esc_html__('click here', 'mharty') . '</a>',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_whatsapp_icon', true);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_slack_icon',
        'priority' =>	1.0,
        'label'    =>	'Slack',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_slack_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_slack_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_github_icon',
        'priority' =>	1.0,
        'label'    =>	'Github',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_github_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
       'active_callback' => function () {
           return true === get_theme_mod('mharty_show_github_icon', false);
       },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_wordpress_icon',
        'priority' =>	1.0,
        'label'    =>	'WordPress',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_wordpress_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
      'active_callback' => function () {
          return true === get_theme_mod('mharty_show_wordpress_icon', false);
      },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_tiktok_icon',
        'priority' =>	1.0,
        'label'    =>	'TikTok',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_tiktok_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_tiktok_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_clubhouse_icon',
        'priority' =>	1.0,
        'label'    =>	'Clubhouse',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_clubhouse_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_clubhouse_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_zoom_icon',
        'priority' =>	1.0,
        'label'    =>	'Zoom',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_zoom_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_zoom_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_beeto_icon',
        'priority' =>	1.0,
        'label'    =>	'Beeto',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_beeto_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_beeto_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_apple_podcast_icon',
        'priority' =>	1.0,
        'label'    =>	'Apple Podcast',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_apple_podcast_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_apple_podcast_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_google_podcast_icon',
        'priority' =>	1.0,
        'label'    =>	'Google Podcast',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_google_podcast_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_google_podcast_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_spotify_icon',
        'priority' =>	1.0,
        'label'    =>	'Spotify',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_spotify_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_spotify_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_podchaser_icon',
        'priority' =>	1.0,
        'label'    =>	'Podchaser',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_podchaser_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_podchaser_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_reddit_icon',
        'priority' =>	1.0,
        'label'    =>	'Reddit',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_reddit_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_reddit_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_rss_icon',
        'priority' =>	1.0,
        'label'    =>	'RSS',
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_rss_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_social_icons',
        'description' => esc_html__('Enter the URL of your RSS feed.', 'mharty'),
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_rss_icon', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_custom_1_icon',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Custom Icon 1', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'mharty_custom_1_icon',
        'label'    => esc_html__('Icon', 'mharty'),
        'section'  =>	'mh_social_icons',
        'default'  => '',
        'priority' => 1.0,
      'active_callback' => function () {
          return true == get_theme_mod('mharty_show_custom_1_icon', false);
      },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_custom_1_icon_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'description' => esc_html__('Enter the URL here.', 'mharty'),
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_custom_1_icon', false);
        },
    );
    $controls[] = array(
        'type'     => 'color',
      'setting'  => 'mharty_custom_1_icon_color',
        'label'    => esc_html__('Icon Colour', 'mharty'),
        'section'  =>	'mh_social_icons',
        'default'  => '#cccccc',
        'priority' => 1.0,
      'active_callback' => function () {
          return true == get_theme_mod('mharty_show_custom_1_icon', false);
      },
    );

    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_custom_2_icon',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Custom Icon 2', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_social_icons',
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'mharty_custom_2_icon',
        'label'    => esc_html__('Icon', 'mharty'),
        'section'  =>	'mh_social_icons',
        'default'  => '',
        'priority' => 1.0,
      'active_callback' => function () {
          return true == get_theme_mod('mharty_show_custom_2_icon', false);
      },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_custom_2_icon_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_social_icons',
        'description' => esc_html__('Enter the URL here.', 'mharty'),
        'active_callback' => function () {
            return true === get_theme_mod('mharty_show_custom_2_icon', false);
        },
    );
    $controls[] = array(
        'type'     => 'color',
      'setting'  => 'mharty_custom_2_icon_color',
        'label'    => esc_html__('Icon Colour', 'mharty'),
        'section'  =>	'mh_social_icons',
        'default'  => '#cccccc',
        'priority' => 1.0,
      'active_callback' => function () {
          return true == get_theme_mod('mharty_show_custom_2_icon', false);
      },
    );
    ///////////////////////////
    //////Ads//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_468_enable',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Enable Single Post 468x60 Banner', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_ads',
        'description' => esc_html__('Enabling this option will display a 468x60 banner ad on the bottom of your post pages below the single post content. If enabled you must fill in the banner image and destination url below.', 'mharty'),


    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_468_image',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Input 468x60 Ad Banner Image', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_ads',
        'description' => esc_html__('Here you can provide 468x60 banner image url.', 'mharty'),
        'active_callback' => function () {
            return false != get_theme_mod('mharty_468_enable', false);
        },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_468_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Input 468x60 Ad Destination URL', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_ads',
        'description' => esc_html__('Here you can provide 468x60 banner destination url.', 'mharty'),
    'active_callback' => function () {
        return false != get_theme_mod('mharty_468_enable', false);
    },
    );
    $controls[] = array(
        'type'     =>	'textarea',
        'setting'  =>	'mharty_468_foursixeight',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Input 468x60 Ad Code', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_ads',
        'description' => esc_html__('Place your Ad Javascript code here.', 'mharty'),
    'active_callback' => function () {
        return false != get_theme_mod('mharty_468_enable', false);
    },

    );

    ///////////////////////////
    //////Layouts: general//////
    //////////////////////////
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'site_title_heading',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Site Title', 'mharty'),
        'section'  => 'mh_google_fonts',
        'active_callback' => function () {
            return false != get_theme_mod('use_logo_text', false);
        },
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'site_title_size',
        'label'    => esc_html__('Size', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => '26',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 72,
                'step' => 1
            ),
        'priority' => 1.0,
        'active_callback' => function () {
            return false != get_theme_mod('use_logo_text', false);
        },
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'site_title_style',
        'label'    => esc_html__('Style', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'bold',
        'priority' => 1.0,
        'choices'     => array(
            'none'  => esc_html__('None', 'mharty'),
            'bold'       => esc_html__('B', 'mharty'),
            'italic'     => esc_html__('I', 'mharty'),
            'italicbold'     => esc_html__('I', 'mharty'),
            'uppercase'  => esc_html__('TT', 'mharty'),
            'uppercasebold'  => esc_html__('TT', 'mharty'),
        ),
        'description' => esc_html__('Uppercase options work only with Latin alphabet.', 'mharty'),
      'active_callback' => function () {
          return false != get_theme_mod('use_logo_text', false);
      },
    );

    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_font_heading',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Header Font', 'mharty'),
        'section'  => 'mh_google_fonts',
    );
    $controls[] = array(
        'type'		=> 'font',
        'setting'  => 'heading_font',
        'label'    => esc_html__('Font', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'none',
        'priority' => 1.0,
        'choices'	=> $font_choices,
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'h1_font_size',
        'label'    => esc_html__('Size', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => '26',
        'input_attrs' => array(
                'min'  => 22,
                'max'  => 86,
                'step' => 1
            ),
        'priority' => 1.2,
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'h1_font_height',
        'label'    => esc_html__('Line Height', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => '1.4',
        'input_attrs' => array(
                'min'  => 0.8,
                'max'  => 3,
                'step' => 0.1
            ),
        'priority' => 1.3,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'h1_font_style',
        'label'    => esc_html__('Style', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'none',
        'priority' => 1.4,
        'choices'     => array(
            'none'  => esc_html__('None', 'mharty'),
            'bold'       => esc_html__('B', 'mharty'),
            'italic'     => esc_html__('I', 'mharty'),
            'italicbold'     => esc_html__('I', 'mharty'),
            'uppercase'  => esc_html__('TT', 'mharty'),
            'uppercasebold'  => esc_html__('TT', 'mharty'),
        ),
        'description' => esc_html__('Uppercase options work only with Latin alphabet.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'body_font_heading',
        'priority' =>	1.4,
        'label'    =>	esc_html__('Body Font', 'mharty'),
        'section'  => 'mh_google_fonts',
    );
    $controls[] = array(
      'type'		=> 'font',
      'setting'  => 'body_font',
      'label'    => esc_html__('Font', 'mharty'),
      'section'  => 'mh_google_fonts',
      'default'  => 'none',
      'priority' => 1.4,
      'choices'	=> $font_choices,
);
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'body_font_size',
        'label'    => esc_html__('Size', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => '14',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 36,
                'step' => 1
            ),
        'priority' => 1.5,
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'body_font_height',
        'label'    => esc_html__('Line Height', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => '1.7',
        'input_attrs' => array(
                'min'  => 0.8,
                'max'  => 3,
                'step' => 0.1
            ),
        'priority' => 1.6,
        //'description' => esc_html__( 'Default is 1.7, You could change it to your desired size.', 'mharty' ),
    );
    $controls[] = array(
    'type' => 'switch',
        'setting' => 'body_font_include',
        'label' => esc_html__('Include Other Texts', 'mharty'),
        'section' => 'mh_google_fonts',
        'default'  => false,
        'priority' => 1.6,
        'description' => esc_html__('Enable this option if you want to adjust other text according to body font size.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'link_style',
        'priority' =>	1.6,
        'label'    =>	esc_html__('Link Style', 'mharty'),
        'default'  =>	'accent',
         'section' => 'mh_google_fonts',
        'choices'     => array(
            'accent' 	=> esc_html__('Colour', 'mharty'),
            'line'    => esc_html__('Underline', 'mharty'),
        'hover' 	=> esc_html__('Underline & Hover', 'mharty'),
            'fx'    => esc_html__('Underline, Colour & Hover', 'mharty'),
        ),
      'description' => esc_html__('This will take accent colour.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'menu_font_heading',
        'priority' =>	1.7,
        'label'    =>	esc_html__('Menu Font Options', 'mharty'),
        'section'  => 'mh_google_fonts',
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'menu_font_size',
        'label'    => esc_html__('Size', 'mharty'),
        'section' => 'mh_google_fonts',
        'default'  => '14',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 48,
                'step' => 1
        ),
        'priority' => 1.7,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'menu_font_style',
        'label'    => esc_html__('Style', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'none',
        'priority' => 1.7,
        'choices'     => array(
            'none'  => esc_html__('None', 'mharty'),
            'bold'       => esc_html__('B', 'mharty'),
            'italic'     => esc_html__('I', 'mharty'),
            'italicbold'     => esc_html__('I', 'mharty'),
            'uppercase'  => esc_html__('TT', 'mharty'),
            'uppercasebold'  => esc_html__('TT', 'mharty'),
        ),
        'description' => esc_html__('Uppercase options work only with Latin alphabet.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'subnav_font_size',
        'label'    => esc_html__('Sub Navigation Font Size', 'mharty'),
        'section' => 'mh_google_fonts',
        'default'  => '14',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 36,
                'step' => 1
        ),
        'priority' => 1.7,
    );

    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'secondary_nav_font_size',
        'label'    => esc_html__('Secondary Navigation Font Size', 'mharty'),
        'section' => 'mh_google_fonts',
        'default'  => '13',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 36,
                'step' => 1
        ),
        'priority' => 1.7,
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'app_nav_font_size',
        'label'    => esc_html__('Mobile Menu Font Size', 'mharty'),
        'section' => 'mh_google_fonts',
        'default'  => '14',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 48,
                'step' => 1
        ),
        'priority' => 1.8,
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'alternative_font_heading',
        'priority' =>	2,
        'label'    =>	esc_html__('Alternative Font', 'mharty'),
        'section'  => 'mh_google_fonts',
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'menu_font',
        'label'    => esc_html__('Primary Navigation Font', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'header',
        'priority' => 2,
        'choices'  => array(
            'header' => esc_html__('Headings', 'mharty'),
            'body' => esc_html__('Body', 'mharty'),
        )
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'secondary_nav_font',
        'label'    => esc_html__('Secondary Navigation Font', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'body',
        'priority' => 2.1,
        'choices'  => array(
            'header' => esc_html__('Headings', 'mharty'),
            'body' => esc_html__('Body', 'mharty'),
        )
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'app_menu_font',
        'label'    => esc_html__('Mobile Menu Font', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'body',
        'priority' => 2.2,
        'choices'  => array(
            'header' => esc_html__('Headings', 'mharty'),
            'body' => esc_html__('Body', 'mharty'),
        )
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'footer_font',
        'label'    => esc_html__('Footer Font', 'mharty'),
        'section'  => 'mh_google_fonts',
        'default'  => 'body',
        'priority' => 2.3,
        'choices'  => array(
            'header' => esc_html__('Headings', 'mharty'),
            'body' => esc_html__('Body', 'mharty'),
        )
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'use_logo_text',
        'label' => esc_html__('Site Title as a Logo', 'mharty'),
        'section' => 'title_tagline',
        'default'  => false,
        'priority' => 21,
        'description' => esc_html__('If you want to use your site name and tagline instead of an image based logo enable this option.', 'mharty'),
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'title_tagline_show',
        'label' => esc_html__('Show Tagline', 'mharty'),
        'section' => 'title_tagline',
        'default'  => true,
        'priority' => 21,
      'active_callback' => function () {
          return false != get_theme_mod('use_logo_text', false);
      },
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'mharty_logo',
        'label'    => esc_html__('Logo Image', 'mharty'),
        'section'  => 'title_tagline',
        'default'  => '',
        'priority' => 22,
        'description' => esc_html__('Click the button to upload your logo.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'mharty_og_logo',
        'label'    => esc_html__('Open Graph Image', 'mharty'),
        'section'  => 'title_tagline',
        'default'  => '',
        'priority' => 80,
        'description' => esc_html__('Upload an image to be used when sharing your website on social networks.', 'mharty'),
      );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'icon',
        'setting'  => 'boxed_layout',
        'label'    => esc_html__('Layout Style', 'mharty'),
        'section'  => 'mh_mharty_settings',
        'priority' => 1.5,
        'default'  => 0,
        'description' => esc_html__('Choose between full-width or boxed.', 'mharty'),
        'choices'  => array(
            0 => 'boxed_layout_full',
            1 => 'boxed_layout_boxed',
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'icon',
        'setting'  => 'site_width',
        'label'    => esc_html__('Website Width', 'mharty'),
        'section'  => 'mh_mharty_settings',
        'priority' => 1.6,
        'default'  => 0,
        'description' => esc_html__('Choose between wide or narrow.', 'mharty'),
        'choices'  => array(
            0 => 'site_width_wide',
            1 => 'site_width_narrow',
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'icon',
        'setting'  => 'round_style',
        'label'    => esc_html__('Corners Style', 'mharty'),
        'section'  => 'mh_mharty_settings',
        'default'  => 'square',
        'priority' => 1.7,
        'description' => esc_html__('This will affect buttons and icons.', 'mharty'),
        'choices'  => array(
            'square' => 'round_style_square',
            'rounded'  => 'round_style_rounded',
            'capsule'  => 'round_style_capsule',
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'icon',
        'setting'  => 'icons_style',
        'label'    => esc_html__('Header and Footer Icons Style', 'mharty'),
        'section'  => 'mh_mharty_settings',
        'default'  => 'only',
        'priority' => 1.8,
        'description' => esc_html__('Choose between simple or border.', 'mharty'),
        'choices'  => array(
            'only' => 'icons_style_only',
            'bordered' => 'icons_style_bordered',
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'back_to_top',
        'label'    => esc_html__('Back To Top Button', 'mharty'),
        'section'  => 'mh_mharty_settings',
        'default'  => 0,
        'priority' => 3.0,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
        'description' => esc_html__('Enable this option to display Back To Top Button while scrolling.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'site_side_buttons_heading',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Quick Contact Form', 'mharty'),
        'section'  =>	'mh_quick_contact',
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_quick_contact',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Quick Contact Form', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('Here you can choose to display the Quick contact form on your website.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_quick_contact_email',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Email', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('Put the email to which messages will be sent.', 'mharty'),
        'active_callback' => function () {
            return get_theme_mod('mharty_show_quick_contact', false);
        },
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'mharty_quick_contact_icon',
        'label'    => esc_html__('Icon', 'mharty'),
    'section'  =>	'mh_quick_contact',
        'default'  => '',
        'priority' => 1.0,
        'active_callback' => function () {
            return get_theme_mod('mharty_show_quick_contact', false);
        },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_quick_contact_button_text',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Custom Text', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_quick_contact',
    'active_callback' => function () {
        return get_theme_mod('mharty_show_quick_contact', false);
    },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_quick_contact_title',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Title', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('You could use this field to display a title for your quick contact form.', 'mharty'),
    'active_callback' => function () {
        return get_theme_mod('mharty_show_quick_contact', false);
    },
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'mharty_quick_contact_avatar',
        'label'    => esc_html__('Logo', 'mharty'),
        'section'  =>	'mh_quick_contact',
        'default'  => '',
        'priority' => 1.0,
      'active_callback' => function () {
          return get_theme_mod('mharty_show_quick_contact', false);
      },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_quick_contact_blurb',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Excerpt', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('You could use this field to display an excerpt for your quick contact form.', 'mharty'),
    'active_callback' => function () {
        return get_theme_mod('mharty_show_quick_contact', false);
    },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_quick_contact_message',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Success Message', 'mharty'),
        'default'  =>	esc_html__('Thank you for contacting us.', 'mharty'),
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('Define a message to display after successful form submission. Leave empty to use the default message.', 'mharty'),
      'active_callback' => function () {
          return get_theme_mod('mharty_show_quick_contact', false);
      },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_quick_contact_captcha',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Enable Captcha', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('You can enable captcha for your contact form.', 'mharty'),
        'active_callback' => function () {
            return get_theme_mod('mharty_show_quick_contact', false);
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_quick_contact_use_redirect',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Use Redirect', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('Redirect visitors after successful form submission.', 'mharty'),
          'active_callback' => function () {
              return get_theme_mod('mharty_show_quick_contact', false);
          },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_quick_contact_redirect_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Redirect URL', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_quick_contact',
        'description' => esc_html__('Input the Redirect URL here, This will redirect visitors after successful form submission.', 'mharty'),
         'active_callback' => function () {
             return get_theme_mod('mharty_show_quick_contact', false);
         },
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'quick_social_heading',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Quick Social Icon', 'mharty'),
        'section'  =>	'mh_quick_social',
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_show_quick_social',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Show Quick Social Icon', 'mharty'),
        'default'  =>	false,
        'section'  =>	'mh_quick_social',
        'description' => esc_html__('Here you can choose to display the Quick Social Icon on your website.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'select',
        'setting'  =>	'mharty_quick_social_list',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Social Network', 'mharty'),
        'default'  =>	'twitter',
        'section'  =>	'mh_quick_social',
        'choices'  => mh_social_network_list(),
        'active_callback' => function () {
            return true == get_theme_mod('mharty_show_quick_social', false);
        },
    );
    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_quick_social_url',
        'priority' =>	1.0,
        'label'    =>	esc_html__('URL', 'mharty'),
        'default'  =>	'#',
        'section'  =>	'mh_quick_social',
        'description' => esc_html__('Enter the URL here.', 'mharty'),
           'active_callback' => function () {
               return true == get_theme_mod('mharty_show_quick_social', false);
           },
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'header_style',
        'label'    => esc_html__('Main Menu Layout', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'right',
        'priority' => 3.0,
        'choices'  => array(
            'right' => esc_html__('Side', 'mharty'),
            'inline' => esc_html__('Inline', 'mharty'),
            'full' => esc_html__('Fullwidth', 'mharty'),
            'centered' => esc_html__('Centre 1', 'mharty'),
            'centeredx' => esc_html__('Centre 2', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'select',
        'setting'  => 'header_animation',
        'label'    => esc_html__('Main Menu Animation', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'off',
        'priority' => 3.0,
        'choices'  => array(
          'off' => esc_html__('No Animation', 'mharty'),
          'right' => esc_html__('From Right', 'mharty'),
          'left' => esc_html__('From Left', 'mharty'),
          'top' => esc_html__('From Top', 'mharty'),
          'bottom' => esc_html__('From Bottom', 'mharty'),
          'scaleup' => esc_html__('Scale Up', 'mharty'),
          'fade_in' => esc_html__('Fade In', 'mharty'),
          'tilt_in' => esc_html__('Tilt In', 'mharty'),
          'blur_in' => esc_html__('Blur In', 'mharty'),
          'blur_fwd' => esc_html__('Blur Forward', 'mharty'),
          'blur_bck' => esc_html__('Blur Backward', 'mharty'),
          'rotate_right' => esc_html__('Rotate from Right', 'mharty'),
          'rotate_left' => esc_html__('Rotate from Left', 'mharty'),
          'horizontal' => esc_html__('Expand Horizontal', 'mharty'),
          'vertical' => esc_html__('Expand Vertical', 'mharty'),
          'bouncein' => esc_html__('Bounce In', 'mharty'),
          'bounceinup' => esc_html__('Bounce from Top', 'mharty'),
          'bounceindown' => esc_html__('Bounce from Bottom', 'mharty'),
          'bounceinright' => esc_html__('Bounce from Right', 'mharty'),
          'bounceinleft' => esc_html__('Bounce from Left', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'subnav_animation',
        'label'    => esc_html__('Sub-Menu Animation', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'fadein',
        'priority' => 3.0,
        'choices'  => array(
            'fadein' => esc_html__('Fade 1', 'mharty'),
            'fadebottom' => esc_html__('Fade 2', 'mharty'),
            'expand' => esc_html__('Expand', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'header_shadow',
        'label'    => esc_html__('Main Menu Shadow', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 0,
        'priority' => 3.0,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_1',
        'priority' =>	3.1,
        'label'    =>	esc_html__('Logo', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'xl_logo',
        'label'    => esc_html__('Logo Size', 'mharty'),
        'section'  => 'mh_primary_nav',
        'priority' => 3.1,
        'description' => esc_html__('By default the logo height is around 40 pixels. You can define a custom size here (numeric value only).', 'mharty'),
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'header_padding',
        'label' => esc_html__('Remove Logo Padding', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => false,
        'priority' => 3.1,
        'description' => esc_html__('This option will remove the default padding around the logo and menu items.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'header_padding_top',
        'label'    => esc_html__('Add Top Padding', 'mharty'),
        'section'  => 'mh_primary_nav',
        'priority' => 3.1,
        'description' => esc_html__('Add more padding space to top of you header. Use numbers only e.g. 50', 'mharty'),
        'active_callback' => function () {
            return true == get_theme_mod('header_padding', false);
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'header_padding_bottom',
        'label'    => esc_html__('Add Bottom Padding', 'mharty'),
        'section'  => 'mh_primary_nav',
        'priority' => 3.1,
        'description' => esc_html__('Add more padding space to bottom of you header. Use numbers only e.g. 50', 'mharty'),
        'active_callback' => function () {
            return true == get_theme_mod('header_padding', false);
        },
    );
    $controls[] = array(
      'type'     => 'range',
        'setting' => 'menu_padding',
        'label' => esc_html__('Padding Between Menu Items', 'mharty'),
        'section' => 'mh_primary_nav',
      'default'  => '15',
        'input_attrs' => array(
                'min'  => 5,
                'max'  => 30,
                'step' => 1
            ),
        'priority' => 3.1,
        'description' => esc_html__('Adjust the gaps between main menu items.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_2',
        'priority' =>	3.2,
        'label'    =>	esc_html__('Fixed Main Menu', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'fixed_menu',
        'label'    => esc_html__('Fixed Menu Style', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'off',
        'priority' => 3.2,
        'choices'  => array(
          'off' => esc_html__('Disable', 'mharty'),
          'scroll' => esc_html__('On-scroll', 'mharty'),
          'top' => esc_html__('Sticky', 'mharty'),
        ),
      'description' => esc_html__('Fixed Menu Style: visible when scrolling, always visible, or no effect.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'mharty_logo_sticky_active',
        'label'    => esc_html__('Alternative Sticky Menu Logo', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 0,
        'priority' => 3.2,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
      'active_callback' => function () {
          return 'top' == get_theme_mod('fixed_menu', 'off');
      },
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'mharty_logo_sticky',
        'label'    => esc_html__('Alternative Logo', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => '',
        'priority' => 3.2,
      'active_callback' => function () {
          return 'top' == get_theme_mod('fixed_menu', 'off');
      },
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_7',
        'priority' =>	3.3,
        'label'    =>	esc_html__('Call to Action 1', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'show_top_cta',
        'label' => esc_html__('Enable CTA 1', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => false,
        'priority' => 3.3,
        'description' => esc_html__('Display a custom call to action in the main menu.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'top_cta_style',
        'label'    => esc_html__('CTA Style', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'button',
        'priority' => 3.3,
        'choices'  => array(
            'button' => esc_html__('Button', 'mharty'),
        'icon' => _x('Icon', 'Single', 'mharty'),
            'text' => esc_html__('Text', 'mharty'),
        ),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta');
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'top_cta_text',
        'label'    => esc_html__('CTA Text', 'mharty'),
        'section' => 'mh_primary_nav',
        'priority' => 3.3,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta');
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'top_cta_url',
        'label'    => esc_html__('CTA URL', 'mharty'),
        'section' => 'mh_primary_nav',
        'priority' => 3.3,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta');
        },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'top_cta_url_target',
        'label' => esc_html__('Open link in a new tab', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => false,
        'priority' => 3.3,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta');
        },
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'top_cta_icon',
        'label'    => esc_html__('CTA Icon', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => '',
        'priority' => 3.3,
        'active_callback' => function () {
            return 'icon' === get_theme_mod('top_cta_style', 'button');
        },
    );
    $controls[] = array(
      'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  =>	'top_cta_button_style',
        'priority' =>	3.3,
        'label'    =>	esc_html__('Style', 'mharty'),
        'default'  =>	'solid',
         'section' => 'mh_primary_nav',
        'choices'     => array(
            'solid'   => esc_html__('Solid', 'mharty'),
        'border'    => esc_html__('Bordered', 'mharty'),
        ),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta') && 'button' === get_theme_mod('top_cta_style', 'button');
        },
    );
    $controls[] = array(
        'type'     => 'select',
        'setting'  => 'top_cta_animation',
        'label'    => esc_html__('Animation', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'off',
        'priority' => 3.3,
        'choices'  => array(
        'off' => esc_html__('No Animation', 'mharty'),
        'shaking'	=> esc_html__('Shake', 'mharty'),
        'wobbling'	=> esc_html__('Wobble', 'mharty'),
        'jellying'	=> esc_html__('jelly', 'mharty'),
        'bouncing'	=> esc_html__('Bounce', 'mharty'),
        'blink' => esc_html__('Blink (Constant)', 'mharty'),
        ),
      'active_callback' => function () {
          return 1 == get_theme_mod('show_top_cta');
      },
    );
    //cta2
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_8',
        'priority' =>	3.3,
        'label'    =>	esc_html__('Call to Action 2', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'show_top_cta_2',
        'label' => esc_html__('Enable CTA 2', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => false,
        'priority' => 3.3,
        'description' => esc_html__('Display a custom call to action in the main menu.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'top_cta_style_2',
        'label'    => esc_html__('CTA Style', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'button',
        'priority' => 3.3,
        'choices'  => array(
            'button' => esc_html__('Button', 'mharty'),
        'icon' => _x('Icon', 'Single', 'mharty'),
            'text' => esc_html__('Text', 'mharty'),
        ),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta_2');
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'top_cta_text_2',
        'label'    => esc_html__('CTA Text', 'mharty'),
        'section' => 'mh_primary_nav',
        'priority' => 3.3,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta_2');
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'top_cta_url_2',
        'label'    => esc_html__('CTA URL', 'mharty'),
        'section' => 'mh_primary_nav',
        'priority' => 3.3,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta_2');
        },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'top_cta_url_target_2',
        'label' => esc_html__('Open link in a new tab', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => false,
        'priority' => 3.3,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta_2');
        },
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'top_cta_icon_2',
        'label'    => esc_html__('CTA Icon', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => '',
        'priority' => 3.3,
        'active_callback' => function () {
            return 'icon' === get_theme_mod('top_cta_style_2', 'button');
        },
    );
    $controls[] = array(
      'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  =>	'top_cta_button_style_2',
        'priority' =>	3.3,
        'label'    =>	esc_html__('Style', 'mharty'),
        'default'  =>	'solid',
         'section' => 'mh_primary_nav',
        'choices'     => array(
            'solid'   => esc_html__('Solid', 'mharty'),
        'border'    => esc_html__('Bordered', 'mharty'),
        ),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_top_cta_2') && 'button' === get_theme_mod('top_cta_style_2', 'button');
        },
    );
    $controls[] = array(
        'type'     => 'select',
        'setting'  => 'top_cta_animation_2',
        'label'    => esc_html__('Animation', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'off',
        'priority' => 3.3,
        'choices'  => array(
        'off' => esc_html__('No Animation', 'mharty'),
        'shaking'	=> esc_html__('Shake', 'mharty'),
        'wobbling'	=> esc_html__('Wobble', 'mharty'),
        'jellying'	=> esc_html__('jelly', 'mharty'),
        'bouncing'	=> esc_html__('Bounce', 'mharty'),
        'blink' => esc_html__('Blink (Constant)', 'mharty'),
        ),
      'active_callback' => function () {
          return 1 == get_theme_mod('show_top_cta_2');
      },
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_4',
        'priority' =>	3.3,
        'label'    =>	esc_html__('Search Style & Icon', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'show_search_icon',
        'label'    => esc_html__('Search Style', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'full',
        'priority' => 3.3,
        'choices'  => array(
            'hide' => esc_html__('Hide', 'mharty'),
            'full' => esc_html__('Full-width', 'mharty'),
            'default' => esc_html__('Default', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'full_search_text',
        'label'    => esc_html__('Full-width Search Text', 'mharty'),
        'section'  => 'mh_primary_nav',
      'default'  => esc_html__('Type and Press "Enter"', 'mharty'),
        'priority' => 3.3,
        'description' => esc_html__('Default is: Type and Press "Enter".', 'mharty'),
        'active_callback' => function () {
            return 'full' == get_theme_mod('show_search_icon', 'full');
        },
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'search_icon',
        'label'    => esc_html__('Search Icon', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => '',
        'priority' => 3.3,
        'active_callback' => function () {
            return 'hide' != get_theme_mod('show_search_icon');
        },
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_3',
        'priority' =>	3.4,
        'label'    =>	esc_html__('Extra Logo', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'mharty_extra_logo',
        'label' => esc_html__('Enable Extra Logo', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => false,
        'priority' => 3.4,
        'description' => esc_html__('Display an additional logo on the opposite side of the header.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'mharty_extra_logo_img',
        'label'    => esc_html__('Extra Logo', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => '',
        'priority' => 3.4,
        'active_callback' => function () {
            return true == get_theme_mod('mharty_extra_logo', true);
        },
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_5',
        'priority' =>	4.1,
        'label'    =>	esc_html__('Header Background', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'header_bg_img',
        'label'    => esc_html__('Header Background', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => '',
        'priority' => 4.1,
        'description' => esc_html__('Upload or choose a background image for the header area.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'header_bg_position_x',
        'label'    => esc_html__('Align Header Background', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'center',
        'priority' => 4.2,
        'choices'  => array(
            'center' => esc_html__('Centre', 'mharty'),
            'right' => esc_html__('Right', 'mharty'),
            'left' => esc_html__('Left', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'header_bg_position_y',
        'label'    => esc_html__('Align Header Background', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'center',
        'priority' => 4.3,
        'choices'  => array(
            'center' => esc_html__('Centre', 'mharty'),
            'top' => esc_html__('Top', 'mharty'),
            'bottom' => esc_html__('Bottom', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'header_bg_size',
        'label'    => esc_html__('Background Size', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'auto',
        'priority' => 4.4,
        'choices'  => array(
            'auto' => esc_html__('Auto', 'mharty'),
            'cover' => esc_html__('Cover', 'mharty'),
            'contain' => esc_html__('Contain', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'header_bg_repeat',
        'label'    => esc_html__('Repeat Background', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 'no-repeat',
        'priority' => 4.5,
        'choices'  => array(
            'no-repeat' => esc_html__('No Repeat', 'mharty'),
            'repeat-x' => esc_html__('Repeat X', 'mharty'),
            'repeat-y' => esc_html__('Repeat Y', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'header_heading_6',
        'priority' =>	4.6,
        'label'    =>	esc_html__('Other', 'mharty'),
          'section'  => 'mh_primary_nav',
    );
    $controls[] = array(
    'type' => 'switch',
        'setting' => 'hide_nav_menu',
        'label' => esc_html__('Hide Navigation Links?', 'mharty'),
        'section' => 'mh_primary_nav',
        'default'  => false,
        'priority' => 4.9,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'vertical_nav',
        'label'    => esc_html__('Navigation Position (Legacy)', 'mharty'),
        'section'  => 'mh_primary_nav',
        'default'  => 0,
        'priority' => 5.0,
        'choices'  => array(
            0 => esc_html__('Horizontal', 'mharty'),
            1 => esc_html__('Vertical', 'mharty'),
        ),
        'description' => esc_html__('We recommend "Horizontal" to enjoy stability and a wide range of options across screen sizes. "Vertical" Navigation is a legacy system and may be deprecated in future releases.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'secondary_nav_position',
        'label'    => esc_html__('Secondary Navigation Position', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'default'  => 0,
        'priority' => 5.1,
        'choices'  => array(
            0 => esc_html__('Below', 'mharty'),
            1 => esc_html__('Above', 'mharty'),
        ),
        'description' => esc_html__('Choose the Position of your Secondary Navigation. The Secondary Navigation appears when it has some contents filled.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'show_header_social_icons',
        'label'    => esc_html__('Social Icons in Header', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'default'  => 0,
        'priority' => 5.2,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
        'description' => esc_html__('You may need to activate the desired icons from Social Icons section.', 'mharty'),
    );

    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting' => 'show_header_date',
        'label' => esc_html__('Show Date', 'mharty'),
        'section' => 'mh_secondary_nav',
        'default'  => 0,
        'priority' => 5.3,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
    );

    $controls[] = array(
        'type'     =>	'text',
        'setting'  =>	'mharty_header_date_format',
        'priority' =>	5.3,
        'label'    =>	esc_html__('Header Date Format', 'mharty'),
        'default'  =>	'd/m/Y',
        'section'  =>	'mh_secondary_nav',
        'description' => __('This option allows you to change how your dates are displayed. For more information please refer to the WordPress codex here:<a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank">Formatting Date and Time</a>', 'mharty'),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_header_date', 0);
        },

    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'secondary_nav_date_icon',
        'label'    => esc_html__('Date Icon', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'default'  => '',
        'priority' => 5.3,
      'active_callback' => function () {
          return 1 == get_theme_mod('show_header_date', 0);
      },
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'secondary_nav_heading_1',
        'priority' =>	5.3,
        'label'    =>	esc_html__('Custom Phrase', 'mharty'),
          'section'  => 'mh_secondary_nav',
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'header_phrase',
        'label'    => esc_html__('Phrase', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'priority' => 5.3,
        'description' => esc_html__('Use this field to show custom phrase. Keep it short for better results.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'secondary_nav_phrase_icon',
        'label'    => esc_html__('Icon', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'default'  => '',
        'priority' => 5.3,
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'secondary_nav_heading_2',
        'priority' =>	5.3,
        'label'    =>	esc_html__('Phone Number', 'mharty'),
          'section'  => 'mh_secondary_nav',
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'phone_number',
        'label'    => esc_html__('Number', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'priority' => 5.3,
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'secondary_nav_phone_icon',
        'label'    => esc_html__('Icon', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'default'  => '',
        'priority' => 5.3,
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'secondary_nav_heading_3',
        'priority' =>	5.3,
        'label'    =>	esc_html__('Email', 'mharty'),
          'section'  => 'mh_secondary_nav',
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'header_email',
        'label'    => esc_html__('Your email', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'priority' => 5.3,
    );
    $controls[] = array(
        'type'     => 'icon',
        'setting'  => 'secondary_nav_email_icon',
        'label'    => esc_html__('Icon', 'mharty'),
        'section'  => 'mh_secondary_nav',
        'default'  => '',
        'priority' => 5.3,
    );
    //Promo Bar
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'show_promo_bar',
        'label'    => esc_html__('Promo Bar', 'mharty'),
        'section'  => 'mh_promo_bar',
        'default'  => 0,
        'priority' => 7.0,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
        'description' => esc_html__('If you have the Secondary Menu shown on your website this bar will overlay its current content until dismissed. Note: to change the position of the bar please change the Secondary Menu position.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'promo_bar_text',
        'label'    => esc_html__('Promo Bar Text', 'mharty'),
        'section'  => 'mh_promo_bar',
        'priority' => 7.1,
        'description' => esc_html__('Use this field to display a message on the Promo Bar. This field must be filled for the bar to be shown. Keep it short.', 'mharty'),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_promo_bar');
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'promo_bar_button_text',
        'label'    => esc_html__('Promo Bar Button Text', 'mharty'),
        'section'  => 'mh_promo_bar',
        'priority' => 7.2,
        'description' => esc_html__('If you want to show a button, put your link in the field below.', 'mharty'),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_promo_bar');
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'promo_bar_button_url',
        'label'    => esc_html__('Promo Bar Button URL', 'mharty'),
        'section'  => 'mh_promo_bar',
        'priority' => 7.3,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_promo_bar');
        },
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'promo_bar_animation',
        'label'    => esc_html__('Promo Bar Animation', 'mharty'),
        'section'  => 'mh_promo_bar',
        'default'  => 'top',
        'priority' => 7.4,
        'choices'  => array(
            'top' => esc_html__('Top', 'mharty'),
            'bottom' => esc_html__('Bottom', 'mharty'),
            'scaleup' => esc_html__('Scale Up', 'mharty'),
            'bouncein' => esc_html__('Bouncing', 'mharty'),
        ),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_promo_bar');
        },
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'promo_bar_logged_in',
        'label' => esc_html__('Promo Bar for Logged-in Users', 'mharty'),
        'section'  => 'mh_promo_bar',
        'default'  => 1,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
        'priority' => 7.5,
        'description' => esc_html__('Use this option to hide the Promo from logged-in users.', 'mharty'),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_promo_bar');
        },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting'  => 'show_promo_bar_once',
        'label' => esc_html__('Promo Bar Once Per Session', 'mharty'),
        'section'  => 'mh_promo_bar',
        'default'  => false,
        'priority' => 7.6,
        'description' => esc_html__('Enable this option to show the Promo Bar once per browser session.', 'mharty'),
        'active_callback' => function () {
            return 1 == get_theme_mod('show_promo_bar');
        },
    );

    //end Promo Bar
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'icon',
        'setting'  => 'footer_widget_columns',
        'label'    => esc_html__('Widget Columns', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => 'four',
        'priority' => 8.0,
        'choices'  => array(
            'one' => 'footer_widget_columns_one',
            'two' => 'footer_widget_columns_two',
            'three' => 'footer_widget_columns_three',
            'four' => 'footer_widget_columns_four',
        ),
        'description' => esc_html__('This option will not work with narrow Website Width.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'footer_style',
        'label'    => esc_html__('Footer Style', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => 'right',
        'priority' => 8.0,
        'choices'  => array(
            'right' => esc_html__('Side', 'mharty'),
            'centered' => esc_html__('Centre', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'show_footer_social_icons',
        'label'    => esc_html__('Social Icons in Footer', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => 0,
        'priority' => 8.0,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
        'description' => esc_html__('You may need to activate the desired icons from Social Icons section.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'footer_heading_1',
        'priority' =>	8.1,
        'label'    =>	esc_html__('Copyright', 'mharty'),
        'section'  => 'mh_footer',
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'cr_notice',
        'label'    => esc_html__('Website Copyrights', 'mharty'),
        'section'  => 'mh_footer',
        'priority' => 8.1,
        'description' => esc_html__('Add Your Copyright notice to the footer.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'switch',
        'mode'     => 'buttonset',
        'setting'  => 'mharty_show_cr',
        'label'    => esc_html__('Powered by', 'mharty'),
        'section'  => 'mh_footer',
        'default'  =>	true,
        'priority' => 8.1,
        'description' => esc_html__('(Optional) Support Mharty by displaying our notice in the footer. Thank you.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'footer_heading_2',
        'priority' =>	8.2,
        'label'    =>	esc_html__('Footer Background', 'mharty'),
        'section'  => 'mh_footer',
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'footer_bg_img',
        'label'    => esc_html__('Footer Background', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => '',
        'priority' => 8.2,
        'description' => esc_html__('Upload or choose a background image for the footer area.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'footer_bg_position_x',
        'label'    => esc_html__('Align Footer Background', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => 'center',
        'priority' => 8.2,
        'choices'  => array(
            'center' => esc_html__('Centre', 'mharty'),
            'right' => esc_html__('Right', 'mharty'),
            'left' => esc_html__('Left', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'footer_bg_position_y',
        'label'    => esc_html__('Align Footer Background', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => 'center',
        'priority' => 8.2,
        'choices'  => array(
            'center' => esc_html__('Centre', 'mharty'),
            'top' => esc_html__('Top', 'mharty'),
            'bottom' => esc_html__('Bottom', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'footer_bg_size',
        'label'    => esc_html__('Background Size', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => 'auto',
        'priority' => 8.2,
        'choices'  => array(
            'auto' => esc_html__('Auto', 'mharty'),
            'cover' => esc_html__('Cover', 'mharty'),
            'contain' => esc_html__('Contain', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'footer_bg_repeat',
        'label'    => esc_html__('Repeat Background', 'mharty'),
        'section'  => 'mh_footer',
        'default'  => 'no-repeat',
        'priority' => 8.2,
        'choices'  => array(
            'no-repeat' => esc_html__('No Repeat', 'mharty'),
            'repeat-x' => esc_html__('Repeat X', 'mharty'),
            'repeat-y' => esc_html__('Repeat Y', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'accent_color',
        'label'    => esc_html__('Accent Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => '#4FD4FF',
        'priority' => 1,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'site_title_color',
        'label'    => esc_html__('Site Title Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 1,
      'active_callback' => function () {
          return false != get_theme_mod('use_logo_text', false);
      },
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'site_tagline_color',
        'label'    => esc_html__('Site Tagline Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => get_theme_mod('menu_link', '#666666'),
        'priority' => 1,
      'active_callback' => function () {
          return false != get_theme_mod('use_logo_text', false);
      },
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'font_color',
        'label'    => esc_html__('Main Font Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => '#666666',
        'priority' => 1.1,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'heading_color',
        'label'    => esc_html__('Heading Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => '#444444',
        'priority' => 1.2,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'link_color',
        'label'    => esc_html__('Link Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 1.3,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'sidebar_heading_color',
        'label'    => esc_html__('Sidebar Heading Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 1.8,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'sidebar_heading_alt_color',
        'label'    => esc_html__('Sidebar Heading Background Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => '#444444',
        'priority' => 1.9,
        'description' => esc_html__('This colour works with some of the Widget Header Styles. You could choose a style in "Site Settings".', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'sidebar_link_color',
        'label'    => esc_html__('Sidebar Link Colour', 'mharty'),
        'section'  => 'colors',
        'default'  => '#666666',
        'priority' => 2,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'mharty_quick_contact_button_bg',
        'label'    => esc_html__('Quick Contact Button Background', 'mharty'),
        'section'  => 'mh_quick_colors',
        'default'  =>  '#666666',
        'priority' => 2,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'mharty_quick_contact_button_color',
        'label'    => esc_html__('Quick Contact Button Colour', 'mharty'),
        'section'  => 'mh_quick_colors',
        'default'  => 'dark',
        'priority' => 2,
        'choices'  => array(
            'dark' => esc_html__('Light', 'mharty'),
            'light' => esc_html__('Dark', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'mharty_quick_contact_bg',
        'label'    => esc_html__('Quick Contact Background', 'mharty'),
        'section'  => 'mh_quick_colors',
        'default'  => '#ffffff',
        'priority' => 2,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'mharty_quick_contact_color',
        'label'    => esc_html__('Quick Contact Text Colour', 'mharty'),
        'section'  => 'mh_quick_colors',
        'default'  => 'light',
        'priority' => 2,
        'choices'  => array(
            'dark' => esc_html__('Light', 'mharty'),
            'light' => esc_html__('Dark', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'primary_nav_bg',
        'label'    => esc_html__('Primary Navigation Background', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '#ffffff',
        'priority' => 2.1,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'primary_nav_bg_gradient',
        'label'    => esc_html__('Primary Navigation Gradient', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '',
        'priority' => 2.2,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'primary_nav_bg_gradient_dir',
        'label'    => esc_html__('Gradient Direction', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => 'left',
        'priority' => 2.3,
        'choices'  => array(
            'left' => esc_html__('Horizontal', 'mharty'),
            'top' => esc_html__('Vertical', 'mharty'),
        ),
        'active_callback' => function () {
            return '' != get_theme_mod('primary_nav_bg_gradient', '');
        },
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'primary_nav_text_color',
        'label'    => esc_html__('Primary Navigation Text Colour', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => 'dark',
        'priority' => 2.4,
        'choices'  => array(
            'dark' => esc_html__('Dark', 'mharty'),
            'light' => esc_html__('Light', 'mharty'),
        ),
        'description' => esc_html__('If you choose light option it will override "Menu Links Colour" option below.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_link',
        'label'    => esc_html__('Menu Links Colour', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '#666666',
        'priority' => 2.5,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_icons',
        'label'    => esc_html__('Menu Icons Colour', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => 'rgba(0, 0, 0, 0.4)',
        'priority' => 2.6,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_link_bg',
        'label'    => esc_html__('Menu Link Background', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '',
        'priority' => 2.7,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_link_active',
        'label'    => esc_html__('Active Menu Link Colour', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 2.8,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_link_active_bg',
        'label'    => esc_html__('Active Menu Link Background', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '',
        'priority' => 2.9,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'enable_menu_link_sep_color',
        'label'    => esc_html__('Menu Link Separator', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => 0,
        'priority' => 3,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_link_sep_color',
        'label'    => esc_html__('Menu Link Separator Colour', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '#e2e2e2',
        'priority' => 3.1,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'primary_subnav_bg',
        'label'    => esc_html__('Sub Navigation Background', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '',
        'priority' => 3.2,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'primary_subnav_text_color',
        'label'    => esc_html__('Sub Navigation Text Colour', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => 'dark',
        'priority' => 3.3,
        'choices'  => array(
            'dark' => esc_html__('Dark', 'mharty'),
            'light' => esc_html__('Light', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_highlight_bg',
        'label'    => esc_html__('CTA/Highlight Background', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 3.3,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'menu_highlight_color',
        'label'    => esc_html__('CTA/Highlight Text Colour', 'mharty'),
        'section'  => 'mh_primary_colors',
        'default'  => '#ffffff',
        'priority' => 3.3,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'secondary_nav_bg',
        'label'    => esc_html__('Secondary Navigation Background', 'mharty'),
        'section'  => 'mh_secondary_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 4.1,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'secondary_nav_border_active',
        'label'    => esc_html__('Secondary Navigation Separator', 'mharty'),
        'section'  => 'mh_secondary_colors',
        'default'  => 0,
        'priority' => 4.2,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
        'description' => esc_html__('Enable this option to display a separator line for the secondary navigation. Use the option below to choose your desired colour.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'secondary_nav_border',
        'label'    => esc_html__('Secondary Navigation Separator Colour', 'mharty'),
        'section'  => 'mh_secondary_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 4.3,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'secondary_nav_text_color',
        'label'    => esc_html__('Secondary Navigation Text Colour', 'mharty'),
        'section'  => 'mh_secondary_colors',
        'default'  => 'light',
        'priority' => 4.4,
        'choices'  => array(
            'light' => esc_html__('Light', 'mharty'),
            'dark' => esc_html__('Dark', 'mharty'),
            'custom' => esc_html__('Custom', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'secondary_nav_text_color_custom',
        'label'    => esc_html__('Secondary Navigation Custom Text Colour', 'mharty'),
        'section'  => 'mh_secondary_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 4.5,
        'description' => esc_html__('This option works if you choose "Custom" in the option above.', 'mharty'),
        'active_callback' => function () {
            return 'custom' == get_theme_mod('secondary_nav_text_color');
        },
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'app_menu_bg',
        'label'    => esc_html__('Mobile Menu Background', 'mharty'),
        'section'  => 'mh_app_colors',
        'default'  => '#f4f4f4',
        'priority' => 5.1,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'app_menu_text_color',
        'label'    => esc_html__('Mobile Menu Text Colour', 'mharty'),
        'section'  => 'mh_app_colors',
        'default'  => 'dark',
        'priority' => 5.1,
        'choices'  => array(
            'dark' => esc_html__('Dark', 'mharty'),
            'light' => esc_html__('Light', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'promo_bar_bg',
        'label'    => esc_html__('Promo Bar Background Colour', 'mharty'),
        'section'  => 'mh_promo_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 6.1,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'promo_bar_text_color',
        'label'    => esc_html__('Promo Bar Text Colour', 'mharty'),
        'section'  => 'mh_promo_colors',
        'default'  => '#ffffff',
        'priority' => 6.2,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'promo_bar_button_bg',
        'label'    => esc_html__('Promo Bar Button Colour', 'mharty'),
        'section'  => 'mh_promo_colors',
        'default'  => '#ffffff',
        'priority' => 6.3,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'promo_bar_button_text_color',
        'label'    => esc_html__('Promo Bar Button Text Colour', 'mharty'),
        'section'  => 'mh_promo_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 6.4,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_widgets_bg',
        'label'    => esc_html__('Footer Background Colour (Widgets)', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => '#383838',
        'priority' => 7.1,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_widget_heading_color',
        'label'    => esc_html__('Widgets Heading Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => get_theme_mod('accent_color', '#4FD4FF'),
        'priority' => 7.2,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_widget_heading_alt_color',
        'label'    => esc_html__('Widgets Heading Background Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => '#ffffff',
        'priority' => 7.3,
        'description' => esc_html__('This colour works with some of the Widget Header Styles. You could choose a style in "Site Settings".', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_widgets_color',
        'label'    => esc_html__('Widgets Text Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => '#ffffff',
        'priority' => 7.4,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_widgets_color_link',
        'label'    => esc_html__('Widgets Link Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => '#ffffff',
        'priority' => 7.5,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_bg',
        'label'    => esc_html__('Footer Background Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => '#1b1b1b',
        'priority' => 7.6,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_color',
        'label'    => esc_html__('Footer Text Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => '#5c5a5a',
        'priority' => 7.7,
    );
    $controls[] = array(
        'type'     => 'color',
        'setting'  => 'footer_color_link',
        'label'    => esc_html__('Footer Link Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => '#747474',
        'priority' => 7.8,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'footer_social_icons_color',
        'label'    => esc_html__('Footer Social Icons Colour', 'mharty'),
        'section'  => 'mh_footer_colors',
        'default'  => 'dark',
        'priority' => 7.9,
        'choices'  => array(
            'dark' => esc_html__('Dark', 'mharty'),
            'light' => esc_html__('Light', 'mharty'),
            'color' => esc_html__('Colours', 'mharty'),
        ),
    );
    $controls[] = array(
    'type' => 'color',
        'setting' => 'background_color',
        'label' => esc_html__('Background Colour', 'mharty'),
        'section' => 'background_image',
        'priority' => 2.1,
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'cover_background',
        'label' => esc_html__('Stretch Background Image', 'mharty'),
        'section' => 'background_image',
        'priority' => 22,
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'fix_transparent_bg',
        'label' => esc_html__('Fix Transparent', 'mharty'),
        'section' => 'background_image',
        'default'  => false,
        'priority' => 23,
        'description' => esc_html__('(Optional) This is a fix for trnasparent background when custom background images is used.', 'mharty'),
    );
    //Mobile Settings
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_column_heading',
       'priority' => 9,
        'label'    =>	esc_html__('2 Columns on Mobile', 'mharty'),
        'section'  => 'mh_mobile_styles_general',
    );
    $controls[] = array(
      'type'     =>	'switch',
      'setting'  =>	'ss_blog_grid_2_pr_row',
      'priority' =>	9,
      'label'    =>	esc_html__('Posts Grid', 'mharty'),
      'default'  =>	false,
      'section'  =>	'mh_mobile_styles_general',
      'description' => esc_html__('To learn about experimental features go to Mharty > Theme Panel > Misc.', 'mharty'),
    );
    $controls[] = array(
      'type'     =>	'switch',
      'setting'  =>	'ss_projects_grid_2_pr_row',
      'priority' =>	9,
      'label'    =>	esc_html__('Projects Grid', 'mharty'),
      'default'  =>	false,
      'section'  =>	'mh_mobile_styles_general',
      'description' => esc_html__('To learn about experimental features go to Mharty > Theme Panel > Misc.', 'mharty'),
    );
    $controls[] = array(
      'type'     =>	'switch',
      'setting'  =>	'ss_gallery_grid_2_pr_row',
      'priority' =>	9,
      'label'    =>	esc_html__('Gallery Grid', 'mharty'),
      'default'  =>	false,
      'section'  =>	'mh_mobile_styles_general',
      'description' => esc_html__('To learn about experimental features go to Mharty > Theme Panel > Misc.', 'mharty'),
    );
    $controls[] = array(
      'type'     =>	'switch',
      'setting'  =>	'ss_widgets_grid_2_pr_row',
      'priority' =>	9,
      'label'    =>	esc_html__('Widgets', 'mharty'),
      'default'  =>	false,
      'section'  =>	'mh_mobile_styles_general',
      'description' => esc_html__('To learn about experimental features go to Mharty > Theme Panel > Misc.', 'mharty'),
    );
    //Mobile Main Menu
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_main_nav_heading',
       'priority' => 9,
        'label'    =>	esc_html__('Primary Navigation', 'mharty'),
        'section'  => 'mh_mobile_styles_general',
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'mobile_header_style',
        'label'    => esc_html__('Mobile Main Menu Style', 'mharty'),
        'section'  => 'mh_mobile_styles_general',
        'default'  => 'right',
        'priority' => 9,
        'choices'  => array(
            'right' => esc_html__('Side', 'mharty'),
            'middle' => esc_html__('Centred', 'mharty'),
        ),
      'description' => esc_html__('Centred style works best when there are 2 items apart from the logo.', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'mobile_xl_logo',
        'label'    => esc_html__('Logo Size on Mobile', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'priority' => 9,
        'description' => esc_html__('Set a custom size on mobile devices (Numeric value only).', 'mharty'),
    );
    $controls[] = array(
      'type'     => 'range',
        'setting' => 'mobile_menu_padding',
        'label' => esc_html__('Padding Between Menu Items', 'mharty'),
        'section' => 'mh_mobile_styles_general',
      'default'  => '8',
        'input_attrs' => array(
                'min'  => 8,
                'max'  => 30,
                'step' => 1
            ),
        'priority' => 9,
        'description' => esc_html__('Adjust the gaps between main menu items on mobile.', 'mharty'),
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'alwyas_show_app_menu',
        'label' => esc_html__('Show Mobile Menu Icon on Desktop', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'app_icon_sticky',
        'label' => esc_html__('Sticky Mobile Menu Icon', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
        'description' => esc_html__('If you want the Mobile Menu Icon to show always, even while scrolling.', 'mharty'),
      'active_callback' => function () {
          return 'top' != get_theme_mod('fixed_menu', 'off');
      },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'alwyas_show_search_icon',
        'label' => esc_html__('Show Search Icon', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
        'active_callback' => function () {
            return 'hide' != get_theme_mod('show_search_icon');
        },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting'  => 'always_show_top_cta',
        'label'    => esc_html__('Show CTA 1', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
      'active_callback' => function () {
          return false != get_theme_mod('show_top_cta');
      },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting'  => 'always_show_top_cta_2',
        'label'    => esc_html__('Show CTA 2', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
      'active_callback' => function () {
          return false != get_theme_mod('show_top_cta_2');
      },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting'  => 'always_show_extra_logo',
        'label'    => esc_html__('Show Extra Logo', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
      'active_callback' => function () {
          return false != get_theme_mod('mharty_extra_logo');
      },
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_secondary_nav_heading',
       'priority' => 9,
        'label'    =>	esc_html__('Secondary Navigation', 'mharty'),
        'section'  => 'mh_mobile_styles_general',
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'show_secondary_nav',
        'label'    => esc_html__('Secondary Navigation', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => 1,
        'priority' => 9,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'secondary_nav_style',
        'label'    => esc_html__('Secondary Navigation Style', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => 'none',
        'priority' => 9,
        'choices'  => array(
            'none' => esc_html__('Default', 'mharty'),
            'stacked' => esc_html__('Stacked', 'mharty'),
            'centred' => esc_html__('Centred', 'mharty'),
        ),
      'active_callback' => function () {
          return 1 == get_theme_mod('show_secondary_nav', 1);
      },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'always_show_nav_social',
        'label' => esc_html__('Show Social Icons', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_secondary_nav', 1);
        },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting' => 'always_show_nav_menu',
        'label' => esc_html__('Show Navigation Menu', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
        'active_callback' => function () {
            return 1 == get_theme_mod('show_secondary_nav', 1);
        },
    );

    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_misc_heading',
       'priority' => 9,
        'label'    =>	esc_html__('Misc.', 'mharty'),
        'section'  => 'mh_mobile_styles_general',
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'always_show_quick_contact',
        'priority' =>	9,
        'label'    =>	esc_html__('Show Quick Contact Form', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_mobile_styles_general',
        'active_callback' => function () {
            return false != get_theme_mod('mharty_show_quick_contact');
        },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'always_show_quick_social',
        'priority' =>	9,
        'label'    =>	esc_html__('Show Quick Social Icon', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_mobile_styles_general',
        'active_callback' => function () {
            return false != get_theme_mod('mharty_show_quick_social');
        },
    );
    $controls[] = array(
        'type' => 'switch',
        'setting'  => 'always_show_back_to_top',
        'label'    => esc_html__('Show Back To Top Button', 'mharty'),
        'section' => 'mh_mobile_styles_general',
        'default'  => false,
        'priority' => 9,
      'active_callback' => function () {
          return 0 != get_theme_mod('back_to_top');
      },
    );
    $controls[] = array(
        'type'     =>	'switch',
        'setting'  =>	'mharty_mobile_animation',
        'priority' =>	9,
        'label'    =>	esc_html__('Enable Animations on Mobile', 'mharty'),
        'default'  =>	true,
        'section'  =>	'mh_mobile_styles_general',
        'description' => esc_html__('You can disable components animation on mobile.', 'mharty'),
    );
    //Mobile Menu
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'app_nav_heading_1',
        'priority' =>	6,
        'label'    =>	esc_html__('Mobile Menu Style & Content', 'mharty'),
          'section' => 'mh_app_nav',
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting' => 'app_style',
        'label' => esc_html__('Style', 'mharty'),
        'section' => 'mh_app_nav',
        'default'  => 'side',
        'priority' => 6.2,
        'choices'  => array(
            'side'  => esc_html__('Side 1', 'mharty'),
            'side2' => esc_html__('Side 2', 'mharty'),
            'side3' => esc_html__('Side 3', 'mharty'),
            'side4' => esc_html__('Side 4', 'mharty'),
            'overlay' => esc_html__('Overlay', 'mharty'),
            'sub' => esc_html__('Sub', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'image',
        'setting'  => 'app_logo',
        'label'    => esc_html__('Mobile Menu Logo', 'mharty'),
        'section'  => 'mh_app_nav',
        'default'  => '',
        'priority' => 6.3,
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'app_logo_size',
        'label'    => esc_html__('Logo Size', 'mharty'),
        'section'  => 'mh_app_nav',
        'priority' => 6.3,
        'description' => esc_html__('By default the logo in mobile menu is full-width. You can define a custom width here (numeric value only).', 'mharty'),
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting' => 'app_tagline',
        'label' => esc_html__('Tagline', 'mharty'),
        'section' => 'mh_app_nav',
        'default'  => 'show',
        'priority' => 6.4,
        'choices'  => array(
            'show' => esc_html__('Show', 'mharty'),
            'hide' => esc_html__('Hide', 'mharty'),
        ),
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'app_tagline_alt',
        'label'    => esc_html__('Custom Tagline', 'mharty'),
        'section'  => 'mh_app_nav',
        'priority' => 6.5,
        'description' => esc_html__('Use this field, if you want to show a custom tagline.', 'mharty'),
        'active_callback' => function () {
            return 'show' == get_theme_mod('app_tagline', 'show');
        },
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'app_phone_number',
        'label'    => esc_html__('Phone Number', 'mharty'),
        'section'  => 'mh_app_nav',
        'priority' => 6.6,
    );
    $controls[] = array(
        'type'     => 'text',
        'setting'  => 'app_email',
        'label'    => esc_html__('Email', 'mharty'),
        'section'  => 'mh_app_nav',
        'priority' => 6.7,
    );
    $controls[] = array(
        'type'     => 'radio',
        'mode'     => 'buttonset',
        'setting'  => 'show_app_social_icons',
        'label'    => esc_html__('Social Icons', 'mharty'),
        'section'  => 'mh_app_nav',
        'default'  => 0,
        'priority' => 6.8,
        'choices'  => array(
            0 => esc_html__('Hide', 'mharty'),
            1 => esc_html__('Show', 'mharty'),
        ),
    );
    //end Mobile Menu
    //Mobile Fonts
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_site_title_heading',
        'priority' =>	1,
        'label'    =>	esc_html__('Site Title', 'mharty'),
        'section'  => 'mh_mobile_styles_fonts',
        'active_callback' => function () {
            return false != get_theme_mod('use_logo_text', false);
        },
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'ss_site_title_size',
        'label'    => esc_html__('Size', 'mharty'),
     'section'  => 'mh_mobile_styles_fonts',
        'default'  => '26',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 72,
                'step' => 1
            ),
        'priority' => 1,
        'active_callback' => function () {
            return false != get_theme_mod('use_logo_text', false);
        },
    );

    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_header_font_heading',
        'priority' =>	1,
        'label'    =>	esc_html__('Header Font', 'mharty'),
        'section'  => 'mh_mobile_styles_fonts',
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'ss_h1_font_size',
        'label'    => esc_html__('Header Font Size', 'mharty'),
        'section' => 'mh_mobile_styles_fonts',
        'default'  => '26',
        'input_attrs' => array(
                'min'  => 22,
                'max'  => 86,
                'step' => 1
            ),
        'priority' => 1,
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'ss_h1_font_height',
        'label'    => esc_html__('Header Line Height', 'mharty'),
        'section' => 'mh_mobile_styles_fonts',
        'default'  => '1.4',
        'input_attrs' => array(
                'min'  => 0.8,
                'max'  => 3,
                'step' => 0.1
            ),
        'priority' => 1,
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_body_font_heading',
        'priority' => 1,
        'label'    =>	esc_html__('Body Font', 'mharty'),
        'section'  => 'mh_mobile_styles_fonts',
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'ss_body_font_size',
        'label'    => esc_html__('Body Font Size', 'mharty'),
        'section' => 'mh_mobile_styles_fonts',
        'default'  => '14',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 36,
                'step' => 1
            ),
        'priority' => 1,
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'ss_body_font_height',
        'label'    => esc_html__('Body Line Height', 'mharty'),
        'section' => 'mh_mobile_styles_fonts',
        'default'  => '1.7',
        'input_attrs' => array(
                'min'  => 0.8,
                'max'  => 3,
                'step' => 0.1
            ),
        'priority' => 1,
    );
    $controls[] = array(
    'type' => 'switch',
        'setting' => 'ss_body_font_include',
        'label' => esc_html__('Include Other Texts', 'mharty'),
        'section' => 'mh_mobile_styles_fonts',
        'default'  => false,
        'priority' => 1,
        'description' => esc_html__('Enable this option if you want to adjust other text according to body font size on mobile devices.', 'mharty'),
    );
    $controls[] = array(
        'type'     =>	'mh-heading',
        'setting'  =>	'ss_menu_font_heading',
       'priority' => 1,
        'label'    =>	esc_html__('Menu Font Options', 'mharty'),
        'section'  => 'mh_mobile_styles_fonts',
    );
    $controls[] = array(
        'type'     => 'range',
        'setting'  => 'ss_app_nav_font_size',
        'label'    => esc_html__('Mobile Menu Font Size', 'mharty'),
        'section' => 'mh_mobile_styles_fonts',
        'default'  => '14',
        'input_attrs' => array(
                'min'  => 10,
                'max'  => 48,
                'step' => 1
        ),
        'priority' => 1,
    );
    //end Mobile

    $controls[] = array(
        'type'     =>	'code_editor',
        'setting'  =>	'customizer_custom_css',
        'priority' =>	1.0,
        'label'    =>	esc_html__('Custom CSS', 'mharty'),
        'default'  =>	'',
        'section'  =>	'mh_css',
        'description' => esc_html__('Here you can add custom css to override or extend default styles.', 'mharty'),
        'code_type'   => 'text/css',
        'input_attrs' => array(
            'aria-describedby' => 'editor-keyboard-trap-help-1 editor-keyboard-trap-help-2 editor-keyboard-trap-help-3 editor-keyboard-trap-help-4',
        ),

        //validation:nohtml
    );
    return $controls;
}
add_filter('mh_customizer/controls', 'mh_mharty_customize_setting');
