<?php
class MHCustomizer_Color_Control extends WP_Customize_Control {
  public $type = 'color';
  public $statuses;
  public $description = '';
  public $subtitle = '';
  public $framework_var = '';

  public function __construct( $manager, $id, $args = array() ) {
    $this->statuses = array( '' => esc_html__( 'Default', 'mharty' ) );
    parent::__construct( $manager, $id, $args );
    $this->framework_var = ( isset( $args[ 'framework_var' ] ) && !is_null( $args[ 'framework_var' ] ) ) ? $args[ 'framework_var' ] : null;
  }

  public function enqueue() {
    $picker_l10n_strings = array(
      'defaultString' => esc_html__( 'Default', 'mharty' ),
      'clear' => esc_html__( 'Clear', 'mharty' ),
      'pick' => esc_html__( 'Select Colour', 'mharty' ),
    );
    wp_enqueue_script( 'wp-color-picker' );
    wp_enqueue_style( 'wp-color-picker' );
    wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $picker_l10n_strings );

  }

  public function to_json() {
    parent::to_json();
    $this->json[ 'statuses' ] = $this->statuses;
  }

  public function render_content() {
    $this_default = $this->setting->
      default;
    $default_attr = '';
    $this_id = $this->id;

    if ( $this_default ) {
      if ( false === strpos( $this_default, '#' ) )
        $this_default = '#' . $this_default;
      $default_attr = ' data-default-color="' . esc_attr( $this_default ) . '"';
    }

    $setting_attr = ' data-customize-setting-link="' . esc_attr( $this_id ) . '"';
    $framework_var = ' data-framework-var="' . $this->framework_var . '"';

    // The input's value gets set by JS. Don't fill it.
    ?>
<label>
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<div class="customize-control-content">
  <input class="color-picker-hex mh_customizer-color-picker" type="text" maxlength="7" placeholder="<?php esc_attr_e( 'Hex Value', 'mharty' ); ?>"<?php echo $default_attr; ?> <?php echo $setting_attr; ?> <?php echo $framework_var; ?>/>
</div>
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php

}
}
class MHCustomizer_Customize_Checkbox_Control extends WP_Customize_Control {
  public $type = 'checkbox';
  public $description = '';
  public $subtitle = '';

  public function render_content() {
    ?>
<label class="customizer-checkbox">
<input type="checkbox" value="<?php echo esc_attr( $this->value() ); ?>" id="<?php echo $this->id . esc_attr( $this->value() ); ?>" <?php $this->link(); checked( $this->value() ); ?> />
<strong><?php echo esc_html( $this->label ); ?></strong>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php
}
}
class MHCustomizer_Customize_Image_Control extends WP_Customize_Upload_Control {
  public $type = 'image';
  public $get_url;
  public $statuses;
  public $extensions = array( 'jpg', 'jpeg', 'gif', 'png' );
  public $description = '';
  public $subtitle = '';

  protected $tabs = array();

  public function __construct( $manager, $id, $args ) {
    $this->statuses = array( '' => esc_html__( 'No Image', 'mharty' ) );

    parent::__construct( $manager, $id, $args );

    $this->add_tab( 'upload-new', esc_html__( 'Upload New', 'mharty' ), array( $this, 'tab_upload_new' ) );
    $this->add_tab( 'uploaded', esc_html__( 'Uploaded', 'mharty' ), array( $this, 'tab_uploaded' ) );

    // Early priority to occur before $this->manager->prepare_controls();
    add_action( 'customize_controls_init', array( $this, 'prepare_control' ), 5 );
  }

  public function prepare_control() {
    if ( !$this->tabs )
      $this->manager->remove_control( $this->id );
  }

  public function to_json() {
    parent::to_json();
    $this->json[ 'statuses' ] = $this->statuses;
  }

  public function render_content() {
    $src = $this->value();
    if ( isset( $this->get_url ) )
      $src = call_user_func( $this->get_url, $src );

    ?>
<div class="customize-image-picker"> <span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
  <?php if ( '' != $this->subtitle ) : ?>
  <div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
  <?php endif; ?>
  <div class="customize-control-content">
    <div class="dropdown preview-thumbnail" tabindex="0">
      <div class="dropdown-content">
        <?php if ( empty( $src ) ): ?>
        <img style="display:none;" />
        <?php else: ?>
        <img src="<?php echo esc_url( set_url_scheme( $src ) ); ?>" />
        <?php endif; ?>
        <div class="dropdown-status"></div>
      </div>
      <div class="dropdown-arrow"></div>
    </div>
  </div>
  <div class="library">
    <ul>
      <?php foreach ( $this->tabs as $id => $tab ): ?>
      <li data-customize-tab='<?php echo esc_attr( $id ); ?>' tabindex='0'> <?php echo esc_html( $tab['label'] ); ?> </li>
      <?php endforeach; ?>
    </ul>
    <?php foreach ( $this->tabs as $id => $tab ): ?>
    <div class="library-content" data-customize-tab='<?php echo esc_attr( $id ); ?>'>
      <?php call_user_func( $tab['callback'] ); ?>
    </div>
    <?php endforeach; ?>
  </div>
  <div class="actions"> <a href="#" class="remove">
    <?php esc_html_e( 'Remove Image', 'mharty' ); ?>
    </a> </div>
</div>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php
}

public function add_tab( $id, $label, $callback ) {
  $this->tabs[ $id ] = array(
    'label' => $label,
    'callback' => $callback,
  );
}

public function remove_tab( $id ) {
  unset( $this->tabs[ $id ] );
}

public function tab_upload_new() {
  if ( !_device_can_upload() ) {
    echo '<p>' . mh_wp_kses( sprintf( __( 'The web browser on your device cannot be used to upload files. You may be able to use the <a href="%s">native app for your device</a> instead.', 'mharty' ), 'https://wordpress.org/mobile/' ) ) . '</p>';
  } else {
    ?>
<div class="upload-dropzone">
  <?php mh_wp_kses( __('Drop a file here or <a href="#" class="upload">select a file</a>.', 'mharty') ); ?>
</div>
<div class="upload-fallback"> <span class="button-secondary">
  <?php esc_html_e( 'Select File', 'mharty' ); ?>
  </span> </div>
<?php
}
}

public function tab_uploaded() {
  ?>
<div class="uploaded-target"></div>
<?php
}

public function print_tab_image( $url, $thumbnail_url = null ) {
  $url = set_url_scheme( $url );
  $thumbnail_url = ( $thumbnail_url ) ? set_url_scheme( $thumbnail_url ) : $url;
  ?>
<a href="#" class="thumbnail" data-customize-image-value="<?php echo esc_url( $url ); ?>"> <img src="<?php echo esc_url( $thumbnail_url ); ?>" /> </a>
<?php
}
}
class MHCustomizer_Customize_Radio_Control extends WP_Customize_Control {
  public $type = 'radio';
  public $description = '';
  public $mode = 'radio';
  public $subtitle = '';

  public function enqueue() {

    if ( 'buttonset' == $this->mode || 'image' == $this->mode || 'icon' == $this->mode ) {
      wp_enqueue_script( 'jquery-ui-button' );
    }

  }

  public function render_content() {

    if ( empty( $this->choices ) ) {
      return;
    }

    $name = '_customize-radio-' . $this->id;

    ?>
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<div id="input_<?php echo $this->id; ?>" class="<?php echo $this->mode; ?>">
  <?php

  // JqueryUI Button Sets
  if ( 'buttonset' == $this->mode ) {

    foreach ( $this->choices as $value => $label ): ?>
  <input type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" id="<?php echo $this->id . $value; ?>" <?php $this->link(); checked( $this->value(), $value ); ?>>
  <label for="<?php echo $this->id . $value; ?>"> <span class="mh-buttonset-text"><?php echo esc_html( $label ); ?></span> </label>
  </input>
  <?php
  endforeach;

  // Image radios.
  } elseif ( 'image' == $this->mode ) {

      foreach ( $this->choices as $value => $label ): ?>
  <input class="image-select" type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" id="<?php echo $this->id . $value; ?>" <?php $this->link(); checked( $this->value(), $value ); ?>>
  <label for="<?php echo $this->id . $value; ?>"> <img src="<?php echo esc_html( $label ); ?>"> </label>
  </input>
  <?php
  endforeach;

  // Icons radios.
  } elseif ( 'icon' == $this->mode ) {

      foreach ( $this->choices as $value => $label ): ?>
  <input class="icon-select" type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" id="<?php echo $this->id . $value; ?>" <?php $this->link(); checked( $this->value(), $value ); ?>>
  <label for="<?php echo $this->id . $value; ?>"> <a class="mh-buttonset-icon <?php echo esc_html( $label ); ?>"></a> </label>
  </input>
  <?php
  endforeach;

  // Normal radios
  } else {

    foreach ( $this->choices as $value => $label ):
      ?>
  <label class="customizer-radio">
    <input class="mh_customizer-radio" type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php $this->link(); checked( $this->value(), $value ); ?> />
    <span class="mh-buttonset-text"><?php echo esc_html( $label ); ?></span><br/>
  </label>
  <?php
  endforeach;

  }
  ?>
</div>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php if ( 'buttonset' == $this->mode || 'image' == $this->mode || 'icon' == $this->mode ) { ?>
<script>
			jQuery(document).ready(function($) {
				$( '[id="input_<?php echo $this->id; ?>"]' ).buttonset();
			});
			</script>
<?php
}

}
}
class MHCustomizer_Select_Control extends WP_Customize_Control {
  public $type = 'select';
  public $description = '';
  public $subtitle = '';

  public function render_content() {

    if ( empty( $this->choices ) ) {
      return;
    }
    ?>
<label>
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<select <?php $this->link(); ?>>
  <?php
  foreach ( $this->choices as $value => $label ) {
    if ( $value == 'Arabic' || $value == 'Latin' || $value == 'Stack' ) {
      echo '<optgroup label="' . esc_attr( $value ) . '">';
    } elseif ( $value == 'End Arabic' || $value == 'End Latin' || $value == 'End Stack' ) {
      echo '</optgroup>';
    } else {
      echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . $label . '</option>';
    }
  }
  ?>
</select>
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php

}
}
class MHCustomizer_Font_Control extends WP_Customize_Control {
  public $type = 'font';
  public $description = '';
  public $subtitle = '';

  public function render_content() {

    if ( empty( $this->choices ) ) {
      return;
    }
    ?>
<label>
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<select <?php $this->link(); ?>>
  <?php
  foreach ( $this->choices as $value => $label ) {
    switch ( $value ) {
      case 'Stack':
      case 'Arabic':
      case 'Sans-serif':
      case 'Serif-slab':
      case 'Serif':
      case 'Monospace':
      case 'Display':
      case 'Cursive':
      case 'Deprecated':
        echo '<optgroup label="' . esc_attr( $value ) . '">';
      break;
      case 'End Stack':
      case 'End Arabic':
      case 'End Sans-serif':
      case 'End Serif-slab':
      case 'End Serif':
      case 'End Monospace':
      case 'End Display':
      case 'End Cursive':
      case 'End Deprecated':
        echo '</optgroup>';
      break;
      default:
        echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . $label . '</option>';
      break;
    }
  }
  ?>
</select>
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php

}
}
class MHCustomizer_Customize_Text_Control extends WP_Customize_Control {
  public $type = 'text';
  public $description = '';
  public $subtitle = '';

  public function render_content() {
    ?>
<label class="customizer-text">
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<input type="text" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> />
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php

}
}
class MHCustomizer_Customize_Icon_Control extends WP_Customize_Control {
  public $type = 'icon';
  public $description = '';
  public $subtitle = '';

  public function render_content() {
    $menu_icon_value = '' !== $this->value() ? '<span class="mh-menu-icon-show"><em>&#x' . $this->value() . ';</em></span>': '<span class="mh-menu-icon-show mh-menu-icon-button" title="' . esc_html__( "Choose Icon", "mharty" ) . '"></span>';

    ?>
<?php echo esc_attr( $this->setting->default ); ?>
<label class="customizer-text">
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<?php echo $menu_icon_value; ?> <span class="mh-menu-icon-button-reset" title="<?php esc_html_e("Reset", "mharty"); ?>"></span>
<input type="text" class="mh-menu-icon-field" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> />
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php

}
}
class MHCustomizer_Customize_Textarea_Control extends WP_Customize_Control {
  public $type = 'textarea';
  public $description = '';
  public $subtitle = '';

  public function render_content() {
    ?>
<label class="customizer-textarea">
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<textarea class="of-input" rows="5" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php

}
}
class MHCustomizer_Customize_Range_Control extends WP_Customize_Control {
  public $type = 'range';
  public $description = '';
  public $subtitle = '';

  public function render_content() {
    ?>
<label class="customizer-range">
<span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<input type="<?php echo esc_attr( $this->type ); ?>" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> data-reset_value="<?php echo esc_attr( $this->setting->default ); ?>" />
<input type="number" <?php $this->input_attrs(); ?> class="mh-customizer-range-input" lang="en" value="<?php echo esc_attr( $this->value() ); ?>" />
<span class="mh_customizer_reset_slider"></span>
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php
}
}
class MHCustomizer_Customize_Switch_Control extends WP_Customize_Control {
  public $type = 'switch';
  public $description = '';
  public $subtitle = '';
  public function enqueue() {
    $css = '
			.disabled-control-title {
				color: #a0a5aa;
			}
			input[type=checkbox].tgl-switch:checked + .tgl-btn {
				background: #0085ba;
			}
			input[type=checkbox].tgl-switch + .tgl-btn {
			  background: #a0a5aa;
			}
			input[type=checkbox].tgl-switch + .tgl-btn:after {
			  background: #f7f7f7;
			}
		';
    wp_add_inline_style( 'mh-switch-button-css', $css );
  }
  public function render_content() {
    ?>
<label class="customizer-switch">
<div class="customizer-switch-inner"> <span class="customize-control-title"> <?php echo esc_html( $this->label ); ?> </span>
  <input id="cb<?php echo $this->instance_number; ?>" type="checkbox" class="switch_button tgl tgl-<?php echo $this->type; ?>" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); checked( $this->value() ); ?>/>
  <label for="cb<?php echo $this->instance_number; ?>" class="tgl-btn"></label>
  <?php if ( '' != $this->subtitle ) : ?>
  <div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
  <?php endif; ?>
</div>
</label>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php
}
}
class MHCustomizer_MultipleCheckboxImage_Control extends WP_Customize_Control {
  public $type = 'multiple-checkbox-image';
  public $description = '';
  public $subtitle = '';

  public function render_content() {

    if ( empty( $this->choices ) )
      return;
    ?>
<?php if ( !empty( $this->label ) ) : ?>
<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
<?php endif; ?>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<?php $multi_values = !is_array( $this->value() ) ? explode( ',', $this->value() ) : $this->value(); ?>
<?php foreach ( $this->choices as $value => $label ) : ?>
<p class="postinfo <?php echo esc_attr( 'postinfo-' . $value ); ?>">
  <input type="checkbox" class="usual-checkbox" value="<?php echo esc_attr( $value ); ?>" <?php checked( in_array( $value, $multi_values ) ); ?> />
</p>
<?php endforeach; ?>
<input type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr( implode( ',', $multi_values ) ); ?>" />
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php
}

}
class MHCustomizer_IconsPreview_Control extends WP_Customize_Control {
  public $type = 'icons-preview';
  public $control_custom_function = '';

  public function render_content() {
    ?>
<div class="iconpreview">
  <ul class="mhc-icon <?php echo esc_attr( $this->label ); ?>">
    <?php
    $font_icons = call_user_func( esc_attr( $this->control_custom_function ) );
    echo $font_icons;
    ?>
  </ul>
</div>
<?php
}
}
class MHCustomizer_Heading_Control extends WP_Customize_Control {
  public $type = 'mh-heading';
  public $description = '';
  public $subtitle = '';

  public function render_content() {
    ?>
<h4 class="mh-customizer-heading"><?php echo esc_html( $this->label ); ?></h4>
<?php if ( '' != $this->subtitle ) : ?>
<div class="customizer-subtitle"><?php echo $this->subtitle; ?></div>
<?php endif; ?>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php
}
}
class MHCustomizer_Info_Control extends WP_Customize_Control {
  public $type = 'mh-info';
  public $description = '';
  public $subtitle = '';

  public function render_content() {
    ?>
<div class="customizer-subtitle">
  <?php if ( '' != $this->label ) : ?>
  <span><?php echo esc_html( $this->label ); ?></span>
  <?php endif; ?>
  <?php if ( '' != $this->subtitle ) : ?>
  <?php echo $this->subtitle; ?>
  <?php endif; ?>
</div>
<?php if ( isset( $this->description ) && ! empty( $this->description ) ) { ?>
<span class="mh-setting-description-mark dashicons dashicons-editor-help dashicons-before"></span> <span class="mh-setting-description-title"><?php echo esc_html( $this->label ); ?></span> <span class="mh-setting-description"><?php echo mh_wp_kses( $this->description ); ?></span>
<?php } ?>
<?php
}
}