<?php
/**
* The main MHCustomizer class
*/
if (! defined('ABSPATH')) {
    die('-1');
}
if (! class_exists('MHCustomizer', false)) :
    class MHCustomizer
    {
        private $wp_customize;

        public function __construct()
        {

            include_once(dirname(__FILE__) . '/includes/controls-init.php');
            include_once(dirname(__FILE__) . '/includes/transport.php');

            add_action('customize_register', array( $this, 'include_files' ), 1);
            add_action('customize_controls_print_styles', array( $this, 'styles' ));
            add_action('customize_controls_print_scripts', array( $this, 'scripts' ));
            add_action('customize_controls_print_styles', array( $this, 'custom_css' ), 999);
            add_action('wp_ajax_customizer_reset', array( $this, 'ajax_customizer_reset' ));
            add_action('customize_register', array( $this, 'customize_register' ));
        }

        /**
         * Include the necessary file for controls
         */
        public function include_files()
        {
            include_once(dirname(__FILE__) . '/includes/controls.php');
            include_once(dirname(__FILE__) . '/includes/sanitization.php');
        }

        /**
         * Enqueue the stylesheets and scripts required.
         */
        public function styles()
        {
            $ltr = is_rtl() ? "" : "-ltr";
            $theme_version = mh_get_theme_version();

            wp_enqueue_style('mh_customizer-customizer-css', MHARTY_THEME_ADMIN_ASSETS . 'css/customizer' . $ltr . '.css', array(), $theme_version);
            if (mhc_is_wp_pre_5_6()) {
                wp_enqueue_style('mh_customizer-customizer-ui', MHARTY_THEME_ADMIN_ASSETS . 'css/jquery-ui-1.10.0.custom.css', array(), $theme_version);
            } else {
                wp_enqueue_style('mh_customizer-customizer-ui', MHARTY_THEME_ADMIN_ASSETS . 'css/jquery-ui-1.12.1.custom.css', array(), $theme_version);
            }

            if (false === mh_get_option('mharty_disable_customizer_dark_mode')) {
                wp_enqueue_style('mh_customizer-customizer-dark-mode', MHARTY_THEME_ADMIN_ASSETS . 'css/customizer-dark' . $ltr . '.css', array(), $theme_version);
            }
        }


        /**
         * Add custom CSS rules to the head, applying our custom styles
         */
        public function custom_css()
        {

            // Get the active admin theme
            global $_wp_admin_css_colors;

            // Get the user's admin colors
            $color = get_user_option('admin_color');
            // If no theme is active set it to 'fresh'
            if (empty($color) || ! isset($_wp_admin_css_colors[$color])) {
                $color = 'fresh';
            }

            $color = (array) $_wp_admin_css_colors[$color];

            $admin_theme = get_user_meta(get_current_user_id(), 'admin_color', true); //Find out which theme the user has selected.
            if('modern' != $admin_theme) {
                $color_light   = isset($color['colors'][2]) ? $color['colors'][2] : '#2271b1';
                $color_select  = isset($color['colors'][3]) ? $color['colors'][3] : '#72aee6';
            } else {
                $color_light   = isset($color['colors'][1]) ? $color['colors'][1] : '#3858e9';
                $color_select  = isset($color['colors'][2]) ? $color['colors'][2] : '#33f078';
            }

            ?>

		<style>
			

			.ui-state-default,
			.ui-widget-content .ui-state-default,
			.ui-widget-header .ui-state-default,
			.ui-state-active.ui-button.ui-widget.ui-state-default,
      .mh-menu-icon-button{
				background-color: #008fff;
				border: 2px solid rgba(0,0,0,.05);
			}
            
      .image.ui-buttonset label.ui-button.ui-state-active {
				border-color: <?php echo $color_select; ?>;
				background-color: #cccccc !important;
			}
            
			.wp-customizer #customize-controls .control-section .accordion-section-title:focus, .wp-customizer #customize-controls .control-section .accordion-section-title:hover, .wp-customizer #customize-controls .control-section.open .accordion-section-title, .wp-customizer #customize-controls .control-section:hover > .accordion-section-title{
			 border-right-color: <?php echo $color_light ?> !important;
			 border-left-color: <?php echo $color_light ?> !important;
			}

			.customize-panel-back:focus,
			.customize-panel-back:hover,
			.customize-section-back:focus,
			.customize-section-back:hover {
					color: <?php echo $color_light ?> !important;
					border-right-color: <?php echo $color_light ?> !important;
					border-left-color: <?php echo $color_light ?> !important;
			}
			.ui-button.ui-widget.ui-state-default:hover,
			.wp-customizer.wp-core-ui .button:hover,
			.wp-customizer.wp-core-ui .button-secondary:hover {
					background-color: <?php echo $color_light ?> !important;
					border-color: <?php echo $color_light ?> !important;
			}

			input[type=checkbox].tgl-switch:checked + .tgl-btn {
					background: #008fff !important;
			}

			.mh-customizer-heading,
			.customize-control-multiple-checkbox-image p.postinfo .mark:before,
			.customize-control-multiple-checkbox-image p.postinfo .jquery-checkbox-checked .mark:before{
					color: #008fff !important;
			}
			.mh-customizer-heading{
					border-color: #008fff !important;
			}
			input[type="range"]::-webkit-slider-thumb
			input[type="range"]::-webkit-slider-thumb,
			input[type="range"]::-moz-range-thumb,
			input[type="range"]::-ms-thumb{
					background-color: #008fff !important;
			}

			.ui-button.ui-widget.ui-state-default {
				background-color: #fcfcfc;
			}

			#customize-theme-controls .accordion-section-title {
				border-bottom: 1px solid rgba(0,0,0,.1);
			}

			#customize-theme-controls .control-section .accordion-section-title:focus,
			#customize-theme-controls .control-section .accordion-section-title:hover,
			#customize-theme-controls .control-section.open .accordion-section-title,
			#customize-theme-controls .control-section:hover .accordion-section-title {
				background: #008fff;
			}
			#customize-theme-controls .control-section.control-panel.current-panel:hover .accordion-section-title{
				background: #fff;
			}

			#customize-theme-controls .control-section.control-panel.current-panel .accordion-section-title:hover{
				background: #008fff;
			}

			.wp-core-ui .button-primary {
				background: #008fff;
			}

			.wp-core-ui .button-primary.focus,
			.wp-core-ui .button-primary.hover,
			.wp-core-ui .button-primary:focus,
			.wp-core-ui .button-primary:hover {
				background: #008fff;
			}

			.wp-core-ui .button-primary-disabled,
			.wp-core-ui .button-primary.disabled,
			.wp-core-ui .button-primary:disabled,
			.wp-core-ui .button-primary[disabled] {
				background: <?php echo $color_light; ?> !important;
				color: <?php echo $color_select; ?> !important;
			}
			#customize-theme-controls p.postinfo-avatar .mark:after {
				content: '<?php esc_html_e("Avatar", 'mharty'); ?>';
			}
			#customize-theme-controls p.postinfo-author .mark:after {
				content: '<?php esc_html_e("Author", 'mharty'); ?>';
			}

			#customize-theme-controls p.postinfo-date .mark:after {
				content: '<?php esc_html_e("Date", 'mharty'); ?>';
			}

			#customize-theme-controls p.postinfo-categories .mark:after {
				content: '<?php esc_html_e("Categories", 'mharty'); ?>';
			}

			#customize-theme-controls p.postinfo-comments .mark:after {
				content: '<?php esc_html_e("Comments", 'mharty'); ?>';
			}
		</style>
		<?php

        }

        public function scripts()
        {
            global $wp_version;

            $theme_version = mh_get_theme_version();

            wp_register_script('mh_customizer_checkbox', MHARTY_THEME_ADMIN_ASSETS . 'js/checkbox.min.js', array(), $theme_version);
            wp_enqueue_script('mh-customizer-js', MHARTY_THEME_ADMIN_ASSETS . 'js/customizer.js', array( 'jquery', 'wp-color-picker', 'mh_customizer_checkbox' ), true, $theme_version);
            wp_localize_script('mh-customizer-js', 'mh_customizer_settigs', array(
                'default_color_scheme' => implode('|', mh_default_color_scheme()),
                'reset'   => __('Reset', 'mharty'),
                'confirm' => __("Warning: All your customizations will be lost.\nDo you want to proceed?", 'mharty'),
                'nonce'   => array(
                    'reset' => wp_create_nonce('customizer-reset'),
                ),
                'clearpath'    => MHARTY_THEME_ADMIN_ASSETS . 'images/empty.png',
    ));
            ?>
        <script type="text/javascript">
			jQuery( document ).ready( function( $ ) {
                $.wp.wpColorPicker.prototype.options = {
                    width: 275,
                    mode: 'hsv',
                    palettes: mh_customizer_settigs.default_color_scheme.split( '|' )
               };
            });
		</script>
    <?php
        }
        /**
         * Store a reference to `WP_Customize_Manager` instance
         *
         * @param $wp_customize
         */
        public function customize_register($wp_customize)
        {
            $this->wp_customize = $wp_customize;
        }

        public function ajax_customizer_reset()
        {
            if (! $this->wp_customize->is_preview()) {
                wp_send_json_error('not_preview');
            }

            if (! check_ajax_referer('customizer-reset', 'nonce', false)) {
                wp_send_json_error('invalid_nonce');
            }

            $this->reset_customizer();

            wp_send_json_success();
        }

        public function reset_customizer()
        {
            $settings = $this->wp_customize->settings();

            // remove theme_mod settings registered in customizer
            foreach ($settings as $setting) {
                if ('theme_mod' == $setting->type) {
                    remove_theme_mod($setting->id);
                }
            }
        }

    }

$mh_customizer = new MHCustomizer();
endif;

/**
* Create the customizer (panels, settings, style)
*/
function mharty_customizer_config()
{
    $args = array(
    'url_path' => get_template_directory_uri() . '/includes/mh_customizer/',
    );
    return $args;
}
add_filter('mh_customizer/config', 'mharty_customizer_config');

include_once(MHARTY_THEME_DIR . '/includes/mh_customizer/customizer.php');
include_once(MHARTY_THEME_DIR . '/includes/mh_customizer/style.php');
