<?php
if ( ! defined( 'ABSPATH' ) ) { die( '-1' ); }

function mh_mharty_add_customizer_css(){ 
$body_font_size = absint( get_theme_mod( 'body_font_size', '14' ) );
$body_font_height = floatval( get_theme_mod( 'body_font_height', '1.7' ) );
$h1_font_size = absint( get_theme_mod( 'h1_font_size', '26' ) );
$h1_font_height = floatval( get_theme_mod( 'h1_font_height', '1.4' ) );
$h1_font_style = get_theme_mod( 'h1_font_style', 'none' );
$menu_font_size = absint( get_theme_mod( 'menu_font_size', '14' ) );
$subnav_font_size = absint( get_theme_mod( 'subnav_font_size', '14' ) );
$secondary_nav_font_size = absint( get_theme_mod( 'secondary_nav_font_size', '13' ) );
$app_nav_font_size = absint( get_theme_mod( 'app_nav_font_size', '14' ) );
$menu_font_style = get_theme_mod( 'menu_font_style', 'none' );

$ss_body_font_size = absint( get_theme_mod( 'ss_body_font_size', '14' ) );
$ss_body_font_height = floatval( get_theme_mod( 'ss_body_font_height', '1.7' ) );
$ss_h1_font_size = absint( get_theme_mod( 'ss_h1_font_size', '26' ) );
$ss_h1_font_height = floatval( get_theme_mod( 'ss_h1_font_height', '1.4' ) );
$ss_app_nav_font_size = absint( get_theme_mod( 'ss_app_nav_font_size', '14' ) );

$site_title_size = absint( get_theme_mod( 'site_title_size', '26' ) );
$site_title_style = get_theme_mod( 'site_title_style', 'bold' );
$ss_site_title_size = absint( get_theme_mod( 'ss_site_title_size', '26' ) );

?>
<style class="mh_custmoizer_css" type="text/css">
a,
.link_style_accent .mh-the-content a,
.link_style_fx .mh-the-content a,
.link_style_accent .widget_text a,
.link_style_fx .widget_text a,
.nav-single a,
.product_meta a{
    color: <?php echo esc_html(get_theme_mod('link_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}
body{
    color: <?php echo esc_html(get_theme_mod('font_color', '#666666')); ?>;
}
.widget_text a,
.mh-the-content a{
  color: <?php echo esc_html(get_theme_mod('font_color', '#666666')); ?>;
  border-bottom-color: <?php echo esc_html(get_theme_mod('font_color', '#666666')); ?>;
}

.link_style_accent .mh-the-content a,
.link_style_fx .mh-the-content a,
.link_style_fx .mh-the-content a,
.link_style_accent .widget_text a,
.link_style_fx .widget_text a,
.link_style_fx .widget_text a{
  border-bottom-color: <?php echo esc_html(get_theme_mod('font_color', '#666666')); ?>;
}
.link_style_fx .mh-the-content a:hover,
.link_style_hover .mh-the-content a:hover,
.link_style_fx .widget_text a:hover,
.link_style_hover .widget_text a:hover{
  color: <?php echo esc_html(get_theme_mod('link_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
  border-bottom-color: <?php echo esc_html(get_theme_mod('link_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}
h1,
h2,
h3,
h4,
h5,
h6 {
    color: <?php echo esc_html(get_theme_mod('heading_color', '#444444')); ?>;
}
.entry-content tr th,
.entry-content thead th{
    color: <?php echo esc_html(get_theme_mod('heading_color', '#444444')); ?>;
}
.mhc_blurb a .mhc_blurb_content p {
    color: <?php echo esc_html(get_theme_mod('font_color', '#666666')); ?>;
}

.mhc_widget:not(.widget_text) a {
    color: <?php echo esc_html(get_theme_mod('sidebar_link_color', '#666666'));?>!important;
}

.widgettitle {
    color: <?php echo esc_html(get_theme_mod('sidebar_heading_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}

.mh_widget_title_style_line .widgettitle,
.mh_widget_title_style_border .widgettitle,
.mh_widget_title_style_smallborder .widgettitle {
    border-color: <?php echo esc_html(get_theme_mod('sidebar_heading_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}

.mh_widget_title_style_box .widgettitle,
.mh_widget_title_style_arrow .widgettitle {
    background-color: <?php echo esc_html(get_theme_mod('sidebar_heading_alt_color', '#444444')); ?>;
}

.mh_widget_title_style_arrow .widgettitle:after {
    border-top-color: <?php echo esc_html(get_theme_mod('sidebar_heading_alt_color', '#444444')); ?>;
}

<?php 
$post_id = get_the_ID();
$page_menu_color=($menu_color=esc_html(get_post_meta($post_id, '_mhc_page_menu_color', true))) && '' !==$menu_color ? $menu_color: '#ffffff';
$page_bg_color=($bg_color=esc_html(get_post_meta($post_id, '_mh_page_bg_color', true))) && '' !==$bg_color ? $bg_color: '#ffffff';

if ('#ffffff' !== $bg_color) { ?>
body {
	background-color: <?php echo $bg_color; ?>
}
<?php }
$logo_dir = is_rtl() ? 'right' : 'left';
$logo_dir_invert = is_rtl() ? 'left' : 'right';
if ( '1' !== get_theme_mod( 'vertical_nav', '0' ) && '1' !== get_theme_mod('use_logo_text', '0') ) { ?>
  @media only screen and (min-width: 981px) {<?php
	if ('right'=== get_theme_mod('header_style', 'right') || 'full'=== get_theme_mod('header_style', 'right')) { ?>
	.mh_logo{
		float: <?php echo $logo_dir;?>;
	}
  .mh_extra_logo {
		float: <?php echo $logo_dir_invert;?>;
	}
	<?php }
	if ('inline'=== get_theme_mod('header_style', 'right')) { ?>
	.mh_logo {
		float: <?php echo $logo_dir; ?>;
	}
  .mh_extra_logo {
		float: <?php echo $logo_dir_invert; ?>;
	}
	#mh-top-navigation {
		float: <?php echo $logo_dir; ?>;
	}
	<?php } ?>
  } <?php //@media only screen and (min-width: 981px) {  
}
if ( '1' !== get_theme_mod('use_logo_text', '0') ) { ?>
  @media only screen and (max-width: 980px) {
	.mh_logo{
		float: <?php echo $logo_dir;?>;
		line-height: 40px;
	}
	.mh_extra_logo {
		float: <?php echo $logo_dir_invert;?>;
	}
	#main-header .header-name,
	#main-header .header-tagline{
		line-height: normal;
	}
	
  } <?php //@media only screen and (max-width: 980px) {   
}
if (('#ffffff' !==$page_menu_color) && '1' !== get_theme_mod( 'vertical_nav', '0' )) { ?>
.page-template-page-template-trans #main-header.transparent #top-menu > .menu-item > a:first-child,
.page-template-page-template-trans #main-header.transparent #mh-top-navigation .mh-cart-info,
.page-template-page-template-trans #main-header.transparent #mh-top-navigation .mh_search_icon,
  .page-template-page-template-trans #main-header.transparent #mh-top-navigation .mh_top_cta_icon,
.page-template-page-template-trans #main-header.transparent .mh-cart-icon,
.page-template-page-template-trans #main-header.transparent .mh-cart-count{
	color: <?php echo $page_menu_color; ?>!important;
}

.page-template-page-template-trans #main-header.transparent .mh-top-navigation-icons > .mobile-menu-trigger-icon .sandwich-inner,
.page-template-page-template-trans #main-header.transparent .mh-top-navigation-icons > .mobile-menu-trigger-icon .sandwich-inner:after,
.page-template-page-template-trans #main-header.transparent .mh-top-navigation-icons > .mobile-menu-trigger-icon .sandwich-inner:before {
	background-color: <?php echo $page_menu_color; ?>!important;
}
#main-header.transparent #top-menu .sub-menu .menu-item > a:first-child {
	color: inherit;
}
<?php } ?>

.mhc_counter_amount,
.mhc_pricing_default .mhc_featured_table .mhc_pricing_heading,
.mh_quote_content,
.mh_link_content,
.mh_audio_content {
    background-color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
}

<?php if ('1'===get_theme_mod('header_shadow', '0')) { ?> 
#main-header {
	-webkit-box-shadow: 0 0 3px 0 rgba(0, 0, 0, 0.22);
	box-shadow: 0 0 3px 0 rgba(0, 0, 0, 0.22);
}
<?php } ?>

#main-header,
#main-header .nav li ul,
.mh-search-form,
.mobile-menu-sticky-icon{
    background-color: <?php echo esc_html(get_theme_mod('primary_nav_bg', '#ffffff')); ?>;
}

<?php if ('' !==get_theme_mod('primary_subnav_bg', '')) { ?>
#main-header .nav li ul,
.mh-search-form {
    background-color: <?php echo esc_html(get_theme_mod('primary_subnav_bg', '#ffffff'));?>;
}
<?php }
	
if ('' !==get_theme_mod('primary_nav_bg_gradient', '')) :
	$bg_color=esc_html(get_theme_mod('primary_nav_bg', '#ffffff'));
	$gr_color=esc_html(get_theme_mod('primary_nav_bg_gradient', '#ffffff'));

if ('left'===get_theme_mod('primary_nav_bg_gradient_dir', 'left')) { ?>
#main-header {
	background: <?php echo $bg_color;?>;
	background: -webkit-gradient(linear, left top, right top, color-stop(0%, <?php echo $bg_color;?>), color-stop(100%, <?php echo $gr_color;?>));
	background: linear-gradient(to right, <?php echo $bg_color;?> 0%, <?php echo $gr_color;?> 100%);
	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php  echo $bg_color;?>', endColorstr='<?php  echo $gr_color;?>', GradientType=1);
}

<?php } else { ?>
#main-header {
	background: <?php echo $bg_color;?>;
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, <?php echo $bg_color;?>), color-stop(100%, <?php echo $gr_color;?>));
	background: linear-gradient(to bottom, <?php echo $bg_color;?> 0%, <?php echo $gr_color;?> 100%);
	filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php  echo $bg_color;?>', endColorstr='<?php  echo $gr_color;?>', GradientType=0);
}
<?php } 
endif; //if ('' !==get_theme_mod('primary_nav_bg_gradient', '')) ?>

#top-header,
#mh-secondary-nav li ul,
#mh-secondary-nav li.mega-menu ul,
#mh-secondary-nav li.no-mega-menu ul {
    background-color: <?php echo esc_html(get_theme_mod('secondary_nav_bg', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}
.mh-app-nav {
	background-color: <?php echo esc_html(get_theme_mod('app_menu_bg', '#f4f4f4')); ?>;
}
<?php if ('custom'===get_theme_mod('secondary_nav_text_color', 'light')) { ?>
#mh-info a,
#mh-info span,
#mh-secondary-nav a,
#mh-secondary-nav .megamenu-title,
#top-header .mh-social-icon a,
#mh-secondary-menu .mh-cart-icon,
#mh-secondary-menu mh-cart-count {
	color: <?php echo esc_html(get_theme_mod('secondary_nav_text_color_custom', get_theme_mod('accent_color', '#4FD4FF')));?>!important;
	border-color: <?php echo esc_html(get_theme_mod('secondary_nav_text_color_custom', get_theme_mod('accent_color', '#4FD4FF')));?>!important;
}

#mh-info a:hover,
#mh-secondary-nav a:hover,
#top-header .mh-social-icon a:hover,
#mh-secondary-menu .mh-cart-info:hover {
	opacity: 0.85;
}
<?php } 
if ('1'===get_theme_mod('secondary_nav_border_active', '0')) :
if ('1'===get_theme_mod('secondary_nav_position', '0')) { ?>
#top-header {
	border-bottom: 2px solid <?php echo esc_html(get_theme_mod('secondary_nav_border', get_theme_mod('accent_color', '#4FD4FF')));?>;
}
<?php } else { ?>
#top-header {
	border-top: 2px solid <?php echo esc_html(get_theme_mod('secondary_nav_border', get_theme_mod('accent_color', '#4FD4FF')));?>;
}

<?php }
endif; // if ('1'===get_theme_mod('secondary_nav_border_active', '0'))

if ('' !== get_theme_mod('app_logo_size', '')) {?>
#app-logo{
  width: <?php echo esc_html(get_theme_mod('app_logo_size', ''));?>px;
}
<?php }
if ('' !==get_theme_mod('menu_highlight_bg', get_theme_mod('accent_color', '#4FD4FF'))) { ?>
#top-menu > li.mhc-menu-highlight,
.fullwidth-menu > li.mhc-menu-highlight,
#top-menu li > .sub-menu li.mhc-menu-highlight > a,
.fullwidth-menu li > .sub-menu li.mhc-menu-highlight > a,
#mh-secondary-nav > li.mhc-menu-highlight,
#mh-secondary-nav li > .sub-menu li.mhc-menu-highlight > a,
.app-menu li.mhc-menu-highlight > a,
#top-menu > li.current-menu-ancestor.mhc-menu-highlight,
#top-menu > li.current-menu-item.mhc-menu-highlight,
.bottom-nav > li.mhc-menu-highlight,
.mh-top-cta-button.mh-cta-button-solid a{
    background-color: <?php echo esc_html(get_theme_mod('menu_highlight_bg', get_theme_mod('accent_color', '#4FD4FF')));?>!important;
}
.mh-top-cta-button.mh-cta-button-border a{
  border: 1px solid  <?php echo esc_html(get_theme_mod('menu_highlight_bg', get_theme_mod('accent_color', '#4FD4FF')));?>!important;
  color: <?php echo esc_html(get_theme_mod('menu_highlight_bg', get_theme_mod('accent_color', '#4FD4FF')));?>!important;
}
<?php }
if ('' !==get_theme_mod('menu_highlight_color', '#ffffff')) { ?>
#top-menu > li.mhc-menu-highlight > a,
.fullwidth-menu > li.mhc-menu-highlight > a,
#top-menu li > .sub-menu li.mhc-menu-highlight > a,
.fullwidth-menu li > .sub-menu li.mhc-menu-highlight > a,
#mh-secondary-nav > li.mhc-menu-highlight > a,
#mh-secondary-nav li > .sub-menu li.mhc-menu-highlight > a,
.app-menu li.mhc-menu-highlight > a,
.bottom-nav > li.mhc-menu-highlight > a,
.mh-top-cta-button.mh-cta-button-solid a{
    color: <?php echo esc_html(get_theme_mod('menu_highlight_color', '#ffffff')); ?>!important;
}
.mh-top-cta-button.mh-cta-button-border a{
  background-color: <?php echo esc_html(get_theme_mod('menu_highlight_color', '#ffffff')); ?>!important;
}
<?php } ?>
.mhc_filterable_portfolio .mhc_portfolio_filters li a span,
.mhc_button_solid,
.mhc_wpcf7_solid .wpcf7-form input[type="submit"],
.mh-tags .tag-links a,
.bbp-topic-tags a,
.nav li a em,
.menu li a em,
.mh_adjust_bg,
.edd-submit.button.gray{
    background: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>!important;
}
.mh-social-accent-color.mh-social-solid-color li{
    background-color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
}

.comment-reply-link,
#cancel-comment-reply-link,
.form-submit input,
.mhc_pricing_default .mhc_sum,
.mhc_pricing li a,
.mhc_pricing_default .mhc_pricing_table_button.mhc_button_transparent,
.mh-loveit-container .mh-loveit.loved.mh_share_accent .icon-icon_heart,
.mh_password_protected_form .mh_submit_button,
.bbp-submit-wrapper button.button,
.mh_widget_info_inner p i,
button.mhc_search_bar_submit i,
.mh-social-accent-color li a,
.search-form-button-icon{
    color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>!important;
}

#main-header .header-name{
  color: <?php echo esc_html(get_theme_mod('site_title_color', get_theme_mod('accent_color', '#4FD4FF')));?>;
}
#main-header .header-tagline{
    color: <?php echo esc_html(get_theme_mod('site_tagline_color', get_theme_mod('menu_link', '#666666')));?>;
}


  
.mhc_widget li a:hover,
.mhc_bg_layout_light .mhc_promo_button.mhc_transify,
.mhc_bg_layout_light .mhc_more_button,
.mhc_filterable_portfolio .mhc_portfolio_filters li a.active,
.mhc_filterable_portfolio .mhc_portofolio_pagination ul li a.active,
.mhc_gallery .mhc_gallery_pagination ul li a.active,
.wp-pagenavi span.current,
.wp-pagenavi a:hover,
.mhc_contact_submit.mhc_button_transparent,
.mhc_wpcf7_transparent .wpcf7-form input[type="submit"],
.mhc_bg_layout_light .mhc_newsletter_button,
.mhc_bg_layout_light .mhc_mailpoet_form .wysija-submit,
.bbp-topics-front ul.super-sticky:after,
.bbp-topics ul.super-sticky:after,
.bbp-topics ul.sticky:after,
.bbp-forum-content ul.sticky:after {
    color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>!important;
}

blockquote,
.footer-widget li:before,
.mhc_pricing_default .mhc_pricing li:before,
.mhc_button_solid,
.mhc_wpcf7_solid .wpcf7-form input[type="submit"],
.mh_password_protected_form .mh_submit_button,
#bbpress-forums .bbp-forums-list,
.bbp-topics-front ul.super-sticky,
#bbpress-forums li.bbp-body ul.topic.super-sticky,
#bbpress-forums li.bbp-body ul.topic.sticky,
.bbp-forum-content ul.sticky,
.mhc_pricing_neon .mhc_featured_table,
.mh-social-accent-color li,
.mhc_contact_submit_message,
  .mh_search_bar_shortcode .mhc_search_bar_form .mhc_search_bar_input .mhc_search_bar_field:focus,
  .mh_search_bar_shortcode .mhc_search_bar_form .mhc_search_bar_input .mhc_search_bar_field:active{
    border-color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
}

#bbpress-forums .hentry div.bbp-reply-content:before,
#bbpress-forums .hentry div.bbp-topic-content:before {
    border-right-color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
}

.rtl #bbpress-forums .hentry div.bbp-reply-content:before,
.rtl #bbpress-forums .hentry div.bbp-topic-content:before {
    border-left-color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
    border-right-color: transparent;
}

#main-footer {
    background-color: <?php echo esc_html(get_theme_mod('footer_widgets_bg', '#383838')); ?>;
}

#footer-bottom {
    background-color: <?php echo esc_html(get_theme_mod('footer_bg', '#1b1b1b')); ?>;
}

.footer-widget {
    color: <?php echo esc_html(get_theme_mod('footer_widgets_color', '#ffffff')); ?>;
}

.footer-widget a,
.bottom-nav a,
#footer-widgets .footer-widget li a {
    color: <?php echo esc_html(get_theme_mod('footer_widgets_color_link', '#ffffff')); ?>!important;
}

.footer-widget h4.title {
    color: <?php echo esc_html(get_theme_mod('footer_widget_heading_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}

.mh_widget_title_style_line .footer-widget h4.title,
.mh_widget_title_style_border .footer-widget h4.title,
.mh_widget_title_style_smallborder .footer-widget h4.title {
    border-color: <?php echo esc_html(get_theme_mod('footer_widget_heading_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}

.mh_widget_title_style_box .footer-widget h4.title,
.mh_widget_title_style_arrow .footer-widget h4.title {
    background-color: <?php echo esc_html(get_theme_mod('footer_widget_heading_alt_color', '#ffffff')); ?>;
}

.mh_widget_title_style_arrow .footer-widget h4.title::after {
    border-top-color: <?php echo esc_html(get_theme_mod('footer_widget_heading_alt_color', '#ffffff')); ?>;
}

#footer-info {
    color: <?php echo esc_html(get_theme_mod('footer_color', '#5c5a5a')); ?>;
}

#footer-info a {
    color: <?php echo esc_html(get_theme_mod('footer_color_link', '#747474')); ?>;
}

#top-menu a,
.mh-top-cta-text a{
    color: <?php echo esc_html(get_theme_mod('menu_link', '#666666')); ?>;
}

#mh-top-navigation .mh_search_icon,
#mh-top-navigation .mh_top_cta_icon,
#mh-top-navigation .mh-cart-icon,
#mh-top-navigation .mh-cart-count{
    color: <?php echo esc_html(get_theme_mod('menu_icons', 'rgba(0, 0, 0, 0.4)')); ?>!important;
}

.mh-top-navigation-icons > .mobile-menu-trigger-icon .sandwich-inner,
.mh-top-navigation-icons > .mobile-menu-trigger-icon .sandwich-inner:after,
.mh-top-navigation-icons > .mobile-menu-trigger-icon .sandwich-inner:before,
.mobile-menu-sticky-icon  .sandwich-inner,
.mobile-menu-sticky-icon  .sandwich-inner:after,
.mobile-menu-sticky-icon  .sandwich-inner:before{
    background-color: <?php echo esc_html(get_theme_mod('menu_icons', 'rgba(0, 0, 0, 0.4)')); ?>!important;
}

#top-menu > li.current-menu-ancestor > a,
#top-menu > li.current-menu-item > a,
.mh_nav_text_color_light #top-menu li.current-menu-ancestor > a,
.mh_nav_text_color_light .mh_nav_text_color_light #top-menu li.current-menu-item > a {
    color: <?php echo esc_html(get_theme_mod('menu_link_active', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}

<?php if ('' !==get_theme_mod('menu_link_bg', '')) { ?>
#top-menu > li {
	background-color: <?php echo esc_html(get_theme_mod('menu_link_bg', '')); ?>;
}

<?php }
if ('' !==get_theme_mod('menu_link_active_bg', '')) { ?>
#top-menu > li.current-menu-ancestor,
#top-menu > li.current-menu-item {
	background-color: <?php echo esc_html(get_theme_mod('menu_link_active_bg', '')); ?>!important;
}
<?php } else { ?>
#top-menu > li.current-menu-ancestor,
#top-menu > li.current-menu-item {
	background-color: transparent !important;
}
<?php }
if ('1'===get_theme_mod('enable_menu_link_sep_color', '0')) :
if (is_rtl()) { ?>
#top-menu > li {
	border-left: 1px solid <?php echo esc_html(get_theme_mod('menu_link_sep_color', '#e2e2e2')); ?>;
}
<?php } else { ?>
#top-menu > li {
	 border-right: 1px solid <?php echo esc_html(get_theme_mod('menu_link_sep_color', '#e2e2e2')); ?>;
}
<?php }
endif;//('1'===get_theme_mod('enable_menu_link_sep_color', '0')) ?>
<?php if ('' !==get_theme_mod('menu_link_bg', '') && '' !==get_theme_mod('menu_link_active_bg', '')) { ?>
#top-menu > li:hover {
    background-color: <?php echo esc_html(get_theme_mod('menu_link_active_bg', '')); ?>;
}
#top-menu > li:hover > a,
.mh_nav_text_color_light #top-menu li:hover > a,
.mh_nav_text_color_dark #top-menu li:hover > a{
    color: <?php echo esc_html(get_theme_mod('menu_link_active', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}
<?php }
if ('' !==get_theme_mod('header_bg_img', '') && !is_page_template('page-template-trans.php')) { ?>
#main-header {
	background-image: url('<?php echo esc_html( get_theme_mod( 'header_bg_img', '' ) ); ?>');
	background-position: <?php echo esc_html(get_theme_mod('header_bg_position_x', 'center') .' '. get_theme_mod('header_bg_position_y', 'center')); ?>;
	background-repeat: <?php echo esc_html(get_theme_mod('header_bg_repeat', 'no-repeat')); ?>;
	background-size: <?php echo esc_html(get_theme_mod('header_bg_size', 'auto')); ?>;
}

<?php }
if ('' !==get_theme_mod('footer_bg_img', '')) {
$footer_bg=esc_html(get_theme_mod('footer_bg', '#1b1b1b'));
$footer_bg_color=hex2rgb($footer_bg); ?>

#main-footer {
    background-image: url('<?php echo esc_html( get_theme_mod( 'footer_bg_img', '' ) ); ?>');
    background-position: <?php echo esc_html(get_theme_mod('footer_bg_position_x', 'center') .' '. get_theme_mod('footer_bg_position_y', 'center')); ?>;
    background-repeat: <?php echo esc_html(get_theme_mod('footer_bg_repeat', 'no-repeat')); ?>;
    background-size: <?php echo esc_html(get_theme_mod('footer_bg_size', 'auto')); ?>;
}
#footer-bottom {
    background-color: rgba(<?php echo $footer_bg_color; ?>, 0.5);
}
<?php }
if (false !==get_theme_mod('header_padding', false) && '' !==get_theme_mod('header_padding_top', '')) { ?>
#main-header {
	padding-top: <?php echo esc_html(get_theme_mod('header_padding_top', '')); ?>px;
}

<?php }
if (false !==get_theme_mod('header_padding', false) && '' !==get_theme_mod('header_padding_bottom', '')) { ?>
#main-header {
    padding-bottom: <?php echo esc_html(get_theme_mod('header_padding_bottom', '')); ?>px;
}
<?php }
if ('' !==($mharty_xl_logo=esc_attr(get_theme_mod('xl_logo', '')))) :
    if (false===get_theme_mod('header_padding', false)) {
        $xl_logo=(int) $mharty_xl_logo; ?>
#logo,
#sticky_logo,
.mh_extra_logo img{
	height: <?php echo $xl_logo; ?>px;
}
.mh_logo,
.mh_extra_logo,
#top-menu > li > a,
#mh_top_search,
.mh-top-cta,
.mh-top-navigation-icons > .mobile-menu-trigger-icon,
#mh-top-navigation .mh_cart_wrapper {
	line-height: <?php echo $xl_logo*2; ?>px;
}
.mh-top-cta.mh-top-cta-text,
#top-menu > li > a .mhc-menu-item-link-head {
	line-height: <?php echo $xl_logo*2 + 3;?>px;
}

.mh_logo,
.mh_extra_logo{
	height: <?php echo $xl_logo*2;?>px;
}

.mh_logo img,
.mh_extra_logo img{
	padding: <?php echo $xl_logo/2;?>px 0;
}

#top-menu li.mega-menu > ul,
.mh-search-form,
.nav li ul {
	top: auto;
}

#top-menu .menu-item-has-children > a:first-child:after {
	line-height: <?php echo $xl_logo*2;?>px;
}
@media only screen and (min-width: 981px) {
.mh_header_style_centered #top-menu li.mega-menu > ul,
.mh_header_style_centered .mh-search-form {
	top: <?php echo $xl_logo*4;?>px;
}

.mh_header_style_centeredx #top-menu li.mega-menu > ul,
.mh_header_style_centeredx .mh-search-form {
	top: <?php echo $xl_logo*2;?>px;
}
}
<?php } else {
$xl_logo=(int) $mharty_xl_logo;
      
?>
#logo,
#sticky_logo,
.mh_extra_logo img{
	height: <?php echo $xl_logo;?>px;
}

.mh_logo,
.mh_extra_logo{
	line-height: <?php echo $xl_logo;?>px;
	height: <?php echo $xl_logo;?>px;
}

.mh_logo img,
.mh_extra_logo img {
	padding: 0;
}

#top-menu > li > a,
#top-menu .menu-item-has-children > a:first-child:after,
#top-menu > li > a .mhc-menu-item-link-head,
#mh_top_search,
.mh-top-cta,
.mh-top-navigation-icons > .mobile-menu-trigger-icon,
#mh-top-navigation .mh_cart_wrapper{
	line-height: 34px;
}

#top-menu > li,
#mh-top-navigation .mh_cart_wrapper,
#mh_top_search,
.mh-top-cta,
.mh-top-navigation-icons > .mobile-menu-trigger-icon{
	margin-top: <?php echo ($xl_logo - 34)/2;?>px;
	margin-bottom: <?php echo ($xl_logo - 34)/2;?>px;
}

#top-menu li.mega-menu > ul,
.mh-search-form,
.nav li ul {
	top: auto;
}
@media only screen and (min-width: 981px) {
.mh_header_style_centered #top-menu > li > a,
.mh_header_style_centered #top-menu .menu-item-has-children > a:first-child:after {
	line-height: 34px;
}

.mh_header_style_centered #top-menu ul .menu-item-has-children > a:first-child:after {
	line-height: 25px;
}

.mh_header_style_centered #top-menu li.mega-menu > ul,
.mh_header_style_centered .mh-search-form,
.mh_header_style_centered .nav li ul {
	top: auto;
}
}

<?php } endif;//f ('' !==($mharty_xl_logo=esc_attr(get_theme_mod('xl_logo', '')
if ('1'===get_theme_mod('show_promo_bar', '0')) { ?>
.mh-promo {
    background-color: <?php echo esc_html(get_theme_mod('promo_bar_bg', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}
.mh-promo .mh-promo-close,
.mh-promo .mh-promo-inner p {
    color: <?php echo esc_html(get_theme_mod('promo_bar_text_color', '#ffffff')); ?>;
}

.mh-promo .mh-promo-inner a {
    background-color: <?php echo esc_html(get_theme_mod('promo_bar_button_bg', '#ffffff')); ?>;
    color: <?php echo esc_html(get_theme_mod('promo_bar_button_text_color', get_theme_mod('accent_color', '#4FD4FF'))); ?>;
}
<?php } ?>
  @media only screen and (max-width: 980px) {
<?php if (false===get_theme_mod('always_show_nav_menu', false)) { ?>

	#mh-secondary-nav {
		display: none;
	}
<?php }
if (false===get_theme_mod('always_show_nav_social', false)) { ?>
	#top-header .mh-social-icons {
		display: none;
	}
<?php }
if (false === get_theme_mod('always_show_extra_logo', false)) { ?>
	.mh_extra_logo {
		display: none;
	}
<?php }
if (false === get_theme_mod('always_show_back_to_top', false)) { ?>
	.mhc_scroll_top {
		display: none !important;
	}
<?php }
if (false === get_theme_mod('always_show_top_cta', false)) { ?>
	.mh-top-cta-1 {
		display: none;
	}
<?php }
if (false === get_theme_mod('always_show_top_cta_2', false)) { ?>
	.mh-top-cta-2 {
		display: none;
	}
<?php }
if ('0'===get_theme_mod('show_secondary_nav', '1')) { ?>
	#top-header {
		display: none;
	}
	.mh_fixed_top.mh_secondary_nav_above #main-header, .mh_fixed_top.mh_secondary_nav_above #top-header{
		position: fixed;
	}
<?php } else { ?>
	.mh_fixed_top.mh_secondary_nav_above #page-container {
		padding-top: 0 !important;
	}
	.mh_fixed_top.mh_secondary_nav_above #main-header{
		top: 0 !important;
	}
<?php } ?>
  } <?php //@media only screen and (max-width: 980px)
if ('' !==get_theme_mod('mharty_quick_contact_icon', '')) { ?>
.mh_quick_form .mh_quick_form_button:before {
    content: "\<?php echo esc_html( get_theme_mod( 'mharty_quick_contact_icon', '' ) ); ?>";
}
<?php }
if ('#ffffff' !==get_theme_mod('mharty_quick_contact_bg', '#ffffff')) { ?>
.mh_quick_form .mh_quick_form_inner {
    background-color: <?php echo esc_html(get_theme_mod('mharty_quick_contact_bg', '#ffffff')); ?>;
}
<?php }
if ('#666666' !==get_theme_mod('mharty_quick_contact_button_bg', '#666666')) { ?>
.mh_quick_form .mh_quick_item_contact .mh_quick_form_button,
.mh_quick_form .mh_quick_form_inner .mhc_contact_submit{
    background-color: <?php echo esc_html(get_theme_mod('mharty_quick_contact_button_bg','#666666')); ?> !important;
    border-color: <?php echo esc_html(get_theme_mod('mharty_quick_contact_button_bg', '#666666')); ?> !important;
}
<?php }

if ( true === get_theme_mod( 'mharty_show_custom_1_icon', false) && '' !== get_theme_mod('mharty_custom_1_icon', '')) : ?>
.mh-social-custom-1 a.icon::before {
	content: "\<?php echo esc_html( get_theme_mod( 'mharty_custom_1_icon', '' ) ); ?>";
}
<?php
if ( '' !== get_theme_mod( 'mharty_custom_1_icon_color', '#cccccc')) :?>
.mh-social-default-color .mh-social-custom-1{
	color: <?php echo esc_html( get_theme_mod( 'mharty_custom_1_icon_color', '#cccccc' ) ); ?> !important;
}
<?php endif; //mharty_custom_1_icon_color ?>
.mh-social-bg-color .mh-social-custom-1 {
    background-color: <?php echo esc_html( get_theme_mod( 'mharty_custom_1_icon_color', '#cccccc' ) ); ?>;
    border-color: <?php echo esc_html( get_theme_mod( 'mharty_custom_1_icon_color', '#cccccc' ) ); ?>;
}    
<?php endif; //mharty_show_custom_1_icon

if ( true === get_theme_mod( 'mharty_show_custom_2_icon', false) && '' !== get_theme_mod('mharty_custom_2_icon', '')) : ?>
.mh-social-custom-2 a.icon::before {
	content: "\<?php echo esc_html( get_theme_mod( 'mharty_custom_2_icon', '' ) ); ?>";
}
<?php
if ( '' !== get_theme_mod( 'mharty_custom_2_icon_color', '#cccccc')) :?>
.mh-social-default-color .mh-social-custom-2 {
	color: <?php echo esc_html( get_theme_mod( 'mharty_custom_2_icon_color', '#cccccc' ) ); ?> !important;
}
<?php endif; //mharty_custom_2_icon_color ?>
.mh-social-bg-color .mh-social-custom-2 {
    background-color: <?php echo esc_html( get_theme_mod( 'mharty_custom_2_icon_color', '#cccccc' ) ); ?>;
    border-color: <?php echo esc_html( get_theme_mod( 'mharty_custom_2_icon_color', '#cccccc' ) ); ?>;
}
    
<?php endif; //mharty_show_custom_2_icon
  
if ('' !==get_theme_mod('search_icon', '')) { ?>
.mh_search_icon:before,
.mhc_search_bar_form .mhc_search_bar_input button.mhc_search_bar_submit i:before{
    content: "\<?php echo esc_html( get_theme_mod( 'search_icon', '' ) ); ?>";
}
<?php }
  
if ('' !==get_theme_mod('top_cta_icon', '')) { ?>
.mh-top-cta-1 .mh_top_cta_icon:before{
    content: "\<?php echo esc_html( get_theme_mod( 'top_cta_icon', '' ) ); ?>";
}
<?php }
if ('' !==get_theme_mod('top_cta_icon_2', '')) { ?>
.mh-top-cta-2 .mh_top_cta_icon:before{
    content: "\<?php echo esc_html( get_theme_mod( 'top_cta_icon_2', '' ) ); ?>";
}
<?php }  
  
if ('' !==get_theme_mod('secondary_nav_phrase_icon', '')) :
if (is_rtl()) { ?>
.mh-info-custom-text:after {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_phrase_icon', '' ) ); ?>";
}
<?php } else { ?>
.mh-info-custom-text:before {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_phrase_icon', '' ) ); ?>";
}

<?php } endif; // if ('' !==get_theme_mod('secondary_nav_phrase_icon', ''))
  
  
if ('' !==get_theme_mod('secondary_nav_phone_icon', '')) :
if (is_rtl()) { ?>
.mh-info-phone:after {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_phone_icon', '' ) ); ?>";
}
<?php } else { ?>
.mh-info-phone:before {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_phone_icon', '' ) ); ?>";
}
<?php } endif; //if ('' !==get_theme_mod('secondary_nav_phone_icon', ''))
if ('' !==get_theme_mod('secondary_nav_email_icon', '')) :
if (is_rtl()) { ?>
.mh-info-email:after {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_email_icon', '' ) ); ?>";
}
<?php } else { ?>
.mh-info-email:before {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_email_icon', '' ) ); ?>";
}

<?php } endif; // if ('' !==get_theme_mod('secondary_nav_email_icon', ''))
if ('' !==get_theme_mod('secondary_nav_date_icon', '')) :
if (is_rtl()) { ?>
.mh-info-date:after {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_date_icon', '' ) ); ?>";
}
<?php } else { ?>
.mh-info-date:before {
	content: "\<?php echo esc_html( get_theme_mod( 'secondary_nav_date_icon', '' ) ); ?>";
}
<?php } endif; //if ('' !==get_theme_mod('secondary_nav_date_icon', ''))
if (true !== get_theme_mod('alwyas_show_app_menu', false)) { ?>
@media only screen and (min-width: 981px) {
	#mh-top-navigation .mobile-menu-trigger-icon,
  .mh_vertical_nav #main-header .mobile-menu-trigger-icon,
  .mobile-menu-sticky-icon{
		display: none !important;
	}
}
<?php } ?>
@media only screen and (max-width: 980px) {
  <?php if ('' !==($mobile_xl_logo=esc_attr(get_theme_mod('mobile_xl_logo', '')))) :
        $mobile_logo_size=(int) $mobile_xl_logo; 
        if (false===get_theme_mod('header_padding', false)) { ?>
#logo,
#sticky_logo,
.mh_extra_logo img{
  height: <?php echo $mobile_logo_size; ?>px;
}

.mh_logo,
.mh_extra_logo,
#mh_top_search,
.mh-top-cta,
.mh-top-navigation-icons > .mobile-menu-trigger-icon,
#mh-top-navigation .mh_cart_wrapper {
  line-height: <?php echo $mobile_logo_size*2; ?>px;
}
.mh-top-cta.mh-top-cta-text,
#top-menu > li > a .mhc-menu-item-link-head {
  line-height: <?php echo $mobile_logo_size*2 + 3;?>px;
}

.mh_logo,
.mh_extra_logo{
  height: <?php echo $mobile_logo_size*2;?>px;
}

.mh_logo img,
.mh_extra_logo img{
  padding: <?php echo $mobile_logo_size/2;?>px 0;
}
<?php }else{ ?>
   #logo,
   #sticky_logo,
  .mh_extra_logo img{
	height: <?php echo $mobile_logo_size;?>px;
}

.mh_logo,
.mh_extra_logo{
	line-height: <?php echo $mobile_logo_size;?>px;
	height: <?php echo $mobile_logo_size;?>px;
}

.mh_logo img,
.mh_extra_logo img{
	padding: 0;
}
.mh-top-navigation-icons > .mobile-menu-trigger-icon,
#mh-top-navigation .mh_cart_wrapper,
#mh_top_search,
.mh-top-cta,
#top-menu > li > a .mhc-menu-item-link-head{
	line-height: 34px;
}
  
#mh-top-navigation .mh_cart_wrapper,
.mh-top-navigation-icons > .mobile-menu-trigger-icon,
#mh_top_search,
.mh-top-cta{
	margin-top: <?php echo ($mobile_logo_size - 34)/2;?>px;
	margin-bottom: <?php echo ($mobile_logo_size - 34)/2;?>px;
}
  
  <?php } ?>
  
<?php endif; 
if (false===get_theme_mod('alwyas_show_search_icon', false)) { ?>
#main-header #mh_top_search {
   display: none !important;
}
<?php } ?>
}

<?php if ('0'===get_theme_mod('sidebar_border', '1')) { ?>
#main-content .container::before {
    background-color: transparent
}
.mhc_widget_area_left,
.mhc_widget_area_right {
    border: none;
}
<?php }
if(('accent'===get_theme_mod('mharty_share_color', 'accent') && (function_exists('mh_loveit')))) { ?>
.mh_share .mh_share_accent li {
    border-color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
}
.mh_share .mh_share_accent.mh_share_border li span,
.mh_share .mh_share_accent.mh_share_border li i {
    color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
}
.mh_share .mh_share_accent.mh_share_solid li {
    background-color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>;
}
.mh_share .mh_share_accent.mh_share_solid li span,
.mh_share .mh_share_accent.mh_share_solid li i {
    color: #ffffff;
}
<?php }
if (true===get_theme_mod('fix_transparent_bg', false)){ ?>
#main-content {
    background: #ffffff;
}
<?php }
if ( true !== get_theme_mod( 'always_show_quick_contact', true ) ) { ?>
  @media only screen and (max-width: 980px) {
    .mh_quick_form .mh_quick_item_contact{
      display: none;
    }
  }
<?php }
if ( true !== get_theme_mod( 'always_show_quick_social', true ) ) { ?>
  @media only screen and (max-width: 980px) {
    .mh_quick_form .mh_quick_item_social{
      display: none;
    }
  }
<?php }
printf('#mh-main-area h1, #mh-main-area h2, #mh-main-area h3, #mh-main-area h4, #mh-main-area h5, #mh-main-area h6 { %s%s%s%s%s }',
('bold'===$h1_font_style ? 'font-weight: bold;' : ''),
('italic'===$h1_font_style ? 'font-style: italic;' : ''),
('italicbold'===$h1_font_style ? 'font-weight: bold; font-style: italic;' : ''),
('uppercase'===$h1_font_style ? 'text-transform: uppercase;' : ''),
('uppercasebold'===$h1_font_style ? 'font-weight: bold; text-transform: uppercase;' : ''));
  ?>
@media only screen and (min-width: 981px) {
<?php if (14 !==$body_font_size) { ?>
body {
	font-size: <?php echo esc_html($body_font_size); ?>px;
}
<?php if (true===get_theme_mod('body_font_include', false)) { ?>
.mh-breadcrumb, 
.post-meta p,
.post-meta.post-meta-alt p,
.co-author-line{
	font-size: <?php echo esc_html(intval($body_font_size * 0.9));?>px;
}
ul.mh_magazine_head li {
	font-size: <?php echo esc_html(intval($body_font_size * 0.78));?>px!important;
}

<?php } } // if (14 !==$body_font_size) 
if (1.7 !==$body_font_height) { ?>
body, p {
	line-height: <?php echo esc_html($body_font_height);?>em;
}
<?php }
if (26 !==$site_title_size) { ?>
#main-header .header-name{
	font-size: <?php echo esc_html($site_title_size);?>px;
}
<?php
}
if (26 !==$h1_font_size) { ?>
#mh-main-area h1 {
	font-size: <?php echo esc_html($h1_font_size);?>px;
}
#mh-main-area h2 {
	font-size: <?php echo esc_html(intval($h1_font_size * .85));?>px;
}
#mh-main-area h3 {
	font-size: <?php echo esc_html(intval($h1_font_size * .77));?>px;
}
#mh-main-area h4 {
	font-size: <?php echo esc_html(intval($h1_font_size * .7));?>px;
}
#mh-main-area h5 {
	font-size: <?php echo esc_html(intval($h1_font_size * .6));?>px;
}
#mh-main-area h6 {
	font-size: <?php echo esc_html(intval($h1_font_size * .53));?>px;
}
<?php }
if (1.4 !==$h1_font_height) { ?>

#mh-main-area h1,
#mh-main-area h2,
#mh-main-area h3,
#mh-main-area h4,
#mh-main-area h5,
#mh-main-area h6 {
	line-height: <?php echo esc_html($h1_font_height);?>em;
}
<?php }


if ('14' !== $menu_font_size && '14px' !== $menu_font_size && 0 !== $menu_font_size) { ?>
#top-menu > li > a,
.mh-top-cta.mh-top-cta-text{
	font-size: <?php echo esc_html($menu_font_size);?>px;
}
<?php }
if ('14' !==$subnav_font_size ) { ?>
#top-menu li li a,
#main-header .mh-cart-container h2 {
	font-size: <?php echo esc_html($subnav_font_size); ?>px;
}

#top-menu li li .mhc-menu-desc,
#main-header .mh-cart-container {
	font-size: <?php echo esc_html(intval($subnav_font_size * .87)); ?>px;
}
<?php }
if ('13' !==$secondary_nav_font_size) {?>
#top-header #mh-info,
#mh-secondary-nav li li a,
#mh-secondary-nav li a,
#top-header .mh-cart-container h2 {
	font-size: <?php echo esc_html($secondary_nav_font_size);?>px;
}

#top-header .mhc-menu-desc,
#top-header .mh-cart-container {
	font-size: <?php echo esc_html(intval($secondary_nav_font_size * .87));?>px;
}
<?php }
if ('14' !==$app_nav_font_size) { ?>
.app-nav {
	font-size: <?php echo esc_html($app_nav_font_size);?>px;
}

.app-nav .mhc-menu-desc {
	font-size: <?php echo esc_html(intval($app_nav_font_size * .87));?>px;
}
<?php }
printf('#top-menu a, #top-menu h3, .mh-top-cta a, #main-header .mh-cart-container h2 { %s%s%s%s%s }',
    ('bold'===$menu_font_style ? 'font-weight: bold;' : ''),
    ('italic'===$menu_font_style ? 'font-style: italic;' : ''),
    ('italicbold'===$menu_font_style ? 'font-weight: bold; font-style: italic;' : ''),
    ('uppercase'===$menu_font_style ? 'text-transform: uppercase;' : ''),
    ('uppercasebold'===$menu_font_style ? 'font-weight: bold; text-transform: uppercase;' : ''));
  
printf('#main-header .header-name { %s%s%s%s%s }',
    ('bold'===$site_title_style ? 'font-weight: bold;' : ''),
    ('italic'===$site_title_style ? 'font-style: italic;' : ''),
    ('italicbold'===$site_title_style ? 'font-weight: bold; font-style: italic;' : ''),
    ('uppercase'===$site_title_style ? 'text-transform: uppercase;' : ''),
    ('uppercasebold'===$site_title_style ? 'font-weight: bold; text-transform: uppercase;' : ''));
?>
} /*min-width: 981px*/
@media only screen and (max-width: 980px) {
<?php if (14 !==$ss_body_font_size) { ?>
body{
	font-size: <?php echo esc_html($ss_body_font_size);?>px;
}
<?php if (true===get_theme_mod('body_font_include', false)) { ?>
.mh-breadcrumb, 
.post-meta p,
.post-meta.post-meta-alt p {
	font-size: <?php echo esc_html(intval($ss_body_font_size * 0.9)); ?>px;
}
<?php } } //if (14 !==$ss_body_font_size)
if (1.7 !==$ss_body_font_height) { ?>
body, p {
	line-height: <?php echo esc_html($ss_body_font_height);?>em;
}
<?php }
if (26 !==$ss_site_title_size) { ?>
#main-header .header-name{
	font-size: <?php echo esc_html($ss_site_title_size);?>px;
}
<?php
}
if (26 !==$ss_h1_font_size) { ?>
#mh-main-area h1 {
	font-size: <?php echo esc_html($ss_h1_font_size);?>px;
}
#mh-main-area h2 {
	font-size: <?php echo esc_html(intval($ss_h1_font_size * .85));?>px;
}
#mh-main-area h3 {
	font-size: <?php echo esc_html(intval($ss_h1_font_size * .77));?>px;
}
#mh-main-area h4 {
	font-size: <?php echo esc_html(intval($ss_h1_font_size * .7));?>px;
}
#mh-main-area h5 {
	font-size: <?php echo esc_html(intval($ss_h1_font_size * .6));?>px;
}
#mh-main-area h6 {
	font-size: <?php echo esc_html(intval($ss_h1_font_size * .53));?>px;
}
<?php }
if (1.4 !==$ss_h1_font_height) { ?>
#mh-main-area h1,
#mh-main-area h2,
#mh-main-area h3,
#mh-main-area h4,
#mh-main-area h5,
#mh-main-area h6 {
	line-height: <?php echo esc_html($ss_h1_font_height); ?>em;
}

<?php }
if ('14' !==$ss_app_nav_font_size) { ?>
.app-nav {
	font-size: <?php echo esc_html($ss_app_nav_font_size);?>px;
}
.app-nav .mhc-menu-desc {
	font-size: <?php echo esc_html(intval($ss_app_nav_font_size * .87));?>px;
}
<?php } ?>
}/*max-width: 980px*/   
.um a.um-link,
.um .um-tip:hover,
.um .um-field-radio.active:not(.um-field-radio-state-disabled) i,
.um .um-field-checkbox.active:not(.um-field-radio-state-disabled) i,
.um .um-member-name a:hover,
.um .um-member-more a:hover,
.um .um-member-less a:hover,
.um .um-members-pagi a:hover,
.um .um-cover-add:hover,
.um .um-profile-subnav a.active,
.um .um-item-meta a,
.um-account-name a:hover,
.um-account-nav a.current,
.um-account-side li a.current span.um-account-icon,
.um-account-side li a.current:hover span.um-account-icon,
.um-dropdown li a:hover,
i.um-active-color,
span.um-active-color,
.um-profile.um .um-profile-headericon a:hover, .um-profile.um .um-profile-edit-a.active
{
color: <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>!important;
}
.um .um-field-group-head,
.picker__box,
.picker__nav--prev:hover,
.picker__nav--next:hover,
.um .um-members-pagi span.current,
.um .um-members-pagi span.current:hover,
.um .um-profile-nav-item.active a,
.um .um-profile-nav-item.active a:hover,
.upload,
.um-finish-upload,
.um-modal-btn,
.um-request-button,
.um-modal-header,
.um-modal-btn.disabled,
.um-modal-btn.disabled:hover,
div.uimob800 .um-account-side li a.current,
div.uimob800 .um-account-side li a.current:hover,
.um .um-button,
.um a.um-button,
.um a.um-button.um-disabled:hover,
.um a.um-button.um-disabled:focus,
.um a.um-button.um-disabled:active,
.um input[type=submit].um-button,
.um input[type=submit].um-button:focus,
.um input[type=submit]:disabled:hover
{
background:  <?php echo esc_html(get_theme_mod('accent_color', '#4FD4FF')); ?>!important;
}
<?php if ('15' !== get_theme_mod('menu_padding', '15')) {
$menu_padding = absint( get_theme_mod( 'menu_padding', '15' ) );
?>
@media only screen and (min-width: 981px) {
  #top-menu > li{
    padding: 0 <?php echo esc_html(intval($menu_padding));?>px;
  }
  #mh_top_search,
  .mh-top-cta,
  .mh_cart_wrapper,
  .mobile-menu-trigger-icon{
    <?php if (is_rtl()) { ?>
    margin-right: <?php echo esc_html(intval($menu_padding * .87));?>px;
    <?php }else{?>
    margin-left: <?php echo esc_html(intval($menu_padding * .87));?>px;
  <?php } //is_rtl ?>
  }
}
<?php } ?>
<?php if ('8' !== get_theme_mod('mobile_menu_padding', '8')) {
$mobile_menu_padding = absint( get_theme_mod( 'mobile_menu_padding', '8' ) );
?>
@media only screen and (max-width: 980px) {
  #mh_top_search,
  .mh-top-cta,
  .mh_cart_wrapper,
  .mobile-menu-trigger-icon{
    <?php if (is_rtl()) { ?>
    margin-right: <?php echo esc_html(intval($mobile_menu_padding));?>px;
    <?php }else{?>
    margin-left: <?php echo esc_html(intval($mobile_menu_padding));?>px;
  <?php } //is_rtl ?>
  }
}
<?php } ?>
  
<?php 
//force hide elements when beta is disabled
// small fixes for non beta features
//if (false == mh_get_option( 'mharty_beta', false)){ ?>
<?php  //} ?>

/*Customizer Custom CSS*/
<?php
echo stripslashes( get_theme_mod( 'customizer_custom_css') );
echo '</style>';

//Fonts
$mh_gf_heading_font = sanitize_text_field( get_theme_mod( 'heading_font', 'none' ) );
$mh_gf_body_font = sanitize_text_field( get_theme_mod( 'body_font', 'none' ) );
$mh_language_fonts = mh_get_language_fonts();
$mh_default_fonts = mh_get_default_fonts();
$site_locale = get_locale();
$menu_font =  get_theme_mod( 'menu_font', 'header' );
$secondary_nav_font = get_theme_mod( 'secondary_nav_font', 'body' );
$app_menu_font = get_theme_mod( 'app_menu_font', 'body' );
$footer_font = get_theme_mod( 'footer_font', 'body' );

echo '<style class="mh_font_css">';	
	if ( 'none' == $mh_gf_body_font){
		if ( isset( $mh_language_fonts[$site_locale] )) {	
			printf( '%s%s%s%s%s { font-family: %s; }',
				'body, input, textarea, select, .single_add_to_cart_button .button, .mhc_newsletter_form p input, .mfp-close, .mfp-image-holder .mfp-close, .mfp-iframe-holder .mfp-close, .orderby, .widget_search #searchsubmit, .mh-reviews-meta-score',
				('header' !== $menu_font ? ', #top-menu li .menu-item-link, #top-menu .megamenu-title, #top-menu h3, .mh-top-cta a' : ''),
				('body' === $secondary_nav_font ? ', #top-header, #top-header h3' : ''),
				('body' === $app_menu_font ? ', .mh-app-nav, .mh-app-nav h3' : ''),
				('body' === $footer_font ? ', #mh-footer-nav, #mh-footer-nav h3, #footer-bottom' : ''),
				sanitize_text_field( $mh_language_fonts[$site_locale]['body'] )
			);
		}else{
			printf( '%s%s%s%s%s { font-family: %s; }',
				'body, input, textarea, select, .single_add_to_cart_button .button, .mhc_newsletter_form p input, .mfp-close, .mfp-image-holder .mfp-close, .mfp-iframe-holder .mfp-close, .orderby, .widget_search #searchsubmit, .mh-reviews-meta-score',
				('header' !== $menu_font ? ', #top-menu li .menu-item-link, #top-menu .megamenu-title, #top-menu h3, .mh-top-cta a' : ''),
				('body' === $secondary_nav_font ? ', #top-header, #top-header h3' : ''),
				('body' === $app_menu_font ? ', .mh-app-nav, .mh-app-nav h3' : ''),
				('body' === $footer_font ? ', #mh-footer-nav, #mh-footer-nav h3, #footer-bottom' : ''),
				sanitize_text_field( $mh_default_fonts['body']['font_family'] )
			);
		}
	}else{
		mh_gf_attach_font( $mh_gf_body_font, 'body, input, textarea, select, .single_add_to_cart_button .button, .mhc_newsletter_form p input, .mfp-close, .mfp-image-holder .mfp-close, .mfp-iframe-holder .mfp-close, .orderby, .widget_search #searchsubmit, .mh-reviews-meta-score' );
		if ('header' !== $menu_font ) mh_gf_attach_font( $mh_gf_body_font, '#top-menu li .menu-item-link, #top-menu .megamenu-title, #top-menu h3, .mh-top-cta a');
		if ('body' === $secondary_nav_font) mh_gf_attach_font( $mh_gf_body_font, '#top-header, #top-header h3');
		if ('body' === $app_menu_font) mh_gf_attach_font( $mh_gf_body_font, '.mh-app-nav, .mh-app-nav h3');
		if ('body' === $footer_font) mh_gf_attach_font( $mh_gf_body_font, '#mh-footer-nav, #mh-footer-nav h3, #footer-bottom');
	}
	
	if ( 'none' == $mh_gf_heading_font){
		if ( isset( $mh_language_fonts[$site_locale] )) {
			printf( '%s%s%s%s%s { font-family: %s; }',
				'h1, h2, h3, h4, h5, h6, #main-header .header-name, .mhc_pricing_menus_item_title, .mhc_pricing_menus_item_price, .mhc_currency_sign, .mhc_testimonial_author, .mhc_testimonials_slide_author, .mh_quote_content blockquote, span.fn, span.fn a, #main-header .header-tagline, .mh-font-heading, .postnav-title, ul.post_share_footer.mh_share_name_icon li a .post_share_item_title, .header-font-family, #review_form .comment-reply-title',
				('header' === $menu_font ? ', #top-menu li .menu-item-link, #top-menu .megamenu-title, #top-menu h3, .mh-top-cta a' : ''),
				('body' !== $secondary_nav_font ? ', #top-header, #top-header h3' : ''),
				('body' !== $app_menu_font ? ', .mh-app-nav, .mh-app-nav h3' : ''),
				('body' !== $footer_font ? ', #mh-footer-nav, #mh-footer-nav h3, #footer-bottom' : ''),
				sanitize_text_field( $mh_language_fonts[$site_locale]['h'] )
			);
		}else{
			printf( '%s%s%s%s%s { font-family: %s; }',
				'h1, h2, h3, h4, h5, h6, #main-header .header-name, .mhc_pricing_menus_item_title, .mhc_pricing_menus_item_price, .mhc_currency_sign, .mhc_testimonial_author, .mhc_testimonials_slide_author, .mh_quote_content blockquote, span.fn, span.fn a, #main-header .header-tagline, .mh-font-heading, .postnav-title, ul.post_share_footer.mh_share_name_icon li a .post_share_item_title, .header-font-family, #review_form .comment-reply-title',
				('header' === $menu_font ? ', #top-menu li .menu-item-link, #top-menu .megamenu-title, #top-menu h3, .mh-top-cta a' : ''),
				('body' !== $secondary_nav_font ? ', #top-header, #top-header h3' : ''),
				('body' !== $app_menu_font ? ', .mh-app-nav, .mh-app-nav h3' : ''),
				('body' !== $footer_font ? ', #mh-footer-nav, #mh-footer-nav h3, #footer-bottom' : ''),
				sanitize_text_field( $mh_default_fonts['h']['font_family'] )
			);
		}	
	}else{
		mh_gf_attach_font( $mh_gf_heading_font, 'h1, h2, h3, h4, h5, h6, #main-header .header-name, .mhc_pricing_menus_item_title, .mhc_pricing_menus_item_price, .mhc_currency_sign, .mhc_testimonial_author, .mhc_testimonials_slide_author, .mh_quote_content blockquote, span.fn, span.fn a, #main-header .header-tagline, .mh-font-heading, .postnav-title, ul.post_share_footer.mh_share_name_icon li a .post_share_item_title, .header-font-family, #review_form .comment-reply-title' );
		if ('header' === $menu_font ) mh_gf_attach_font( $mh_gf_heading_font, '#top-menu li .menu-item-link, #top-menu .megamenu-title, #top-menu h3, .mh-top-cta a');
		if ('body' !== $secondary_nav_font) mh_gf_attach_font( $mh_gf_heading_font, '#top-header, #top-header h3');
		if ('body' !== $app_menu_font) mh_gf_attach_font( $mh_gf_heading_font, '.mh-app-nav, .mh-app-nav h3');
		if ('body' !== $footer_font) mh_gf_attach_font( $mh_gf_heading_font, '#mh-footer-nav, #mh-footer-nav h3, #footer-bottom');
	}
echo '</style>';
 }
add_action( 'wp_head', 'mh_mharty_add_customizer_css' );
//add_action( 'customize_controls_print_styles', 'mh_mharty_add_customizer_css' );