<?php

// Exit if accessed directly.
if ( !defined( 'ABSPATH' ) )exit;

if ( !class_exists( 'MH_Admin_Menu' ) ) {

  /**
   * Class MH_Admin_Menu
   */
  class MH_Admin_Menu {

    protected static $fields = array();

    function __construct() {
      global $wp_version;

      self::$fields = array(
        'menu_icon' => __( 'Menu Item Icon', 'mharty' ),
        'highlight' => __( 'Highlight', 'mharty' ),
        'megamenu' => __( 'Mega Menu', 'mharty' ),
        'megamenu_background' => __( 'Set Background Image', 'mharty' ),
        'megamenu_styles' => __( 'Mega Menu Custom CSS', 'mharty' )
      );

      add_action( 'wp_update_nav_menu_item', array( & $this, '_save' ), 10, 3 );
      add_action( 'wp_nav_menu_item_custom_fields', array( $this, 'wp_nav_menu_item_custom_fields' ), 20, 5 );
      //add_action( 'load-nav-menus.php', array( & $this, 'enqueue_nav_menus_scripts' ) );

    }

    function wp_nav_menu_item_custom_fields( $item_id, $item, $depth, $args, $id ) {
			$class = '';
      $menu_icon = get_post_meta( $item->ID, '_menu_item_menu_icon', true );
      $highlight = get_post_meta( $item->ID, '_menu_item_highlight', true );
      $megamenu = get_post_meta( $item->ID, '_menu_item_megamenu', true );
      $megamenu_background = get_post_meta( $item->ID, '_menu_item_megamenu_background', true );
      $megamenu_styles = get_post_meta( $item->ID, '_menu_item_megamenu_styles', true );
			if ( 0 !== strpos( $menu_icon, 'http://' ) && 0 !== strpos( $menu_icon, 'https://' ) && !preg_match_all( '/(<svg[^>]+>)/i', $menu_icon ) ) {
				$menu_icon_value = '' !== $menu_icon ? '<span class="mh-menu-icon-show"><em>&#x' . $menu_icon . ';</em></span>': '<span class="mh-menu-icon-show mh-menu-icon-button" title="' . esc_html__("Choose Icon", "mharty") . '"></span>';
      }elseif ( preg_match_all( '/(<svg[^>]+>)/i', $menu_icon ) ) {
        $menu_icon_value = '' !== $menu_icon ? '<span class="mh-menu-icon-show"><span class="mh-menu-svg">' . $menu_icon . '</span></span>': '<span class="mh-menu-icon-show mh-menu-icon-button" title="' . esc_html__("Choose Icon", "mharty") . '"></span>';
				$class = 'field-menu-icon-image';
			}else{
				$menu_icon_value = '' !== $menu_icon ? '<span class="mh-menu-icon-show"><img src="' . $menu_icon . '"></span>': '<span class="mh-menu-icon-show mh-menu-icon-button" title="' . esc_html__("Choose Icon", "mharty") . '"></span>';
				$class = 'field-menu-icon-image';
			}
      
      ?>
<div class="mh-nav-edit">
	<div class="mh-nav-edit-inner">
  <h4 class="mh-menu-settings-title">
    <?php _e( 'Theme Settings', 'mharty' ) ?>
  </h4>
  <p class="field-menu-icon description-wide <?php echo $class; ?>">
    <label for="edit-menu-item-target-<?php echo $item_id; ?>">
      <?php esc_html_e( 'Menu Item Icon', "mharty" ); ?><br />
      <?php /*?><span class="mh-menu-icon-button"><?php esc_html_e("Choose Icon", "mharty"); ?></span><?php */?>
			<?php echo $menu_icon_value; ?>
      <span class="mh-menu-icon-button-reset" title="<?php esc_html_e("Reset", "mharty"); ?>"></span>
			<span class="mh-menu-icon-button-show-field" title="<?php esc_html_e("Show field", "mharty"); ?>"></span>
      <br />
      <input class="widefat mh-menu-icon-field" type="text" id="edit-menu-item-menu-icon-<?php echo $item_id; ?>" name="menu-item-menu_icon[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $menu_icon ); ?>" />
			<span class="mh-menu-icon-field-desc mh-nav-edit-desc"><?php esc_html_e( 'Alternatively, you could input your image URL here.', "mharty" ); ?></span>
			
    </label>
  </p>
		<p class="field-menu-icon-pending description-wide <?php echo $class; ?>"><?php esc_html_e("Save Menu before choosing an icon", "mharty"); ?></p>
  <p class="field-highlight-checkbox description-wide">
    <?php

    $value = get_post_meta( $item->ID, '_menu_item_highlight', true );
    if ( $value != "" )$value = "checked='checked'";

    ?>
    <label for="edit-menu-item-highlight-<?php echo $item_id; ?>">
      <input type="checkbox" value="enabled" class="edit-menu-item-mh-highlight-check" id="edit-menu-item-highlight-<?php echo $item_id; ?>" name="edit-menu-item-highlight[<?php echo $item_id; ?>]" <?php echo $value; ?> />
      <em>
      <?php esc_html_e( 'Highlight', "mharty" ); ?>
      </em> </label>
  </p>
  <?php if($depth === 0) { ?>
  <p class="field-megamenu-checkbox description-wide">
    <?php

    $value = get_post_meta( $item->ID, '_menu_item_megamenu', true );
    if ( $value != "" )$value = "checked='checked'";

    ?>
    <label for="edit-menu-item-megamenu-<?php echo $item_id; ?>">
      <input type="checkbox" value="enabled" class="edit-menu-item-mh-megamenu-check" id="edit-menu-item-megamenu-<?php echo $item_id; ?>" name="edit-menu-item-megamenu[<?php echo $item_id; ?>]" <?php echo $value; ?> />
      <em>
      <?php esc_html_e( 'Mega Menu', "mharty" ); ?>
      </em> </label>
  </p>
  <a href="#" id="mh-media-upload-<?php echo $item_id; ?>" class="mh-open-media button button-primary mh-megamenu-upload-background description-wide">
  <?php esc_html_e( 'Set Background Image', 'mharty' ); ?>
  </a>
  <p class="field-megamenu-background description-wide">
    <label for="edit-menu-item-megamenu-background-<?php echo $item_id; ?>">
      <input type="hidden" id="edit-menu-item-megamenu-background-<?php echo $item_id; ?>" class="mh-new-media-image widefat code edit-menu-item-megamenu-background" name="menu-item-megamenu-background[<?php echo $item_id; ?>]" value="<?php echo $megamenu_background; ?>" />
      <img src="<?php echo $megamenu_background; ?>" id="mh-media-img-<?php echo $item_id; ?>" class="mh-megamenu-background-image" style="<?php echo ( trim( $megamenu_background ) ) ? 'display: inline;' : '';?>" /> <a href="#" id="mh-media-remove-<?php echo $item_id; ?>" class="remove-mh-megamenu-background" style="<?php echo ( trim( $megamenu_background ) ) ? 'display: inline;' : '';?>">Remove Image</a> </label>
  </p>
  <p class="field-megamenu-styles description-wide">
    <label for="edit-menu-item-megamenu-styles-<?php echo $item_id; ?>">
      <?php esc_html_e( 'Mega Menu Custom CSS', "mharty" ); ?>
      <br />
      <textarea id="edit-menu-item-megamenu-styles-<?php echo $item_id; ?>" class="widefat edit-menu-item-megamenu-styles" dir="ltr" rows="3" cols="20" name="menu-item-megamenu-styles[<?php echo $item_id; ?>]"><?php echo esc_html( $megamenu_styles ); // textarea_escaped ?></textarea>
      <span class="description mh-nav-edit-desc">
      <?php esc_html_e('Here you could add custom css styles for your Mega Menu e.g.', "mharty"); ?>
      </span> <code>background-position: left bottom; background-repeat: no-repeat;</code> </label>
  </p>
  <?php } //$depth ?>
		</div>
</div>
<?php
}

function _save( $menu_id, $menu_item_db_id, $menu_item_args ) {
  if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
    return;
  }

  if ( empty( $_POST[ 'menu-item-db-id' ] ) || !in_array( $menu_item_db_id, $_POST[ 'menu-item-db-id' ] ) ) {
    return;
  }

  if ( !isset( $_REQUEST[ 'menu-item-menu_icon' ][ $menu_item_db_id ] ) ) {
    $_REQUEST[ 'menu-item-menu_icon' ][ $menu_item_db_id ] = '';

  }
  $menu_mega_enabled_value = $_REQUEST[ 'menu-item-menu_icon' ][ $menu_item_db_id ];
  update_post_meta( $menu_item_db_id, '_menu_item_menu_icon', $menu_mega_enabled_value );


  if ( !isset( $_REQUEST[ 'edit-menu-item-highlight' ][ $menu_item_db_id ] ) ) {
    $_REQUEST[ 'edit-menu-item-highlight' ][ $menu_item_db_id ] = '';

  }
  $menu_mega_enabled_value = $_REQUEST[ 'edit-menu-item-highlight' ][ $menu_item_db_id ];
  update_post_meta( $menu_item_db_id, '_menu_item_highlight', $menu_mega_enabled_value );


  if ( !isset( $_REQUEST[ 'edit-menu-item-megamenu' ][ $menu_item_db_id ] ) ) {
    $_REQUEST[ 'edit-menu-item-megamenu' ][ $menu_item_db_id ] = '';

  }
  $menu_mega_enabled_value = $_REQUEST[ 'edit-menu-item-megamenu' ][ $menu_item_db_id ];
  update_post_meta( $menu_item_db_id, '_menu_item_megamenu', $menu_mega_enabled_value );


  if ( !isset( $_REQUEST[ 'menu-item-megamenu-background' ][ $menu_item_db_id ] ) ) {
    $_REQUEST[ 'menu-item-megamenu-background' ][ $menu_item_db_id ] = '';

  }
  $mega_menu_background_value = $_REQUEST[ 'menu-item-megamenu-background' ][ $menu_item_db_id ];
  update_post_meta( $menu_item_db_id, '_menu_item_megamenu_background', $mega_menu_background_value );


  if ( !isset( $_REQUEST[ 'menu-item-megamenu-styles' ][ $menu_item_db_id ] ) ) {
    $_REQUEST[ 'menu-item-megamenu-styles' ][ $menu_item_db_id ] = '';

  }
  $mega_menu_styles_value = $_REQUEST[ 'menu-item-megamenu-styles' ][ $menu_item_db_id ];
  update_post_meta( $menu_item_db_id, '_menu_item_megamenu_styles', $mega_menu_styles_value );


}

}
}
new MH_Admin_Menu;