<?php
if ( !defined( 'ABSPATH' ) )exit;
/**
 * Custom Walker
 */
if ( !class_exists( 'mharty_walker' ) ) {
  class mharty_walker extends Walker_Nav_Menu {
    /**
     * @var int $columns 
     */
    var $columns = 0;
    var $max_columns = 0;
    var $rows = 1;
    var $rowsCounter = array();
    var $mega_active = 0;


    /**
     * @see Walker::start_lvl()
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int $depth Depth of page. Used for padding.
     */
    function start_lvl( & $output, $depth = 0, $args = array() ) {
      $indent = str_repeat( "\t", $depth );

      $style = '';

      if ( $depth === 0 && $this->active_megamenu ) {

        $style .= !empty( $this->megamenu_background ) ? ( 'Background-image:url(' . $this->megamenu_background . ');' ) : '';
        $style .= !empty( $this->megamenu_styles ) ? $this->megamenu_styles : '';
      }

      $output .= "\n$indent<ul style=\"$style\" class=\"sub-menu {locate_class}\">\n";


    }

    /**
     * @see Walker::end_lvl()
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int $depth Depth of page. Used for padding.
     */
    function end_lvl( & $output, $depth = 0, $args = array() ) {
      $indent = str_repeat( "\t", $depth );
      $output .= "$indent</ul>\n";

      if ( $depth === 0 ) {
        if ( $this->active_megamenu ) {

          $output = str_replace( "{locate_class}", "mega-col-" . $this->max_columns . "", $output );

          foreach ( $this->rowsCounter as $row => $columns ) {
            $output = str_replace( "{current_row_" . $row . "}", "mega-col-" . $columns, $output );
          }

          $this->columns = 0;
          $this->max_columns = 0;
          $this->rowsCounter = array();

        } else {
          $output = str_replace( "{locate_class}", "", $output );
        }
      }
    }

    function start_el( & $output, $item, $depth = 0, $args = array(), $current_object_id = 0 ) {
      global $wp_query;


      $item_output = $li_text_block_class = $column_class = $the_item_image = "";
      $this->megamenu_background = get_post_meta( $item->ID, '_menu_item_megamenu_background', true );
      $this->megamenu_styles = get_post_meta( $item->ID, '_menu_item_megamenu_styles', true );


      if ( $depth === 0 ) {
        $this->active_megamenu = get_post_meta( $item->ID, '_menu_item_megamenu', true );

        if ( $this->active_megamenu ) {
          $column_class .= " mega-menu";
        } else {
          $column_class .= " no-mega-menu";
        }

      }

      if ( $depth === 1 && $this->active_megamenu ) {
        $this->columns++;


        $this->rowsCounter[ $this->rows ] = $this->columns;

        if ( $this->max_columns < $this->columns )$this->max_columns = $this->columns;

        $column_class = ' {current_row_' . $this->rows . '}';

        if ( $this->columns == 1 ) {
          $column_class .= " mh_mega_first";
        }


        $title = apply_filters( 'the_title', $item->title, $item->ID );
        if ( $title != "#" && $title != '"#"' ) {
          $item_menu_icon_content = get_post_meta( $item->ID, '_menu_item_menu_icon', true );
          $maybe_img_icon_svg_output = '';
          if ( !empty( $item_menu_icon_content ) ) {
            if ( preg_match_all( '/^.+?\.(jpg|jpeg|jpe|png|gif|svg)/', $item_menu_icon_content ) ) {
              $maybe_img_icon_svg_output .= '<span class="mhc-menu-image"><img src="' . esc_attr( $item_menu_icon_content ) . '"></span>';
            } elseif ( preg_match_all( '/(<svg[^>]+>)/i', $item_menu_icon_content ) ) {
              $maybe_img_icon_svg_output .= '<span class="mhc-menu-image">' . $item_menu_icon_content . '</span>';
            } else {
              $maybe_img_icon_svg_output .= '<i aria-hidden="true" data-icon="&#x' . esc_attr( $item_menu_icon_content ) . ';" class="mhc-menu-icon"></i>';
            }

          }

          $the_item_desc = $item->description;
          if ( !empty( $item->description ) ) {
            if ( preg_match_all( '/^.+?\.(jpg|jpeg|jpe|png|gif|svg)/', $the_item_desc ) ) {
              $the_item_image = '<img src="' . esc_url( $the_item_desc ) . '">';
            } else {
              $the_item_desc = '<span class="mhc-menu-desc">' . $item->description . '</span>';

            }
          }
          $the_item_class = '' != $the_item_image ? ' mhc-menu-item-link-has-img' : '';

          $attributes = !empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) . '"': '';

          $item_output .= $args->before;
          $item_output .= '<div class="megamenu-title' . $the_item_class . '"' . $attributes . '>';
          $item_output .= $maybe_img_icon_svg_output;
          $item_output .= '<div class="mhc-menu-item-link-content">';
          $item_output .= $the_item_image;
          $item_output .= $args->link_before . '<h3 class="mhc-menu-item-link-head">' . apply_filters( 'the_title', $item->title, $item->ID ) . '</h3>' . $args->link_after;;
          $item_output .= '' === $the_item_image ? $the_item_desc : '';
          $item_output .= '</div>';
          $item_output .= '</div>';
          $item_output .= $args->after;
        }

      } else {

        $item_menu_icon_content = get_post_meta( $item->ID, '_menu_item_menu_icon', true );
        $maybe_img_icon_svg_output = '';
        if ( !empty( $item_menu_icon_content ) ) {
          if ( preg_match_all( '/^.+?\.(jpg|jpeg|jpe|png|gif|svg)/', $item_menu_icon_content ) ) {
            $maybe_img_icon_svg_output .= '<span class="mhc-menu-image"><img src="' . esc_attr( $item_menu_icon_content ) . '"></span>';
          } elseif ( preg_match_all( '/(<svg[^>]+>)/i', $item_menu_icon_content ) ) {
            $maybe_img_icon_svg_output .= '<span class="mhc-menu-image">' . $item_menu_icon_content . '</span>';
          } else {
            $maybe_img_icon_svg_output .= '<i aria-hidden="true" data-icon="&#x' . esc_attr( $item_menu_icon_content ) . ';" class="mhc-menu-icon"></i>';
          }

        }

        $the_item_desc = $item->description;
        if ( !empty( $item->description ) ) {
          if ( preg_match_all( '/^.+?\.(jpg|jpeg|jpe|png|gif|svg)/', $the_item_desc ) ) {
            $the_item_image = '<img src="' . esc_attr( $the_item_desc ) . '">';
          } else {
            $the_item_desc = '<span class="mhc-menu-desc">' . $item->description . '</span>';

          }
        }
        $the_item_class = '' != $the_item_image ? ' mhc-menu-item-link-has-img' : '';

        $attributes = !empty( $item->attr_title ) ? ' title="' . esc_attr( $item->attr_title ) . '"': '';
        $attributes .= !empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"': '';
        $attributes .= !empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) . '"': '';
        $attributes .= !empty( $item->url ) ? ' href="' . esc_attr( $item->url ) . '"': '';

        $item_output .= $args->before;
        $item_output .= '<a class="menu-item-link' . $the_item_class . '" ' . $attributes . '>';
        $item_output .= $maybe_img_icon_svg_output;
        $item_output .= '<div class="mhc-menu-item-link-content">';
        $item_output .= $the_item_image;
        $item_output .= $args->link_before . '<h3 class="mhc-menu-item-link-head">' . apply_filters( 'the_title', $item->title, $item->ID ) . '</h3>' . $args->link_after;
        $item_output .= '' === $the_item_image ? $the_item_desc : '';
        $item_output .= '</div>';
        $item_output .= '</a>';
        $item_output .= $args->after;
      }

      $button_class = get_post_meta( $item->ID, '_menu_item_highlight', true ) ? ' mhc-menu-highlight' : '';

      $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
      $class_names = $value = '';

      $classes = empty( $item->classes ) ? array() : ( array )$item->classes;

      $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
      $class_names = ' class="' . $li_text_block_class . esc_attr( $class_names ) . $button_class . $column_class . ' menu-item-' . $item->ID . '"';
      $output .= $indent . '<li ' . $value . $class_names . '>';
      $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }
  }
}