<?php
if (!function_exists('mh_mharty_get_top_nav_items')) {
    function mh_mharty_get_top_nav_items() {
        $items = new stdClass;
        $items->show_header_date = ('1' === get_theme_mod('show_header_date', '0'));
        $items->header_phrase = ('' !== get_theme_mod('header_phrase', ''));
        $items->phone_number = ('' !== get_theme_mod('phone_number', ''));
        $items->email = ('' !== get_theme_mod('header_email', ''));
        $items->contact_info_defined = $items->phone_number || $items->email || $items->header_phrase || $items->show_header_date;
        $items->show_header_social_icons = ('1' === get_theme_mod('show_header_social_icons', '0'));
        $items->secondary_nav = wp_nav_menu([
            'theme_location' => 'secondary-menu',
            'container' => '',
            'menu_id' => 'mh-secondary-nav',
            'echo' => false,
            'fallback_cb' => '',
            'walker' => new mharty_walker,
        ]);

        $items->top_info_defined = $items->contact_info_defined || $items->show_header_social_icons || $items->secondary_nav;
        $items->two_info_panels = $items->contact_info_defined && ($items->show_header_social_icons || $items->secondary_nav);
        $items->promo = ('1' === get_theme_mod('show_promo_bar', '0') && '' !== get_theme_mod('promo_bar_text', ''));
        return $items;
    }
}

add_action('mh_main_navigation', 'mh_add_main_navigation');
if (!function_exists('mh_add_main_navigation')) {
    function mh_add_main_navigation() {
        $animation_class = 'off' !== ($animation = get_theme_mod('header_animation', 'off')) ? ' mhc_animation_' . $animation . ' mh-animated': '';
        $menuClass = 'nav' . esc_html($animation_class);
        if (true == mh_get_option('mharty_disable_toptier')) {
            $menuClass .= ' mh_disable_top_tier';
        }
        $primaryNav = '';
        $primaryNav = wp_nav_menu([
            'theme_location' => 'primary-menu',
            'container' => 'nav',
            'container_id' => 'top-menu-nav',
            'container_class' => 'main_menu',
            'menu_class' => $menuClass,
            'menu_id' => 'top-menu',
            'echo' => false,
            'fallback_cb' => 'link_to_menu_editor',
            'walker' => new mharty_walker,
        ]);
        if (true !== get_theme_mod('hide_nav_menu', false)) {
            if ('' !== $primaryNav) {
                echo($primaryNav);

            }
        } // hide_nav_menu
    }
}

if (!function_exists('mh_header_menu')) {
    function mh_header_menu() {

        //hide header on blank & no-header templates
        if (is_page_template('page-template-blank.php') || is_page_template('page-template-noheader.php') || (is_single() && ('mh_post_noheader' === get_post_meta(get_the_ID(), '_mhc_post_custom_template', true))) || (is_single() && ('mh_post_blank' === get_post_meta(get_the_ID(), '_mhc_post_custom_template', true)))) {
            return;
        }
        echo '<div class="header-container">';
        $mh_secondary_nav_items = mh_mharty_get_top_nav_items();
        $show_header_date = $mh_secondary_nav_items->show_header_date;
        $mh_custom_phrase = $mh_secondary_nav_items->header_phrase;
        $mh_phone_number = $mh_secondary_nav_items->phone_number;
        $mh_email = $mh_secondary_nav_items->email;
        $mh_contact_info_defined = $mh_secondary_nav_items->contact_info_defined;
        $show_header_social_icons = $mh_secondary_nav_items->show_header_social_icons;
        $mh_secondary_nav = $mh_secondary_nav_items->secondary_nav;
        if ('' !== ($primary_nav_text_color = get_theme_mod('primary_nav_text_color', 'dark'))):
            $primary_nav_class = 'mh_nav_text_color_' . $primary_nav_text_color;
        endif;
        if ('' !== ($primary_subnav_text_color = get_theme_mod('primary_subnav_text_color', 'dark'))):
            $primary_subnav_class = ' mh_subnav_text_color_' . $primary_subnav_text_color;
        endif;
        if ('' !== ($secondary_nav_text_color = get_theme_mod('secondary_nav_text_color', 'light'))):
            $secondary_nav_class = 'mh_nav_text_color_' . $secondary_nav_text_color;
        endif;
        $mh_top_info_defined = $mh_secondary_nav_items->top_info_defined;
        $promo_hide_logged_in = is_user_logged_in() && '0' === get_theme_mod('promo_bar_logged_in', '1');
        $promo = $mh_secondary_nav_items->promo && !$promo_hide_logged_in;
        $promo_class = (!$mh_top_info_defined && (true === $promo)) ? ' mh-has-promo-only' : '';
        $promo_class .= ($mh_top_info_defined && (true === $promo)) ? ' mh-has-promo' : '';
        $promo_output = sprintf(
            '<div class="mh-promo mhc_animation_%4$s mh-animated"%3$s><div class="container clearfix"><div class="mh-promo-inner"><p>%1$s</p>%2$s</div></div><div class="mh-promo-close mh-icon-before"></div></div>',
            esc_attr(get_theme_mod('promo_bar_text', '')), //1
            '' !== get_theme_mod('promo_bar_button_text', '') ? sprintf(
                ' <a class ="mh-promo-button mh_adjust_corners" href="%2$s">%1$s</a>',
                esc_attr(get_theme_mod('promo_bar_button_text', '')),
                '' !== get_theme_mod('promo_bar_button_url', '') ? esc_attr(get_theme_mod('promo_bar_button_url', '')) : '#'
            ) : '', //2
            false !== get_theme_mod('show_promo_bar_once', false) ? 'data-once="true"' : '', //3
            esc_attr(get_theme_mod('promo_bar_animation', 'top'))
        );
        $animation_class = 'off' !== ($animation = get_theme_mod('header_animation', 'off')) ? ' mhc_animation_' . $animation . ' mh-animated': '';

        if (!$mh_top_info_defined && true === $promo): ?>
<div id="top-header" class="<?php echo esc_html($secondary_nav_class . $promo_class);?>"> <?php echo $promo_output; ?> </div>
<!-- #top-header -->
<?php elseif (('1' == get_theme_mod('secondary_nav_position', '0') && $mh_top_info_defined) || $mh_top_info_defined && is_page_template('page-template-trans.php')) : ?>
<div id="top-header" class="<?php echo esc_html($secondary_nav_class . $promo_class);?>">
  <?php if (true === $promo) {
      echo $promo_output;
  }  ?>
  <div class="container clearfix">
    <?php if ($mh_contact_info_defined) : ?>
    <div id="mh-info">
      <?php
      if (true === $show_header_date):
          $date = '' !== get_theme_mod('mharty_header_date_format') ? get_theme_mod('mharty_header_date_format', 'd/m/Y') : 'd/m/Y';
          ?>
      <span class="mh-info-item mh-info-date mh-icon-before mh-icon-after"><?php echo date_i18n($date, time()); ?></span>
      <?php endif; ?>
      <?php if ('' !== ($mh_custom_phrase = get_theme_mod('header_phrase', ''))) : ?>
      <span class="mh-info-item mh-info-custom-text mh-icon-before mh-icon-after"><?php echo mh_sanitize_text_input($mh_custom_phrase); ?></span>
      <?php endif; ?>
      <?php if ('' !== ($mh_phone_number = get_theme_mod('phone_number', ''))) : ?>
      <span class="mh-info-item mh-info-phone mh-icon-before mh-icon-after"><?php echo mh_sanitize_text_input($mh_phone_number); ?></span>
      <?php endif; ?>
      <?php if ('' !== ($mh_email = get_theme_mod('header_email', ''))) : ?>
      <a class="mh-info-item mh-info-email-url" href="<?php echo esc_html('mailto:' . $mh_email); ?>"><span class="mh-info-email mh-icon-before mh-icon-after"><?php echo esc_html($mh_email); ?></span></a>
      <?php endif; ?>
    </div>
    <!-- #mh-info -->
    <?php
    if (true === $show_header_social_icons) {
        get_template_part('includes/social_icons', 'header');
    }
        ?>
    <?php endif; // true === $mh_contact_info_defined?>
    <div id="mh-secondary-menu">
      <?php
          if (!$mh_contact_info_defined && true === $show_header_social_icons) {
              //echo '<div id="mh-info">';
              get_template_part('includes/social_icons', 'header');
              //echo '	</div> <!-- #mh-info -->';
          } elseif ($mh_contact_info_defined && true === $show_header_social_icons) {
              ob_start();

              get_template_part('includes/social_icons', 'header');

              $duplicate_social_icons = ob_get_contents();

              ob_end_clean();

              //	printf(
              //							'<div class="mh_duplicate_social_icons">
              //								%1$s
              //							</div>',
              //							$duplicate_social_icons
              //						);
          }

        if ('' !== $mh_secondary_nav) {
            echo $mh_secondary_nav;
        }
        ?>
      <?php
        if ('primary' !== get_theme_mod('shop_cart_position', 'primary')) {
            do_action('mh_header_mini_cart');
        }
        ?>
    </div>
    <!-- #mh-secondary-menu --> 
    
  </div>
  <!-- .container --> 
  
</div>
<!-- #top-header -->
<?php endif; // true ==== $mh_top_info_defined?>
<header id="main-header" class="<?php echo esc_html($primary_nav_class) . esc_html($primary_subnav_class); ?><?php if (is_page_template('page-template-trans.php')) {
    echo' transparent';
} ?><?php if ('top' === get_theme_mod('fixed_menu', 'off')) : echo ' sticky_nav'; endif;?>" itemscope itemtype="https://schema.org/WPHeader">
  <div class="container clearfix">
    <?php
    $template_uri = get_template_directory_uri();
        $logo = ($user_logo = get_theme_mod('mharty_logo')) && '' != $user_logo ?
          esc_url($user_logo) :
        $template_uri . '/images/logo.svg';
        $default_sticky_logo = ($user_logo = get_theme_mod('mharty_logo')) && '' != $user_logo ?
          esc_url($user_logo) : $template_uri . '/images/logo_icon.svg';
        //sticky logo
        $sticky_logo = ($sticky_user_logo = get_theme_mod('mharty_logo_sticky')) && '' != $sticky_user_logo ?
          esc_url($sticky_user_logo) :
          $default_sticky_logo;
        $extra_logo = get_theme_mod('mharty_extra_logo_img', '');
        ?>
    <a href="<?php echo esc_url(apply_filters('mh_logo_url_filter', home_url('/'))); ?>" class="mh_logo<?php if ('top' === get_theme_mod('fixed_menu', 'off') && '1' === get_theme_mod('mharty_logo_sticky_active', '0')) : echo ' has_sticky_logo'; endif;?>">
    <?php if (true !== get_theme_mod('use_logo_text', false)): ?>
    <img  src="<?php echo esc_url(apply_filters('mh_logo_filter', $logo)); ?>" alt="<?php echo esc_html(get_bloginfo('name')); ?>" id="logo" class="<?php echo esc_html($animation_class); ?>" width="<?php echo esc_attr(mh_get_image_width_height($logo, 'width')); ?>" height="<?php echo esc_attr(mh_get_image_width_height($logo, 'height')); ?>" />
    <?php if ('top' === get_theme_mod('fixed_menu', 'off') && '1' === get_theme_mod('mharty_logo_sticky_active', '0')) : ?>
    <img src="<?php echo esc_url(apply_filters('mh_logo_sticky_filter', $sticky_logo)); ?>" alt="<?php echo esc_html(get_bloginfo('name')); ?>" id="sticky_logo" width="<?php echo esc_attr(mh_get_image_width_height($sticky_logo, 'width')); ?>" height="<?php echo esc_attr(mh_get_image_width_height($sticky_logo, 'height')); ?>" />
    <?php endif; ?>
    <?php else: ?>
    <span class="header-name"><?php echo esc_html(get_bloginfo('name')); ?></span>
    <?php if (false !== get_theme_mod('title_tagline_show', true)) { ?>
      <span class="header-tagline"><?php echo esc_html(get_bloginfo('description')); ?></span>
    <?php } ?>
    <?php endif; ?>
    </a>
    <div class="mh-top-navigation-wrapper">
      <div id="mh-top-navigation">
        <?php do_action('mh_main_navigation');?>
        <div class="mh-top-navigation-icons<?php echo esc_html($animation_class); ?>">
          <?php
              $menu_cta = get_theme_mod('top_cta_text', '');
        $menu_cta_url = get_theme_mod('top_cta_url', '');
        $menu_cta_url_target = true === get_theme_mod('top_cta_url_target', false) ? ' target="_blank"' : '';
        $menu_cta_style = get_theme_mod('top_cta_style', 'button');
        $menu_cta_button_style = get_theme_mod('top_cta_button_style', 'solid');
        $menu_cta_title = '' != $menu_cta ? ' title="' . $menu_cta . '"': '';
        $menu_cta_content = 'icon' === $menu_cta_style ? '<i class="mh_top_cta_icon mh-icon-before"></i>' : mh_sanitize_text_input($menu_cta);
        $menu_cta_animation = get_theme_mod('top_cta_animation', 'off');
        $menu_cta_animation_class = ('off' !== $menu_cta_animation ?  sprintf(' mh-animated mhc_animation_%1$s', esc_attr($menu_cta_animation)) : '');
        if (true === get_theme_mod('show_top_cta', false) && '' != $menu_cta_url): ?>
          <div class="mh-top-cta mh-top-cta-1 mh-top-cta-<?php echo $menu_cta_style; ?> mh-cta-button-<?php echo $menu_cta_button_style . $menu_cta_animation_class; ?>"> <a class="mh_adjust_corners" href="<?php echo esc_url($menu_cta_url); ?>" <?php echo mh_sanitize_text_input($menu_cta_title); ?><?php echo $menu_cta_url_target ?>> <?php echo $menu_cta_content; ?> </a> </div>
          <?php endif; //mh_top_cta_show?>
          <?php
        $menu_cta_2 = get_theme_mod('top_cta_text_2', '');
        $menu_cta_url_2 = get_theme_mod('top_cta_url_2', '');
        $menu_cta_url_target_2 = true === get_theme_mod('top_cta_url_target_2', false) ? ' target="_blank"' : '';
        $menu_cta_style_2 = get_theme_mod('top_cta_style_2', 'button');
        $menu_cta_button_style_2 = get_theme_mod('top_cta_button_style_2', 'solid');
        $menu_cta_title_2 = '' != $menu_cta_2 ? ' title="' . $menu_cta_2 . '"': '';
        $menu_cta_content_2 = 'icon' === $menu_cta_style_2 ? '<i class="mh_top_cta_icon mh-icon-before"></i>' : mh_sanitize_text_input($menu_cta_2);
        $menu_cta_animation_2 = get_theme_mod('top_cta_animation_2', 'off');
        $menu_cta_animation_class_2 = ('off' !== $menu_cta_animation_2 ?  sprintf(' mh-animated mhc_animation_%1$s', esc_attr($menu_cta_animation_2)) : '');
        if (true === get_theme_mod('show_top_cta_2', false) && '' != $menu_cta_url_2): ?>
          <div class="mh-top-cta mh-top-cta-2 mh-top-cta-<?php echo $menu_cta_style_2; ?> mh-cta-button-<?php echo $menu_cta_button_style_2 . $menu_cta_animation_class_2; ?>"> <a class="mh_adjust_corners" href="<?php echo esc_url($menu_cta_url_2); ?>" <?php echo mh_sanitize_text_input($menu_cta_title_2); ?><?php echo $menu_cta_url_target_2 ?>> <?php echo $menu_cta_content_2; ?> </a> </div>
          <?php endif; //mh_top_cta_show?>
          
         <?php if ('full' === get_theme_mod('show_search_icon', 'full') || '1' === get_theme_mod('show_search_icon', '1')) : ?>
          <div id="mh_top_search" class="mh-full-search-trigger"> <i class="mh_search_icon mh-icon-before"></i> </div>
          <?php elseif ('default' === get_theme_mod('show_search_icon', 'full') || '2' === get_theme_mod('show_search_icon', 'full')) : ?>
          <div id="mh_top_search"> <i class="mh_search_icon mh-icon-before"></i>
            <form method="get" class="mh-search-form mh-hidden" action="<?php echo esc_url(home_url('/')); ?>" role="search">
              <input type="search" class="mh-search-field" placeholder="<?php esc_attr_e('Search &hellip;', 'mharty'); ?>" value="<?php get_search_query() ?>" name="s" title="<?php esc_attr_e('Search for:', 'mharty'); ?>" />
            </form>
          </div>
          <?php endif; //fullwidth_search & show_search_icon?>
          
          <?php
        if ('primary' === get_theme_mod('shop_cart_position', 'primary')) {
            do_action('mh_header_mini_cart');
        }
        ?>
          <?php do_action('mh_header_top'); ?>
          <div class="mobile-menu-trigger-icon">
            <button class="sandwich sandwich--collapse" type="button" aria-label="Toggle Navigation" aria-controls="app-navigation"> <span class="sandwich-box"> <span class="sandwich-inner"></span> </span> </button>
          </div>
          <?php
        if (true === get_theme_mod('mharty_extra_logo', false) && '' != $extra_logo): ?>
          <div class="mh_extra_logo"> <img src="<?php echo esc_url(apply_filters('mh_logo_extra_filter', $extra_logo)); ?>" width="<?php echo esc_attr(mh_get_image_width_height($extra_logo, 'width')); ?>" height="<?php echo esc_attr(mh_get_image_width_height($extra_logo, 'height')); ?>" /> </div>
          <?php endif; ?>
        </div>
        <!-- .mh-top-navigation-icons --> 
      </div>
      <!-- #mh-top-navigation --> 
    </div>
    <!-- .mh-top-navigation-wrapper --> 
  </div>
  <!-- .container --> 
</header>
<!-- #main-header -->

<?php if (('0' == get_theme_mod('secondary_nav_position', '0') && $mh_top_info_defined && ! is_page_template('page-template-trans.php'))) : ?>
<div id="top-header" class="<?php echo esc_html($secondary_nav_class . $promo_class);?>">
  <?php if (true === $promo) {
      echo $promo_output;
  }  ?>
  <div class="container clearfix">
    <?php if ($mh_contact_info_defined) : ?>
    <div id="mh-info">
      <?php
      if (true === $show_header_date): ?>
      <span class="mh-info-item mh-info-date mh-icon-before mh-icon-after"><?php echo date_i18n(get_theme_mod('mharty_header_date_format', 'd/m/Y'), time()); ?></span>
      <?php endif; ?>
      <?php if ('' !== ($mh_custom_phrase = get_theme_mod('header_phrase', ''))) : ?>
      <span class="mh-info-item mh-info-custom-text mh-icon-before mh-icon-after"><?php echo mh_sanitize_text_input($mh_custom_phrase); ?></span></a>
      <?php endif; ?>
      <?php if ('' !== ($mh_phone_number = get_theme_mod('phone_number', ''))) : ?>
      <span class="mh-info-item mh-info-phone mh-icon-before mh-icon-after"><?php echo mh_sanitize_text_input($mh_phone_number); ?></span>
      <?php endif; ?>
      <?php if ('' !== ($mh_email = get_theme_mod('header_email', ''))) : ?>
      <a class="mh-info-item mh-info-email-url" href="<?php echo esc_html('mailto:' . $mh_email); ?>"><span class="mh-info-email mh-icon-before mh-icon-after"><?php echo esc_html($mh_email); ?></span></a>
      <?php endif; ?>
    </div>
    <!-- #mh-info -->
    
    <?php
    if (true === $show_header_social_icons) {
        get_template_part('includes/social_icons', 'header');
    }
        ?>
    <?php endif; // true === $mh_contact_info_defined?>
    <div id="mh-secondary-menu">
      <?php
          if (!$mh_contact_info_defined && true === $show_header_social_icons) {
              //echo '<div id="mh-info">';
              get_template_part('includes/social_icons', 'header');
              //echo '	</div> <!-- #mh-info -->';
          } elseif ($mh_contact_info_defined && true === $show_header_social_icons) {
              ob_start();

              get_template_part('includes/social_icons', 'header');

              $duplicate_social_icons = ob_get_contents();

              ob_end_clean();

              //printf(
              //							'<div class="mh_duplicate_social_icons">
              //								%1$s
              //							</div>',
              //							$duplicate_social_icons
              //						);
          }

        if ('' !== $mh_secondary_nav) {
            echo $mh_secondary_nav;
        }

        ?>
      <?php
        if ('primary' !== get_theme_mod('shop_cart_position', 'primary')) {
            do_action('mh_header_mini_cart');
        }
        ?>
    </div>
    <!-- #mh-secondary-menu --> 
    
  </div>
  <!-- .container --> 
</div>
<!-- #top-header -->
<?php
endif; // true ==== $mh_top_info_defined
        echo '</div> <!--header-container-->';
    }
}

if (!function_exists('mh_fullwidth_search')):
    function mh_fullwidth_search() {
        if ('full' === get_theme_mod('show_search_icon', 'full') || '1' === get_theme_mod('show_search_icon', 'full')) {
            ?>
<div class="mh-full-search-overlay">
  <div class="mh-full-search-overlay-inner">
    <div class="container">
      <form method="get" id="searchform" class="form-search" action="<?php echo esc_url(home_url('/')); ?>" role="search">
        <h4>
          <?php
                $full_search_text = get_theme_mod('full_search_text');
            if ('' === $full_search_text) {
                esc_html_e('Type and Press &ldquo;Enter&rdquo;', 'mharty');
            } else {
                echo esc_html($full_search_text);
            }
            ?>
        </h4>
        <input type="search" id="s" class="search-input" name="s">
        <?php do_action('mh_header_search_custom_input'); ?>
      </form>
    </div>
  </div>
</div>
<!-- mh-full-search-overlay-->
<?php
        }
    }
endif;
add_action('mh_before_end_container', 'mh_fullwidth_search');

if (!function_exists('mh_add_app_nav')):
    function mh_add_app_nav() {
        //if ( true === get_theme_mod( 'app_menu', false)  ) {
        $app_menu_class = '';
        $mobile_menu_style = get_theme_mod('app_style', 'side');
        if ('sub' === $mobile_menu_style && '1' === get_theme_mod('vertical_nav', '0')) {
            $app_menu_class .= esc_attr(" mh_app_nav_side");
        } else {
            $app_menu_class .= esc_attr(" mh_app_nav_{$mobile_menu_style}");
        }

        if ('' !== ($app_menu_text_color = get_theme_mod('app_menu_text_color', 'dark'))):
            $app_menu_class .= ' mh_nav_text_color_' . $app_menu_text_color;
        endif;
        ?>
<div class="mh-app-nav mh-app-nav-header app-nav<?php echo esc_html($app_menu_class); ?>">
  <div class="mh-app-nav-container">
    <?php
        $app_logo = get_theme_mod('app_logo');
        if ('' != $app_logo) {
            ?>
    <a href="<?php echo esc_url(apply_filters('mh_logo_url_filter', home_url('/'))); ?>" class="mh-app-logo"> <img src="<?php echo esc_url($app_logo); ?>" alt="<?php echo esc_html(get_bloginfo('name')); ?>" id="app-logo" width="<?php echo esc_attr(mh_get_image_width_height($app_logo, 'width')); ?>" height="<?php echo esc_attr(mh_get_image_width_height($app_logo, 'height')); ?>" /></a>
    <?php
        }
        $tagline = '' != get_theme_mod('app_tagline_alt') ? esc_html(get_theme_mod('app_tagline_alt')) : esc_html(get_bloginfo('description'));
        if ('show' === (get_theme_mod('app_tagline', 'show'))) {
            echo '<p class="app-tagline">' . $tagline . '</p>';
        }
        ?>
    <?php //if ( has_nav_menu( 'app-menu' ) ) :?>
    <?php if ('' != $tagline && 'show' === (get_theme_mod('app_tagline', 'show'))) {
        echo '<div class="divider-top"></div>';
    } ?>
    <div class="app-menu">
      <?php
      $app_menu_source = has_nav_menu('app-menu') ? 'app-menu' : 'primary-menu';
        wp_nav_menu([
            'theme_location' => $app_menu_source,
            //'depth'          => '1',
            'menu_class' => 'app-menu',
            'container' => 'nav',
            'container_id' => 'app-navigation',
            'container_class' => 'app-navigation',
            'fallback_cb' => 'link_to_menu_editor',
            'walker' => new mharty_walker,
        ]);
        ?>
    </div>
    <?php // endif;?>
    <?php if ('' !== ($mh_phone_number = get_theme_mod('app_phone_number', '')) || '' !== ($mh_email = get_theme_mod('app_email', '')) || '1' === get_theme_mod('show_app_social_icons', '0')) { ?>
    <div class="divider-bottom"></div>
    <div class="app-nav-info app-nav-has-menu">
      <?php if ('' !== ($mh_phone_number = get_theme_mod('app_phone_number', ''))) : ?>
      <span class="mh-info-phone mh-icon-before mh-icon-after"><?php echo mh_sanitize_text_input($mh_phone_number); ?></span>
      <?php endif; ?>
      <?php if ('' !== ($mh_email = get_theme_mod('app_email', ''))) : ?>
      <a class="mh-info-email-url" href="<?php echo esc_html('mailto:' . $mh_email); ?>"><span class="mh-info-email mh-icon-before mh-icon-after"><?php echo esc_html($mh_email); ?></span></a>
      <?php endif; ?>
    </div>
    <?php } ?>
    <?php
    if ('1' === get_theme_mod('show_app_social_icons', '0')) {
        get_template_part('includes/social_icons', 'footer');
    }
        ?>
  </div>
  <div class="mobile-menu-trigger-icon">
    <button class="sandwich sandwich--collapse" type="button" aria-label="Toggle Navigation" aria-controls="app-navigation"> <span class="sandwich-box"> <span class="sandwich-inner"></span> </span> </button>
  </div>
</div>
<?php
    }
endif;
add_action('mh_header_top', 'mh_add_app_nav');
