<?php
function mh_get_option( $key = '', $default = false ) {
	global $mh_options;
	$value = ! empty( $mh_options[ $key ] ) ? $mh_options[ $key ] : $default;
	$value = apply_filters( 'mh_get_option', $value, $key, $default );
	return apply_filters( 'mh_get_option_' . $key, $value, $key, $default );
}


function mh_update_option( $key = '', $value = false ) {

	if ( empty( $key ) ){
		return false;
	}

	if ( empty( $value ) ) {
		$remove_option = mh_delete_option( $key );
		return $remove_option;
	}

	$options = get_option( 'mharty_options');
	
	//filter the value
	$value = apply_filters( 'mh_update_option', $value, $key );

	$options[ $key ] = $value;
	$updated = update_option( 'mharty_options', $options );

	//update the global $mh_options
	if ( $updated ){
		global $mh_options;
		$mh_options[ $key ] = $value;
	}
	
	return $updated;
}

function mh_delete_option( $key = '' ) {
	global $mh_options;

	if ( empty( $key ) ){
		return false;
	}

	$options = get_option( 'mharty_options' );

	if( isset( $options[ $key ] ) ) {
		unset( $options[ $key ] );
	}
	
	if( isset( $mh_options[ $key ] ) ) {
		unset( $mh_options[ $key ] );
	}

	$updated = update_option( 'mharty_options', $options );

	if ( $updated ){
		global $mh_options;
		$mh_options = $options;
	}

	return $updated;
}