<?php
if ( !defined( 'ABSPATH' ) )exit;

function mh_get_settings() {
  $settings = get_option( 'mharty_options' );
  return apply_filters( 'mh_get_settings', $settings );
}

function mh_register_settings() {
  if ( false == get_option( 'mharty_options' ) ) {
    add_option( 'mharty_options' );
  }

  foreach ( mh_get_registered_settings() as $tab => $sections ) {
    foreach ( $sections as $section => $settings ) {

      add_settings_section(
        'mh_settings_' . $tab . '_' . $section,
        __return_null(),
        '__return_false',
        'mh_settings_' . $tab . '_' . $section
      );

      foreach ( $settings as $option ) {
        $args = wp_parse_args( $option, array(
          'section' => $section,
          'id' => null,
          'desc' => '',
          'name' => '',
          'size' => null,
          'options' => '',
          'std' => '',
          'multiple' => null,
          'placeholder' => null,
          'allow_blank' => true,
          'readonly' => false,
          'field_class' => '',
          'affects' => '',
          'depends' => false,
          'function_name' => '',
          'icon' => '',
          'items_amount',
        ) );

        add_settings_field(
          'mharty_options[' . $args[ 'id' ] . ']',
          $args[ 'name' ],
          function_exists( 'mh_' . $args[ 'type' ] . '_callback' ) ? 'mh_' . $args[ 'type' ] . '_callback' : 'mh_no_callback_function',
          'mh_settings_' . $tab . '_' . $section,
          'mh_settings_' . $tab . '_' . $section,
          $args
        );
      }
    }

  }

  register_setting( 'mharty_options', 'mharty_options', 'mh_settings_sanitize' );

}
add_action( 'admin_init', 'mh_register_settings' );


function mh_get_registered_settings() {
  $themename = 'mharty';
  
  $mh_settings = array(
    //color_palette
    'color_palette' => apply_filters( 'mh_settings_color_palette',
      array(
        'main' => array(
          $themename . '_color_scheme' => array(
            'name' => esc_html__( 'Create your Colour Picker Palette', 'mharty' ),
            'id' => $themename . '_color_scheme',
            'type' => 'color_scheme',
            'items_amount' => 8,
            'std' => '#444444|#cccccc|#f2f2f2|#E09900|#EDF000|#7CDA24|#0C71C3|#8300E9',
            'desc' => esc_html__( 'Choose the default colour palette for colour pickers throughout your website. Once you save your palette here you can access it from any picker in the Customiser and Composer to apply consistent colours to your website elements.', 'mharty' ),
          ),
          $themename . '_color_schemes' => array(
            'name' => esc_html__( 'Suggested Colour Palettes', 'mharty' ),
            'id' => $themename . '_color_schemes',
            'type' => 'color_schemes',
            'desc' => esc_html__( 'Click on a palette to select it.', 'mharty' ),
          ),
        ),
      )
    ),
    //misc settings
    'misc' => apply_filters( 'mh_settings_misc',
      array(
        'main' => array(
          
          $themename . '_beta' => array(
            'name' => esc_html__( 'Experimental Features', 'mharty' ) . ' <svg version="1.1" id="mh-beta-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px"
	 y="0px" viewBox="0 0 21.7 21.7" style="enable-background:new 0 0 21.7 21.7;" xml:space="preserve"><path style="fill:#C2E8FF;" d="M21.7,7.1L14.6,0l-1.4,1.4l0.7,0.7L1.2,14.8c-1.6,1.6-1.6,4.1,0,5.7s4.1,1.6,5.7,0L19.6,7.8l0.7,0.7
	L21.7,7.1z"/><path style="fill:#42EA86;" d="M10.8,6.6c-0.2-0.2-0.5-0.4-0.7-0.7l-8.9,8.9c-1.6,1.6-1.6,4.1,0,5.7c1.6,1.6,4.1,1.6,5.7,0L17.8,9.6
	c-0.6-0.5-1.8-0.8-3.3-1.4C13.2,7.8,11.9,7.4,10.8,6.6z"/></svg>',
            'id' => $themename . '_beta',
            'type' => 'checkbox',
            'std' => false,
            'desc' => mh_wp_kses( sprintf( __( 'Enable to have access to experimental features. <a target="_blank" href="%1$s">Learn more</a>.', 'mharty' ), 'https://mharty.com/blog/mharty-theme-6-5' ) ),
          ),
          
          $themename . '_smooth_scroll' => array(
            'name' => esc_html__( 'Smooth Scrolling', 'mharty' ),
            'id' => $themename . '_smooth_scroll',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'Enable this option to to get a smooth scrolling effect with mouse wheel.', 'mharty' ),
          ),
          $themename . '_scroll_to_anchor_fix' => array(
            'name' => esc_html__( 'Alternative scroll-to-anchor method', 'mharty' ),
            'id' => $themename . '_scroll_to_anchor_fix',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'In some cases when using the CSS ID of a section in link to anchor, the scroll position can be inaccurate. Enable this option to use an alternative method for scrolling to anchors.', 'mharty' ),
          ),
          $themename . '_disable_toptier' => array(
            'name' => esc_html__( 'Disable top tier dropdown menu links', 'mharty' ),
            'id' => $themename . '_disable_toptier',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( "Sometimes users will want to create parent categories or links as placeholders to hold a list of child links or categories. In this case it is not desirable to have the parent links lead anywhere, but instead merely serve an organizational function. Enabling this options will remove the links from all parent pages/categories so that they don't lead anywhere when clicked.", 'mharty' )
          ),
          $themename . '_gf_enable_all_character_sets' => array(
            'name' => esc_html__( 'Google Fonts subsets', 'mharty' ),
            'id' => $themename . '_gf_enable_all_character_sets',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'For Non-Arabic websites only. This will enable Google Fonts languages like Latin and Cyrillic.', 'mharty' ),
          ),
          $themename . '_disable_customizer_dark_mode' => array(
            'name' => esc_html__( 'Disable Customiser Dark Mode', 'mharty' ),
            'id' => $themename . '_disable_customizer_dark_mode',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'This option will disable the Theme Customiser dark mode.', 'mharty' ),
          ),
         $themename . '_disable_responsive_images' => array(
            'name' => esc_html__( 'Disable Responsive Images', 'mharty' ),
            'id' => $themename . '_disable_responsive_images',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'This option will disable generarting responsive images.', 'mharty' ),
          ),
        )
      )
    ),
    'integration' => apply_filters( 'mh_settings_integration',
      array(
        'main' => array(

          $themename . '_google_maps_api_key' => array(
            'name' => esc_html__( 'Google API Key', 'mharty' ),
            'id' => $themename . '_google_maps_api_key',
            'std' => '',
            'type' => 'text',
            'desc' => mh_wp_kses( sprintf( __( 'The Maps component uses the Google Maps API and requires a valid Google API Key to work. Before using the map component, please make sure you input your API key in the field. Learn more about how to create your Google API Key <a target="_blank" href="%1$s">here</a>.', 'mharty' ), 'https://mharty.com/learn/theme/maps' ) ),
          ),
          $themename . '_mailchimp_api_key' => array(
            'name' => esc_html__( 'MailChimp API Key', 'mharty' ),
            'id' => $themename . '_mailchimp_api_key',
            'std' => '',
            'type' => 'text',
            'desc' => mh_wp_kses( sprintf( __( 'Enter your MailChimp API key. You can create an api key <a target="_blank" href="%1$s">here</a>', 'mharty' ), 'https://us3.admin.mailchimp.com/account/api/' ) )
          ),
          $themename . '_regenerate_mailchimp_lists' => array(
            'name' => esc_html__( 'Regenerate MailChimp Lists', 'mharty' ),
            'id' => $themename . '_regenerate_mailchimp_lists',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( "By default, MailChimp lists are cached for one day. If you added new list, but it doesn't appear within the SignUp module settings, activate this option. Don't forget to disable it once the list has been regenerated.", 'mharty' ),
          ),

          $themename . '_integrate_header_enable' => array(
            'name' => esc_html__( 'Code inside < head >', 'mharty' ),
            'id' => $themename . '_integrate_header_enable',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'Disabling this option will remove the code from the frontend of your website. This allows you to remove the code while saving it for later use.', 'mharty' ),
            'affects' => $themename . '_integration_head'
          ),
          $themename . '_integration_head' => array(
            'name' => esc_html__( 'Add code to the < head > of your website', 'mharty' ),
            'id' => $themename . '_integration_head',
            'type' => 'textarea',
            'std' => '',
            'desc' => esc_html__( 'Any code you place here will appear in the head section of every page of your website. This is useful when you need to add javascript or css to all pages.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_integrate_body_enable' => array(
            'name' => esc_html__( 'Code inside < body >', 'mharty' ),
            'id' => $themename . '_integrate_body_enable',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'Disabling this option will remove the code from the frontend of your website. This allows you to remove the code while saving it for later use.', 'mharty' ),
            'affects' => $themename . '_integration_body'
          ),

          $themename . '_integration_body' => array(
            'name' => esc_html__( 'Add code to the < body > (good for tracking codes such as google analytics)', 'mharty' ),
            'id' => $themename . '_integration_body',
            'type' => 'textarea',
            'std' => '',
            'desc' => esc_html__( 'Any code you place here will appear in body section of all pages of your website. This is usefull if you need to input a tracking pixel for a state counter such as Google Analytics.', 'mharty' ),
            'depends' => true
          ),
          
        $themename . '_integrate_after_menu_enable' => array(
            'name' => esc_html__( 'Code after menu', 'mharty' ),
            'id' => $themename . '_integrate_after_menu_enable',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'Disabling this option will remove the code from the frontend of your website. This allows you to remove the code while saving it for later use.', 'mharty' ),
            'affects' => $themename . '_integration_after_menu'
          ),
          
          $themename . '_integration_after_menu' => array(
            'name' => esc_html__( 'Add code to the top of your website, after menu', 'mharty' ),
            'id' => $themename . '_integration_after_menu',
            'type' => 'textarea',
            'std' => '',
            'desc' => esc_html__( 'Any code you place here will be placed at the top of your website.', 'mharty' ),
            'depends' => true
          ),
          
          $themename . '_integrate_before_footer_enable' => array(
            'name' => esc_html__( 'Code before footer', 'mharty' ),
            'id' => $themename . '_integrate_before_footer_enable',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'Disabling this option will remove the code from the frontend of your website. This allows you to remove the code while saving it for later use.', 'mharty' ),
            'affects' => $themename . '_integration_before_footer'
          ),
          
          $themename . '_integration_before_footer' => array(
            'name' => esc_html__( 'Add code to the bottom of your website, before footer', 'mharty' ),
            'id' => $themename . '_integration_before_footer',
            'type' => 'textarea',
            'std' => '',
            'desc' => esc_html__( 'Any code you place here will be placed at the top of your website.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_integrate_singletop_enable' => array(
            'name' => esc_html__( 'Code before single post title', 'mharty' ),
            'id' => $themename . '_integrate_singletop_enable',
            'type' => 'checkbox',
            'std' => false,
           'desc' => esc_html__( 'Disabling this option will remove the code from the frontend of your website. This allows you to remove the code while saving it for later use.', 'mharty' ),
            'affects' => $themename . '_integration_single_top'
          ),

          $themename . '_integration_single_top' => array(
            'name' => esc_html__( 'Add code to the top of your posts, before title', 'mharty' ),
            'id' => $themename . '_integration_single_top',
            'type' => 'textarea',
            'std' => '',
            'desc' => esc_html__( 'Any code you place here will be placed at the top of all single posts.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_integrate_singlebottom_enable' => array(
            'name' => esc_html__( 'Code before single post comments', 'mharty' ),
            'id' => $themename . '_integrate_singlebottom_enable',
            'type' => 'checkbox',
            'std' => false,
           'desc' => esc_html__( 'Disabling this option will remove the code from the frontend of your website. This allows you to remove the code while saving it for later use.', 'mharty' ),
            'affects' => $themename . '_integration_single_bottom'
          ),

          $themename . '_integration_single_bottom' => array(
            'name' => esc_html__( 'Add code to the bottom of your posts, before comments', 'mharty' ),
            'id' => $themename . '_integration_single_bottom',
            'type' => 'textarea',
            'std' => '',
            'desc' => esc_html__( 'Any code you place here will be placed at the bottom of all single posts.', 'mharty' ),
            'depends' => true
          ),
        )
      )
    ),
    //seo settings
    'seo' => apply_filters( 'mh_settings_seo',
      array(
        'main' => array(
          $themename . '_seo_home_header' => array(
            'name' => esc_html__( 'Homepage SEO', 'mharty' ),
            'id' => $themename . '_seo_home_header',
            'type' => 'header',
            'desc' => esc_html__( 'Homepage SEO', 'mharty' )
          ),
          $themename . '_seo_home_title' => array(
            'name' => esc_html__( 'Enable custom title', 'mharty' ),
            'id' => $themename . '_seo_home_title',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'By default the theme creates your homepage titles using a combination of your website name and your website description, as defined when you created your website. However if you want to create a custom title then simply enable this option and fill in the custom title field below.', 'mharty' ),
            'affects' => $themename . '_seo_home_titletext'
          ),
          $themename . '_seo_home_titletext' => array(
            'name' => esc_html__( 'Homepage custom title (if enabled)', 'mharty' ),
            'id' => $themename . '_seo_home_titletext',
            'type' => 'text',
            'std' => '',
            'desc' => esc_html__( 'If you have enabled custom titles you can add your custom title here. Whatever you type here will be placed between the < title >< /title > tags.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_seo_home_description' => array(
            'name' => esc_html__( 'Enable meta description', 'mharty' ),
            'id' => $themename . '_seo_home_description',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'By default the theme fills in the meta description field using your website description, as defined when you created your website. If you would like to use a different description then enable this option and fill in the custom description field below.', 'mharty' ),
            'affects' => $themename . '_seo_home_descriptiontext'
          ),

          $themename . '_seo_home_descriptiontext' => array(
            'name' => esc_html__( 'Homepage meta description (if enabled)', 'mharty' ),
            'id' => $themename . '_seo_home_descriptiontext',
            'type' => 'textarea',
            'std' => '',
            'desc' => esc_html__( 'If you have enabled meta descriptions you can add your custom description here.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_seo_home_keywords' => array(
            'name' => esc_html__( 'Enable meta keywords', 'mharty' ),
            'id' => $themename . '_seo_home_keywords',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( "By default the theme does not add keywords to your header. Most search engines don't use keywords to rank your site any more, but some people define them anyway just in case. If you want to add meta keywords to your header then enable this option and fill in the custom keywords field below.", 'mharty' ),
            'affects' => $themename . '_seo_home_keywordstext'
          ),
          $themename . '_seo_home_keywordstext' => array(
            'name' => esc_html__( 'Homepage meta keywords (if enabled)', 'mharty' ),
            'id' => $themename . '_seo_home_keywordstext',
            'type' => 'text',
            'std' => '',
            'desc' => esc_html__( 'If you have enabled meta keywords you can add your custom keywords here. Keywords should be separated by commas. For example: wordpress,themes,templates', 'mharty' ),
            'depends' => true
          ),

          $themename . '_seo_home_type' => array(
            'name' => esc_html__( 'If custom titles are disabled, choose autogeneration method', 'mharty' ),
            'id' => $themename . '_seo_home_type',
            'type' => 'select',
            'std' => '0',
            'options' => array( 
              '0' => esc_html__( 'Site Title | Tagline', 'mharty' ), 
              '1' => esc_html__( 'Tagline | Site Title', 'mharty' ), 
              '2' => esc_html__( 'Site Title only', 'mharty' ) 
            ),
            'desc' => esc_html__( 'If you are not using custom post titles you can still have control over how your titles are generated. Here you can choose which order you would like your post title and website name to be displayed, or you can remove the website name from the title completely.', 'mharty' )
          ),

          $themename . '_seo_home_separate' => array(
            'name' => esc_html__( 'Define a character to separate Site Title and Post title', 'mharty' ),
            'id' => $themename . '_seo_home_separate',
            'type' => 'text',
            'std' => ' | ',
            'desc' => esc_html__( 'Here you can change which character separates your website title and post name when using autogenerated post titles. Common values are | or -', 'mharty' ),
          ),
          $themename . '_seo_home_canonical' => array(
            'name' => esc_html__( "Enable canonical URL's", 'mharty' ),
            'id' => $themename . '_seo_home_canonical',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( "Canonicalization helps to prevent the indexing of duplicate content by search engines, and as a result, may help avoid duplicate content penalties and pagerank degradation. Some pages may have different URL's all leading to the same place. For example domain.com, domain.com/index.html, and www.domain.com are all different URLs leading to your homepage. From a search engine's perspective these duplicate URLs, which also occur often due to custom permalinks, may be treated individually instead of as a single destination. Defining a canonical URL tells the search engine which URL you would like to use officially. The theme bases its canonical URLs on your permalinks and the domain name defined in the settings tab of wp-admin.", 'mharty' )
          ),

          $themename . '_seo_post_header' => array(
            'name' => esc_html__( 'Single Post/Page SEO', 'mharty' ),
            'id' => $themename . '_seo_post_header',
            'type' => 'header',
            'desc' => esc_html__( 'Single Post/Page SEO', 'mharty' )
          ),

          $themename . '_seo_single_title' => array(
            'name' => esc_html__( 'Enable custom titles', 'mharty' ),
            'id' => $themename . '_seo_single_title',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'By default the theme creates post titles based on the title of your post and your website name. If you would like to make your meta title different than your actual post title you can define a custom title for each post using custom fields. This option must be enabled for custom titles to work, and you must choose a custom field name for your title below.', 'mharty' ),
            'affects' => $themename . '_seo_single_field_title'
          ),
          $themename . '_seo_single_field_title' => array(
            'name' => esc_html__( 'Custom field Name to be used for title', 'mharty' ),
            'id' => $themename . '_seo_single_field_title',
            'type' => 'text',
            'std' => 'seo_title',
            'desc' => esc_html__( 'When you define your title using custom fields you should use this value for the custom field Name. The Value of your custom field should be the custom title you would like to use.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_seo_single_description' => array(
            'name' => esc_html__( 'Enable custom description', 'mharty' ),
            'id' => $themename . '_seo_single_description',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'If you would like to add a meta description to your post you can do so using custom fields. This option must be enabled for descriptions to be displayed on post pages. You can add your meta description using custom fields based on the custom field name you define below.', 'mharty' ),
            'affects' => $themename . '_seo_single_field_description'
          ),
          $themename . '_seo_single_field_description' => array(
            'name' => esc_html__( 'Custom field Name to be used for description', 'mharty' ),
            'id' => $themename . '_seo_single_field_description',
            'type' => 'text',
            'std' => 'seo_description',
            'desc' => esc_html__( 'When you define your meta description using custom fields you should use this value for the custom field Name. The Value of your custom field should be the custom description you would like to use.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_seo_single_keywords' => array(
            'name' => esc_html__( 'Enable custom keywords', 'mharty' ),
            'id' => $themename . '_seo_single_keywords',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'If you would like to add meta keywords to your post you can do so using custom fields. This option must be enabled for keywords to be displayed on post pages. You can add your meta keywords using custom fields based on the custom field name you define below.', 'mharty' ),
            'affects' => $themename . '_seo_single_field_keywords'
          ),

          $themename . '_seo_single_field_keywords' => array(
            'name' => esc_html__( 'Custom field Name to be used for keywords', 'mharty' ),
            'id' => $themename . '_seo_single_field_keywords',
            'type' => 'text',
            'std' => 'seo_keywords',
            'desc' => esc_html__( 'When you define your keywords using custom fields you should use this value for the custom field Name. The Value of your custom field should be the meta keywords you would like to use, separated by commas.', 'mharty' ),
            'depends' => true
          ),

          $themename . '_seo_single_type' => array(
            'name' => esc_html__( 'If custom titles are disabled, choose autogeneration method', 'mharty' ),
            'id' => $themename . '_seo_single_type',
            'type' => 'select',
            'std' => '0',
            'options' => array( 
              '0' => esc_html__( 'Site Title | Post title', 'mharty' ),
              '1' => esc_html__( 'Post title | Site Title', 'mharty' ),
              '2' => esc_html__( 'Post title only', 'mharty' )
            ),
            'desc' => esc_html__( 'If you are not using custom post titles you can still have control over how your titles are generated. Here you can choose which order you would like your post title and website name to be displayed, or you can remove the website name from the title completely.', 'mharty' )
          ),

          $themename . '_seo_single_separate' => array(
            'name' => esc_html__( 'Define a character to separate Site Title and Post title', 'mharty' ),
            'id' => $themename . '_seo_single_separate',
            'type' => 'text',
            'std' => ' | ',
            'desc' => esc_html__( 'Here you can change which character separates your website title and post name when using autogenerated post titles. Common values are | or -', 'mharty' ),
          ),
          $themename . '_seo_single_canonical' => array(
            'name' => esc_html__( "Enable canonical URL's", 'mharty' ),
            'id' => $themename . '_seo_single_canonical',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( "Canonicalization helps to prevent the indexing of duplicate content by search engines, and as a result, may help avoid duplicate content penalties and pagerank degradation. Some pages may have different URL's all leading to the same place. For example domain.com, domain.com/index.html, and www.domain.com are all different URLs leading to your homepage. From a search engine's perspective these duplicate URLs, which also occur often due to custom permalinks, may be treated individually instead of as a single destination. Defining a canonical URL tells the search engine which URL you would like to use officially. The theme bases its canonical URLs on your permalinks and the domain name defined in the settings tab of wp-admin.", 'mharty' )
          ),

          $themename . '_seo_archive_header' => array(
            'name' => esc_html__( 'Archives SEO', 'mharty' ),
            'id' => $themename . '_seo_archive_header',
            'type' => 'header',
            'desc' => esc_html__( 'Archives SEO', 'mharty' )
          ),

          $themename . '_seo_index_description' => array(
            'name' => esc_html__( 'Enable meta descriptions', 'mharty' ),
            'id' => $themename . '_seo_index_description',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( 'Check this box if you want to display meta descriptions on category/archive pages. They are based on the descriptions you write when creating/editing your categories in wp-admin.', 'mharty' )
          ),


          $themename . '_seo_index_type' => array(
            'name' => esc_html__( 'Choose title autogeneration method', 'mharty' ),
            'id' => $themename . '_seo_index_type',
            'type' => 'select',
            'std' => '0',
            'options' => array( 
              '0' => esc_html__( 'Site Title | Category name', 'mharty' ),
              '1' => esc_html__( 'Category name | Site Title', 'mharty' ),
              '2' => esc_html__( 'Category name only', 'mharty' ) 
            ),
            'desc' => esc_html__( 'Here you can choose how your titles on index pages are generated. You can change which order your website name and index title are displayed, or you can remove the website name from the title completely.', 'mharty' )
          ),

          $themename . '_seo_index_separate' => array(
            'name' => esc_html__( 'Define a character to separate Site Title and Post title', 'mharty' ),
            'id' => $themename . '_seo_index_separate',
            'type' => 'text',
            'std' => ' | ',
            'desc' => esc_html__( 'Here you can change which character separates your website title and index page name when using autogenerated post titles. Common values are | or -', 'mharty' ),
          ),
          $themename . '_seo_index_canonical' => array(
            'name' => esc_html__( "Enable canonical URL's", 'mharty' ),
            'id' => $themename . '_seo_index_canonical',
            'type' => 'checkbox',
            'std' => false,
            'desc' => esc_html__( "Canonicalization helps to prevent the indexing of duplicate content by search engines, and as a result, may help avoid duplicate content penalties and pagerank degradation. Some pages may have different URL's all leading to the same place. For example domain.com, domain.com/index.html, and www.domain.com are all different URLs leading to your homepage. From a search engine's perspective these duplicate URLs, which also occur often due to custom permalinks, may be treated individually instead of as a single destination. Defining a canonical URL tells the search engine which URL you would like to use officially. The theme bases its canonical URLs on your permalinks and the domain name defined in the settings tab of wp-admin.", 'mharty' )
          ),
        )
      )

    ),

    //seo settings
    'status' => apply_filters( 'mh_settings_status',
      array(
        'main' => array(
          $themename . '_status' => array(
            'name' => esc_html__( 'Site Status', 'mharty' ),
            'id' => $themename . '_site_status',
            'type' => 'function',
            'desc' => esc_html__( 'By default the theme creates your homepage titles using a combination of your website name and your website description, as defined when you created your website. However if you want to create a custom title then simply enable this option and fill in the custom title field below.', 'mharty' )
          ),
        )
      )
    )

  );

  return apply_filters( 'mh_registered_settings', $mh_settings );
}


//Settings Sanitization
function mh_settings_sanitize( $input = array() ) {
  global $mh_options;

  $doing_section = false;
  if ( !empty( $_POST[ '_wp_http_referer' ] ) ) {
    $doing_section = true;
  }

  $setting_types = mh_get_registered_settings_types();
  $input = $input ? $input : array();

  if ( $doing_section ) {
    parse_str( $_POST[ '_wp_http_referer' ], $referrer );
    $tab = isset( $referrer[ 'tab' ] ) ? $referrer[ 'tab' ] : 'color_palette';
    $section = isset( $referrer[ 'section' ] ) ? $referrer[ 'section' ] : 'main';

    if ( !empty( $_POST[ 'mh_section_override' ] ) ) {
      $section = sanitize_text_field( $_POST[ 'mh_section_override' ] );
    }

    $setting_types = mh_get_registered_settings_types( $tab, $section );

    $input = apply_filters( 'mh_settings_' . $tab . '_sanitize', $input );
    $input = apply_filters( 'mh_settings_' . $tab . '-' . $section . '_sanitize', $input );

  }

  // array_merge all settings
  $mh_options = is_array( $mh_options ) ? $mh_options : array();
  $output = array_merge( $mh_options, $input );

  foreach ( $setting_types as $key => $type ) {

    if ( empty( $type ) ) {
      continue;
    }

    $not_true_settings = apply_filters( 'mh_not_true_settings', array(
      'header', 'function', 'iconpreview', 'color_schemes',
    ) );

    if ( in_array( $type, $not_true_settings ) ) {
      continue;
    }

    if ( array_key_exists( $key, $output ) ) {
      $output[ $key ] = apply_filters( 'mh_settings_sanitize_' . $type, $output[ $key ], $key );
      $output[ $key ] = apply_filters( 'mh_settings_sanitize', $output[ $key ], $key );
    }

    if ( $doing_section ) {
      switch ( $type ) {
        case 'text':
          if ( array_key_exists( $key, $input ) && empty( $input[ $key ] ) ) {
            unset( $output[ $key ] );
          }
          break;
        default:
          if ( array_key_exists( $key, $input ) && empty( $input[ $key ] ) || ( array_key_exists( $key, $output ) && !array_key_exists( $key, $input ) ) ) {
            unset( $output[ $key ] );
          }
          break;
      }
    } else {
      if ( empty( $input[ $key ] ) ) {
        unset( $output[ $key ] );
      }
    }

  }

  if ( $doing_section ) {
    add_settings_error( 'mh-notices', '', __( 'Settings updated.', 'mharty' ), 'updated' );

  }

  return $output;
}

function mh_get_registered_settings_types( $filtered_tab = false, $filtered_section = false ) {
  $settings = mh_get_registered_settings();
  $setting_types = array();
  foreach ( $settings as $tab_id => $tab ) {

    if ( false !== $filtered_tab && $filtered_tab !== $tab_id ) {
      continue;
    }

    foreach ( $tab as $section_id => $section_or_setting ) {

      if ( false !== $filtered_section && is_array( $section_or_setting ) && array_key_exists( 'type', $section_or_setting ) ) {
        $setting_types[ $section_or_setting[ 'id' ] ] = $section_or_setting[ 'type' ];
        continue;
      }

      if ( false !== $filtered_section && $filtered_section !== $section_id ) {
        continue;
      }

      foreach ( $section_or_setting as $section => $section_settings ) {

        if ( !empty( $section_settings[ 'type' ] ) ) {
          $setting_types[ $section_settings[ 'id' ] ] = $section_settings[ 'type' ];
        }

      }

    }

  }

  return $setting_types;
}


function mh_get_settings_tabs() {

  $settings = mh_get_registered_settings();

  $tabs = array();
  $tabs[ 'color_palette' ] = __( 'Colour Palette', 'mharty' );
  if ( !empty( $settings[ 'mhmoreicons' ] ) ) {
    $tabs[ 'mhmoreicons' ] = __( 'Icons', 'mharty' );
  }
  $tabs[ 'misc' ] = __( 'Misc.', 'mharty' );
  $tabs[ 'integration' ] = __( 'Integrations', 'mharty' );
  $tabs[ 'seo' ] = __( 'SEO', 'mharty' );
  $tabs[ 'status' ] = __( 'Status', 'mharty' );

  return apply_filters( 'mh_settings_tabs', $tabs );
}

//settings tabs
function mh_get_settings_tab_sections( $tab = false ) {

  $tabs = array();
  $sections = mh_get_registered_settings_sections();

  if ( $tab && !empty( $sections[ $tab ] ) ) {
    $tabs = $sections[ $tab ];
  } else if ( $tab ) {
    $tabs = array();
  }

  return $tabs;
}

//settings sections for each tab
function mh_get_registered_settings_sections() {

  static $sections = false;

  if ( false !== $sections ) {
    return $sections;
  }

  $sections = array(
    'color_palette' => apply_filters( 'mh_settings_sections_color_palette', array(
      'main' => __( 'General', 'mharty' ),
    ) ),
    'mhmoreicons' => apply_filters( 'mh_settings_sections_mhmoreicons', array(
      'main' => __( 'General', 'mharty' ),
    ) ),
    'misc' => apply_filters( 'mh_settings_sections_misc', array(
      'main' => __( 'General', 'mharty' ),
    ) ),
    'integration' => apply_filters( 'mh_settings_sections_integration', array(
      'main' => __( 'General', 'mharty' ),
    ) ),
    'seo' => apply_filters( 'mh_settings_sections_seo', array(
      'main' => __( 'General', 'mharty' ),
    ) ),
    'status' => apply_filters( 'mh_settings_sections_status', array(
      'main' => __( 'General', 'mharty' ),
    ) ),

  );

  $sections = apply_filters( 'mh_settings_sections', $sections );

  return $sections;
}


//If a setting has no function
function mh_no_callback_function( $args ) {
  printf(
    __( 'There is no callback function assigned for %s option.', 'mharty' ),
    '<strong>' . $args[ 'id' ] . '</strong>'
  );
}

//Text
function mh_text_callback( $args ) {
  $mh_option = mh_get_option( $args[ 'id' ] );

  if ( $mh_option ) {
    $value = $mh_option;
  } elseif ( !empty( $args[ 'allow_blank' ] ) && empty( $mh_option ) ) {
    $value = '';
  } else {
    $value = isset( $args[ 'std' ] ) ? $args[ 'std' ] : '';
  }

  $name = 'name="mharty_options[' . esc_attr( $args[ 'id' ] ) . ']"';

  $class = mh_sanitize_html_class( $args[ 'field_class' ] );
  $class .= mh_sanitize_key( $args[ 'id' ] );
  $class .= isset( $args[ 'depends' ] ) && true === $args[ 'depends' ] ? ' mh-depends-el' : '';

  $disabled = !empty( $args[ 'disabled' ] ) ? ' disabled="disabled"' : '';
  $readonly = $args[ 'readonly' ] === true ? ' readonly="readonly"' : '';
  $size = ( isset( $args[ 'size' ] ) && !is_null( $args[ 'size' ] ) ) ? $args[ 'size' ] : 'regular';
  $html = '<input type="text" class="' . $class . ' ' . sanitize_html_class( $size ) . '-text" id="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']" ' . $name . ' value="' . esc_attr( stripslashes( $value ) ) . '"' . $readonly . $disabled . ' placeholder="' . esc_attr( $args[ 'placeholder' ] ) . '"/>';
  $html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"> ' . wp_kses_post( $args[ 'name' ] ) . '</label>';
  $html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '</div>';

  echo apply_filters( 'mh_after_setting_output', $html, $args );
}

//Password
function mh_password_callback( $args ) {
  $mh_options = mh_get_option( $args[ 'id' ] );

  if ( $mh_options ) {
    $value = $mh_options;
  } else {
    $value = isset( $args[ 'std' ] ) ? $args[ 'std' ] : '';
  }

  $class = mh_sanitize_html_class( $args[ 'field_class' ] );
  $class .= mh_sanitize_key( $args[ 'id' ] );
  $class .= isset( $args[ 'depends' ] ) && true === $args[ 'depends' ] ? ' mh-depends-el' : '';
  $nonce = wp_create_nonce( 'validate_license_key_nonce' );

  $size = ( isset( $args[ 'size' ] ) && !is_null( $args[ 'size' ] ) ) ? $args[ 'size' ] : 'regular';
  $html = '<input type="password" class="' . $class . ' ' . sanitize_html_class( $size ) . '-text" id="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']" name="mharty_options[' . esc_attr( $args[ 'id' ] ) . ']" value="' . esc_attr( $value ) . '"/>';
  $html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"> ' . wp_kses_post( $args[ 'name' ] ) . '</label>';
  $html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '</div>';

  echo apply_filters( 'mh_after_setting_output', $html, $args );
}


//Select
function mh_select_callback( $args ) {
  $mh_option = mh_get_option( $args[ 'id' ] );

  if ( $mh_option ) {
    $value = $mh_option;
  } else {

    if ( empty( $args[ 'multiple' ] ) ) {
      $value = isset( $args[ 'std' ] ) ? $args[ 'std' ] : '';
    } else {
      $value = !empty( $args[ 'std' ] ) ? $args[ 'std' ] : array();
    }

  }

  if ( isset( $args[ 'placeholder' ] ) ) {
    $placeholder = $args[ 'placeholder' ];
  } else {
    $placeholder = '';
  }

  $class = mh_sanitize_html_class( $args[ 'field_class' ] );
  $class .= mh_sanitize_key( $args[ 'id' ] );
  $class .= isset( $args[ 'depends' ] ) && true === $args[ 'depends' ] ? ' mh-depends-el' : '';

  $nonce = isset( $args[ 'data' ][ 'nonce' ] ) ?
    ' data-nonce="' . sanitize_text_field( $args[ 'data' ][ 'nonce' ] ) . '" ': '';

  $name_attr = 'mharty_options[' . esc_attr( $args[ 'id' ] ) . ']';
  $name_attr = ( $args[ 'multiple' ] ) ? $name_attr . '[]': $name_attr;

  $html = '<select ' . $nonce . ' id="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']" name="' . $name_attr . '" class="' . $class . '" data-placeholder="' . esc_html( $placeholder ) . '" ' . ( ( $args[ 'multiple' ] ) ? 'multiple="true"' : '' ) . '>';

  foreach ( $args[ 'options' ] as $option => $name ) {

    if ( !$args[ 'multiple' ] ) {
      $selected = selected( $option, $value, false );
      $html .= '<option value="' . esc_attr( $option ) . '" ' . $selected . '>' . esc_html( $name ) . '</option>';
    } else {
      $html .= '<option value="' . esc_attr( $option ) . '" ' . ( ( in_array( $option, $value ) ) ? 'selected="true"' : '' ) . '>' . esc_html( $name ) . '</option>';
    }

  }

  $html .= '</select>';
  $html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"> ' . wp_kses_post( $args[ 'name' ] ) . '</label>';
  $html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '</div>';

  echo apply_filters( 'mh_after_setting_output', $html, $args );
}

//Checkbox
function mh_checkbox_callback( $args ) {

  $mh_option = mh_get_option( $args[ 'id' ] );
  $std = isset( $args[ 'std' ] ) ? $args[ 'std' ] : '';
  $name = 'name="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"';


  ///$checked = !empty( $mh_option ) ? checked( 'on', $mh_option, false ) : '';

  $class = mh_sanitize_html_class( $args[ 'field_class' ] );
  $class .= mh_sanitize_key( $args[ 'id' ] );
  $class .= ' checkbox switch_button';
  $class .= isset( $args[ 'affects' ] ) && '' !== $args[ 'affects' ] ? ' mh-affects' : '';
  $class .= isset( $args[ 'depends' ] ) && true === $args[ 'depends' ] ? ' mh-depends-el' : '';
  $data_affects = isset( $args[ 'affects' ] ) && '' !== $args[ 'affects' ] ? 'data-affects=".' . $args[ 'affects' ] . '"': '';

  $checked = '';
  if ( isset( $mh_option ) && !empty( $mh_option ) ) {
    if ( true == $mh_option ) {
      $checked = 'checked="checked"';
    } else {
      $checked = '';
    }
  } elseif ( !isset( $mh_option ) && true == $std ) {
    $checked = 'checked="checked"';
  }

  $html = '<input type="checkbox" id="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"' . $name . ' class="' . $class . '" ' . $data_affects . $checked . ' />';
  $html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"> ' . wp_kses_post( $args[ 'name' ] ) . '</label>';
  $html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '</div>';


  echo apply_filters( 'mh_after_setting_output', $html, $args );
}

//Radio
function mh_radio_callback( $args ) {
  $mh_options = mh_get_option( $args[ 'id' ] );

  $html = '';

  $class = mh_sanitize_html_class( $args[ 'field_class' ] );
  $class .= mh_sanitize_key( $args[ 'id' ] );
  $class .= isset( $args[ 'depends' ] ) && true === $args[ 'depends' ] ? ' mh-depends-el' : '';

  foreach ( $args[ 'options' ] as $key => $option ):
    $checked = false;

  if ( $mh_options && $mh_options == $key )
    $checked = true;
  elseif ( isset( $args[ 'std' ] ) && $args[ 'std' ] == $key && !$mh_options )
    $checked = true;

  $html .= '<input name="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']" id="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . '][' . mh_sanitize_key( $key ) . ']" class="' . $class . '" type="radio" value="' . mh_sanitize_key( $key ) . '" ' . checked( true, $checked, false ) . '/>&nbsp;';
  $html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . '][' . mh_sanitize_key( $key ) . ']">' . esc_html( $option ) . '</label><br/>';
  endforeach;

  $html .= '<p class="description">' . apply_filters( 'mh_after_setting_output', wp_kses_post( $args[ 'desc' ] ), $args ) . '</p>';

  echo $html;
}

//Textarea
function mh_textarea_callback( $args ) {
  $mh_option = mh_get_option( $args[ 'id' ] );

  if ( $mh_option ) {
    $value = $mh_option;
  } else {
    $value = isset( $args[ 'std' ] ) ? $args[ 'std' ] : '';
  }

  $class = mh_sanitize_html_class( $args[ 'field_class' ] );
  $class .= mh_sanitize_key( $args[ 'id' ] );
  $class .= isset( $args[ 'depends' ] ) && true === $args[ 'depends' ] ? ' mh-depends-el' : '';

  $html = '<textarea class="' . $class . ' large-text" cols="50" rows="5" id="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']" name="mharty_options[' . esc_attr( $args[ 'id' ] ) . ']">' . esc_textarea( stripslashes( $value ) ) . '</textarea>';
  $html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"> ' . wp_kses_post( $args[ 'name' ] ) . '</label>';
  $html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '</div>';

  echo apply_filters( 'mh_after_setting_output', $html, $args );
}

//wp_editor
function mh_wp_editor_callback( $args ) {
	$mh_option = mh_get_option( $args['id'] );

	if ( $mh_option ) {
		$value = $mh_option;
	} else {
		if( ! empty( $args['allow_blank'] ) && empty( $mh_option ) ) {
			$value = '';
		} else {
			$value = isset( $args['std'] ) ? $args['std'] : '';
		}
	}

	$rows = isset( $args['size'] ) ? $args['size'] : 20;

	$class = mh_sanitize_html_class( $args['field_class'] );

	ob_start();
	wp_editor( stripslashes( $value ), 'mharty_options_' . esc_attr( $args['id'] ), array( 'textarea_name' => 'mharty_options[' . esc_attr( $args['id'] ) . ']', 'textarea_rows' => absint( $rows ), 'editor_class' => $class ) );
	$html = ob_get_clean();

	$html .= '<br/><label for="mharty_options[' . mh_sanitize_key( $args['id'] ) . ']"> ' . wp_kses_post( $args['desc'] ) . '</label>';

	echo apply_filters( 'mh_after_setting_output', $html, $args );
}

//Header
function mh_header_callback( $args ) {
  $html = '<span class="mh-panel-section-title-span"></span>';
  $html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '</div>';
  echo apply_filters( 'mh_after_setting_output', $html, $args );

}

//function
function mh_function_callback( $args ) {
  do_action( $args[ 'id' ] . '_hook', $args );
}

//icons
function mh_iconpreview_callback( $args ) {

  $html = '<div class="iconpreview">';
  $html .= '<ul class="mhc-icon ' . esc_attr( $args[ 'icon' ] ) . '">';

  $html .= call_user_func( $args[ 'function_name' ] );
  $html .= '</ul></div>';

  echo $html;

}
//colour scheme
function mh_color_scheme_callback( $args ) {
  $items_amount = isset( $args[ 'items_amount' ] ) ? $args[ 'items_amount' ] : 1;
  $scheme_choice = mh_get_option( 'mharty_color_scheme' );

  $mh_input_value = '' !== str_replace( '|', '', $scheme_choice ) ? $scheme_choice : $args[ 'std' ];
  ?>
<div class="mh_colorscheme_overview" dir="ltr">
  <?php
  for ( $colorscheme_index = 1; $colorscheme_index <= $items_amount; $colorscheme_index++ ) {
    ?>
  <span class="colorscheme-item colorscheme-item-<?php echo esc_attr( $colorscheme_index ); ?>" data-index="<?php echo esc_attr( $colorscheme_index ); ?>"></span>
  <?php } ?>
</div>
<?php for ( $colorpicker_index = 1; $colorpicker_index <= $items_amount; $colorpicker_index++ ) { ?>
<div class="colorscheme-colorpicker" data-index="<?php echo esc_attr( $colorpicker_index ); ?>">
  <input data-index="<?php echo esc_attr( $colorpicker_index ); ?>" type="text" class="input-colorscheme-colorpicker" data-alpha="true" />
</div>
<?php } ?>
<?php

$html = '<input type="hidden" class="mh_color_scheme_main_input" id="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']" name="mharty_options[' . esc_attr( $args[ 'id' ] ) . ']" value="' . esc_attr( stripslashes( $mh_input_value ) ) . '"/>';
$html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"> ' . wp_kses_post( $args[ 'name' ] ) . '</label>';
$html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '<img class="mh_colorscheme_img" src="' . MHARTY_THEME_ADMIN_ASSETS . 'images/cp.png" /></div>';

echo apply_filters( 'mh_after_setting_output', $html, $args );
}

//colour scheme
function mh_color_schemes_callback( $args ) {

  $html = mh_color_palettes_list();
  $html .= '<label for="mharty_options[' . mh_sanitize_key( $args[ 'id' ] ) . ']"> ' . wp_kses_post( $args[ 'name' ] ) . '</label>';
  $html .= '<div class="mh-panel-option-desc">' . wp_kses_post( $args[ 'desc' ] ) . '</div>';

  echo apply_filters( 'mh_after_setting_output', $html, $args );
}

function mh_color_palettes_list() {
  $json = '{"option1": "#3c6c7d|#618589|#829982|#b0b591|#e3e0e0","option2": "#74b3ce|#508991|#d6d4a0|#bb7e8c|#9a7aa0","option3": "#3d0b37|#63264a|#d6d4a0|#5171a5|#086788","option4": "#3d0b37|#ccdbdc|#bdbf09|#0043e0|#dd7373","option5": "#426b69|#ccdbdc|#f87060|#fbff12|#222e50","option6": "#809848|#f75c03|#243119|#fbff12|#222e50","option7": "#e7e6c5|#de5302|#221d23|#564a59|#aa9daa","option8": "#e7e6c5|#feccae|#000100|#274690|#9b1d20","option9": "#cfbff7|#fffded|#000100|#274690|#01baef","option10": "#0a0903|#f0544f|#e6e6e6|#274690|#3d0000","option11": "#222e50|#ffd6d6|#c4e8e4|#ffc2f3|#fdf3d8","option12": "#53213d|#cc502b|#ebda2b|#b2d431|#61ae59","option13": "#F2EB85|#F2A25C|#D97B59|#BF6060|#F2F2F2","option14": "#080f8c|#c600d8|#ed0056|#0098ff|#6b7fdb","option15": "#A904BF|#3A0B40|#1ED9B7|#F2B749|#F26430","option16": "#734850|#592045|#A199BF|#D5E2F2|#261616","option17": "#4B3873|#A6904E|#F2AE72|#D97B59|#BF5E49","option18": "#AAF23D|#F2EC99|#D97E4A|#D92818|#F2F2F2","option19": "#BF3B46|#8C0327|#72DBF2|#5BCCD9|#8C0303","option20": "#080F8C|#0D0F40|#69BFAF|#F2CB05|#F24738","option21": "#A69A5D|#F24405|#F2C7BD|#F2887E|#400101","option22": "#0889A6|#A3D9CF|#53A677|#A4D97E|#F29580","option23": "#2E2C73|#47731A|#97F23D|#68A629|#D98F8F","option24": "#D95FA2|#5BA6A6|#60A665|#D9BD32|#A62E2E","option25": "#044BD9|#0460D9|#0476D9|#F2C063|#D93D3D","option26": "#4E54BF|#546FBF|#C7CDD9|#97A629|#BF7A26","option27": "#B21DF2|#241FA6|#3E38F2|#1E2940|#F2CD5E","option27": "#7A6DA6|#9AC7D9|#D9D277|#D95B5B|#F2F2F2","option28": "#3F4159|#467356|#93D973|#BF9F3F|#F2F2F2","option29": "#F2A2C0|#A67687|#F2F2F2|#595959|#0D0D0D","option30": "#F2F2F2|#5C2B8C|#B6D93B|#ADBF21|#F28729","option31": "#2A1A40|#3747A6|#6089BF|#7EB6D9|#F27B35","option32": "#012626|#F2E3D0|#F25835|#F24C3D|#F29999"}';

  $obj = json_decode( $json );
  set_site_transient( 'mh_captured_color_palette_data', $obj, 10800 );
  $data = get_site_transient( 'mh_captured_color_palette_data' );

  $html = '<ul class="mh_color_schemes_list">';
  foreach ( $data as $status ) {
    $html .= '<li>';
    $array = explode( '|', $status );
    foreach ( $array as $ar ) {
      $html .= '<span class="color_palette_item" style="background-color:' . $ar . '"></span>';
    }
    $html .= '<span class="color_palette_code">' . $status . '</span>';
    $html .= '</li>';
  }

  $html .= '</ul>';

  return $html;
}