<?php
if ( !defined( 'ABSPATH' ) )exit;

function mh_admin_scripts_styles() {
  //load css file for mharty menu icon & admin area style
  $ltr = is_rtl() ? "" : "-ltr";
  wp_enqueue_style( 'mh-admin-style', MHARTY_THEME_ADMIN_ASSETS . 'css/admin' . $ltr . '.css', array(), mh_get_theme_version() );
	wp_enqueue_script( 'mh_admin_script', MHARTY_THEME_ADMIN_ASSETS . 'js/admin.js', array( 'jquery' ), mh_get_theme_version() );
}
add_action( 'admin_enqueue_scripts', 'mh_admin_scripts_styles' );

function mh_panel_styles() {
  $ltr = is_rtl() ? "" : "-ltr";
  
  wp_enqueue_style( 'wp-color-picker' );
  wp_enqueue_style( 'mh_panel_css', MHARTY_THEME_ADMIN_ASSETS . 'css/panel' . $ltr . '.css', array(), mh_get_theme_version() );
}

function mh_panel_scripts() {
  global $wp_version;
  $theme_version = mh_get_theme_version();
  // Get WP major version
  $wp_major_version = substr( $wp_version, 0, 3 );

  $picker_l10n_strings = array(
    'defaultString' => esc_html__( 'Default', 'mharty' ),
		'clear'         => esc_html__( 'Clear', 'mharty' ),
		'pick'          => esc_html__( 'Select Colour', 'mharty' ),
	);

  wp_register_script( 'mh_panel_colorpicker', MHARTY_THEME_ADMIN_ASSETS . 'js/colorpicker.min.js', array(), $theme_version );
  wp_register_script( 'mh_panel_checkbox', MHARTY_THEME_ADMIN_ASSETS . 'js/checkbox.min.js', array(), $theme_version );
  wp_enqueue_script( 'wp-color-picker' );
  


  if ( version_compare( $wp_major_version, '4.9', '>=' ) ) {
    wp_enqueue_script( 'wp-color-picker-alpha', MHARTY_THEME_ADMIN_ASSETS . 'js/wp-color-picker-alpha.js', array( 'jquery', 'wp-color-picker' ), $theme_version, true );
  } else {
    wp_enqueue_script( 'wp-color-picker-alpha', MHARTY_THEME_ADMIN_ASSETS . 'js/wp-color-picker-alpha-legacy.min.js', array( 'jquery', 'wp-color-picker' ), $theme_version, true );
     $picker_l10n_strings['current'] = esc_html__( 'Current Colour', 'mharty' );
  }
 wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $picker_l10n_strings );
  
  wp_enqueue_script( 'mh_panel_script', MHARTY_THEME_ADMIN_ASSETS . 'js/panel.js', array( 'jquery', 'jquery-ui-tabs', 'jquery-form', 'mh_panel_colorpicker', 'mh_panel_checkbox', 'wp-color-picker-alpha' ), $theme_version );


  wp_localize_script( 'mh_panel_script', 'mhPanel', array(
    'clearpath' => MHARTY_THEME_ADMIN_ASSETS . 'images/empty.png',
    'noticecontent' => esc_html__( 'For ease, all visual settings have been moved to the Customiser. Here you will find all general and advanced settings.', 'mharty' ),
  ) );
}

function mh_start_styles() {
  $ltr = is_rtl() ? "" : "-ltr";
  wp_enqueue_style( 'mh_start', MHARTY_THEME_ADMIN_ASSETS . 'css/start' . $ltr . '.css', array(), mh_get_theme_version() );
}

function mh_start_scripts() {
  wp_enqueue_script( 'mh_start_script', MHARTY_THEME_ADMIN_ASSETS . 'js/start.js', array( 'jquery' ), mh_get_theme_version() );
  wp_localize_script( 'mh_start_script', 'mhStart', array(
    'ajaxurl'             => admin_url( 'admin-ajax.php' ),
    'mhstart_script_nonce'     => wp_create_nonce( 'mhstart_script_nonce' ),
    'panelescurl'  => esc_url( remove_query_arg( 'mh_key_activation' ) ),
  ));
}

function mharty_theme_menu() {
  $start_page = add_menu_page( esc_html__( 'Mharty', 'mharty' ), esc_html__( 'Mharty', 'mharty' ), 'switch_themes', 'mh_start', 'mh_start_page' );
  $customize_url = add_query_arg( 'return', urlencode( wp_unslash( $_SERVER[ 'REQUEST_URI' ] ) ), 'customize.php' );
  add_submenu_page( 'mh_start', esc_html__( 'Start Here', 'mharty' ), esc_html__( 'Start Here', 'mharty' ), 'switch_themes', 'mh_start', 'mh_start_page' );
  add_submenu_page( 'mh_start', esc_html__( 'Theme Customiser', 'mharty' ), esc_html__( 'Theme Customiser', 'mharty' ), 'switch_themes', esc_url( $customize_url ) );
  $panel_page = add_submenu_page( 'mh_start', esc_html__( 'Theme Panel', 'mharty' ), esc_html__( 'Theme Panel', 'mharty' ), 'switch_themes', 'mh_panel', 'mh_panel_page' );

  do_action( 'mh_add_to_mharty_menu' );

  add_action( "admin_print_styles-{$start_page}", 'mh_start_styles' );
  add_action( "admin_print_styles-{$panel_page}", 'mh_panel_styles' );
  
  add_action( "admin_print_scripts-{$start_page}", 'mh_start_scripts' );
  add_action( "admin_print_scripts-{$panel_page}", 'mh_panel_scripts' );

}
add_action( 'admin_menu', 'mharty_theme_menu' );

function mh_panel_page() {
  $settings_tabs = mh_get_settings_tabs();
  $settings_tabs = empty( $settings_tabs ) ? array() : $settings_tabs;
  $active_tab = isset( $_GET[ 'tab' ] ) ? sanitize_text_field( $_GET[ 'tab' ] ) : 'color_palette';
  $active_tab = array_key_exists( $active_tab, $settings_tabs ) ? $active_tab : 'color_palette';
  $sections = mh_get_settings_tab_sections( $active_tab );
  $key = 'main';

  if ( !empty( $sections ) ) {
    $key = key( $sections );
  }

  $registered_sections = mh_get_settings_tab_sections( $active_tab );
  $section = isset( $_GET[ 'section' ] ) && !empty( $registered_sections ) && array_key_exists( $_GET[ 'section' ], $registered_sections ) ? sanitize_text_field( $_GET[ 'section' ] ) : $key;

  // Unset 'main' if it's empty and default to the first non-empty if it's the chosen section
  $all_settings = mh_get_registered_settings();

  // Let's verify we have a 'main' section to show
  $has_main_settings = true;
  if ( empty( $all_settings[ $active_tab ][ 'main' ] ) ) {
    $has_main_settings = false;
  }

  // Check for old non-sectioned settings (see #4211 and #5171)
  if ( !$has_main_settings ) {
    foreach ( $all_settings[ $active_tab ] as $sid => $stitle ) {
      if ( is_string( $sid ) && !empty( $sections ) && array_key_exists( $sid, $sections ) ) {
        continue;
      } else {
        $has_main_settings = true;
        break;
      }
    }
  }

  $override = false;
  if ( false === $has_main_settings ) {
    unset( $sections[ 'main' ] );

    if ( 'main' === $section ) {
      foreach ( $sections as $section_key => $section_title ) {
        if ( !empty( $all_settings[ $active_tab ][ $section_key ] ) ) {
          $section = $section_key;
          $override = true;
          break;
        }
      }
    }
  }

  ob_start();
  ?>
<div class="wrap">
  <h1 style="display: none;">
    <?php esc_html_e( 'Theme Panel', 'mharty' ); ?>
  </h1>
</div>
<!-- end panel-wrap div -->
<div id="wrapper">
  <div id="panel-wrap">
    <form method="post" action="options.php" id="mhthemepanel">
      <div id="mh-panel-wrapper">
        <div id="mh-panel">
          <div id="mh-panel-content-wrap">
            <div id="mh-panel-content">
              <div id="mh-panel-header">
                <h1 id="mh-panel-title">
                  <?php esc_html_e( 'Theme Panel', 'mharty' ); ?>
                </h1>
                <ul id="mh-panel-mainmenu">
                  <?php
                  foreach ( mh_get_settings_tabs() as $tab_id => $tab_name ) {
                    $tab_url = add_query_arg( array(
                      'settings-updated' => false,
                      'tab' => $tab_id,
                    ) );

                    // Remove the section from the tabs so we always end up at the main section
                    $tab_url = remove_query_arg( 'section', $tab_url );

                    $active = $active_tab == $tab_id ? ' mh-panel-nav-tab-active' : '';

                    echo '<li id="mh-panel-nav-' . $tab_id . '"><a href="' . esc_url( $tab_url ) . '" class="mh-panel-nav-tab' . $active . '">';
                    echo esc_html( $tab_name );
                    echo '</a></li>';
                  }
                  ?>
                </ul><!-- end mh-panel-mainmenu -->
                
                <?php submit_button( __( 'Save Changes', 'mharty' ), 'save-button', '', false); ?>
              </div><!-- end mh-panel-header -->
              <div id="tab_container" class="<?php echo esc_attr( $active_tab . '-tab' ); ?>">
                <div class="tab-content">
                  <table class="form-table">
                    <?php

                    settings_fields( 'mharty_options' );
    
                    if ( 'main' === $section ) {
                      do_action( 'mh_settings_tab_top', $active_tab );
                    }

                    do_action( 'mh_settings_tab_top_' . $active_tab . '_' . $section );

                    do_settings_sections( 'mh_settings_' . $active_tab . '_' . $section );

                    do_action( 'mh_settings_tab_bottom_' . $active_tab . '_' . $section );
                    ?>
                  </table>
                  <?php //submit_button(); ?>
                </div>
              </div>
            </div>
            <!-- end #tab_container -->
            <div id="mh-panel-bottom">
              <?php submit_button( __( 'Save Changes', 'mharty' ), 'save-button', '', false); ?>
            </div>
            <!-- end mh-panel-bottom div --> 
            <span class="mh-panel-version"><?php echo __( 'Mharty Theme', 'mharty' ) . ' ' . mh_get_mharty_version(); ?></span> </div>
          <!-- end #mh-panel-content-wrap --> 
        </div>
        <!-- end mh-panel div --> 
      </div>
      <!-- end mh-panel-wrapper div -->
      
    </form>
  </div>
  <!-- end #wrapper --> 
</div>
<div class="mh_color_schemes_confirm">
	<div class="mh_color_schemes_confirm_box">
		<p><?php esc_html_e( 'This will override your current colour scheme.', 'mharty' ); ?></p>
		<div class="mh_color_schemes_confirm_button"><?php esc_html_e( 'Confirm', 'mharty' ); ?></div>
		<div class="mh_color_schemes_confirm_cancel"><?php esc_html_e( 'Cancel', 'mharty' ); ?></div>
	</div>
	</div>
<!-- end .wrap --> 
<script type="text/template" id="mh-panel-switch-template">
    <div class="mh-panel-switch-container">
        <div class="mh-panel-switch">
            <span class="mh-panel-switch-status mh-panel-switch-on"><?php esc_html_e( 'Enabled', 'mharty' ); ?></span>
            <span class="mh-panel-switch-dot"></span>
            <span class="mh-panel-switch-status mh-panel-switch-off"><?php esc_html_e( 'Disabled', 'mharty' ); ?></span>
        </div>
    </div>
</script>
<?php
    
    //@todo-6.1 better way to clear cache when icon fonts have changed or mailchimp list enabled or googel maps key added etc
    mh_update_option( 'mhc_clear_templates_cache', 'on' );
}
