<?php
if ( !defined( 'ABSPATH' ) ) {
  exit;
}

/**
 * Welcome Panel (top of start here page)
 */
function mh_welcome_panel() {
  $mharty_url = 'https://mharty.com';
  $class =  !get_transient( 'mharty_updated_welcome' ) ? ' closed' : '';
  $current_version = mh_get_mharty_version();
  $text = esc_html__('I designed a WordPress website with Mharty theme. Check it out!', 'mharty');
  $url = home_url();
  ?>
<div class="mh-welcome-panel<?php echo $class; ?>">
  <div class="mh-welcome-panel-content">
  <div class="mh-welcome-panel-top">
    <div class="mh-welcome-panel-top-image">
      <svg enable-background="new 0 0 570.8 570.8" version="1.1" viewBox="0 0 570.8 570.8" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
      <path d="m409.9 543.7-182.1 22.6c-31.5 3.9-60.3-18.5-64.2-50l-52.7-425c-3.9-31.5 18.5-60.3 50-64.2l182.1-22.6c31.5-3.9 60.3 18.5 64.2 50l52.7 425c3.9 31.6-18.5 60.3-50 64.2z" fill="none" stroke="#fff" stroke-miterlimit="10" stroke-width="3"/>
      <g fill="#fff">
      <path d="m302.2 327.8c-3.7 0-7.7-1.1-11.8-3.2-4.9-2.5-8.7-5.9-11.3-10.1l-59-94.8 25.1-3.1c0.8-0.1 1.6-0.1 2.4-0.1 3.8 0 7.7 1.1 11.7 3.2 4.9 2.5 8.7 5.9 11.3 10.1l59 94.8-25.1 3.1c-0.7 0-1.5 0.1-2.3 0.1z"/>
      <path d="m247.7 218c3.5 0 7.2 1 11 3 4.7 2.4 8.3 5.5 10.7 9.5l57.7 92.8-22.7 2.8c-0.7 0.1-1.5 0.1-2.2 0.1-3.5 0-7.2-1-11.1-3-4.7-2.4-8.3-5.6-10.7-9.5l-57.7-92.7 22.7-2.8c0.8-0.1 1.5-0.2 2.3-0.2m0-3c-0.9 0-1.8 0.1-2.6 0.2l-22.7 2.8-4.7 0.6 2.5 4 57.7 92.8c2.7 4.4 6.7 7.9 11.9 10.6 4.3 2.2 8.5 3.3 12.5 3.3 0.9 0 1.7-0.1 2.6-0.2l22.7-2.8 4.7-0.6-2.5-4-57.8-92.8c-2.7-4.4-6.7-8-11.9-10.6-4.2-2.2-8.4-3.3-12.4-3.3z"/>
      </g>
      <g fill="#fff">
      <path d="m353 321.5c-3.7 0-7.7-1.1-11.8-3.2-4.9-2.5-8.7-5.9-11.3-10.1l-59-94.8 25.1-3.1c0.8-0.1 1.6-0.1 2.4-0.1 3.8 0 7.7 1.1 11.7 3.2 4.9 2.5 8.7 5.9 11.3 10.1l59 94.8-25.1 3.1c-0.7 0-1.5 0.1-2.3 0.1z"/>
      <path d="m298.5 211.7c3.5 0 7.2 1 11 3 4.7 2.4 8.3 5.5 10.7 9.5l57.7 92.8-22.7 2.8c-0.7 0.1-1.5 0.1-2.2 0.1-3.5 0-7.2-1-11.1-3-4.7-2.4-8.3-5.6-10.7-9.5l-57.7-92.8 22.7-2.8c0.7 0 1.5-0.1 2.3-0.1m0-3c-0.9 0-1.8 0.1-2.6 0.2l-22.7 2.8-4.7 0.6 2.5 4 57.7 92.8c2.7 4.4 6.7 7.9 11.9 10.6 4.3 2.2 8.5 3.3 12.5 3.3 0.9 0 1.7-0.1 2.6-0.2l22.7-2.8 4.7-0.6-2.5-4-57.7-92.8c-2.7-4.4-6.7-8-11.9-10.6-4.4-2.2-8.5-3.3-12.5-3.3z"/>
      </g>
      <g fill="#fff">
      <path d="m251.4 334c-3.7 0-7.7-1.1-11.8-3.2-4.9-2.5-8.7-5.9-11.3-10.1l-33.5-54 25.1-3.1c0.8-0.1 1.6-0.1 2.4-0.1 3.8 0 7.7 1.1 11.7 3.2 4.9 2.5 8.7 5.9 11.3 10.1l33.5 54-25.1 3.1c-0.6 0.1-1.5 0.1-2.3 0.1z"/>
      <path d="m222.3 265.1c3.5 0 7.2 1 11 3 4.7 2.4 8.3 5.5 10.7 9.5l32.3 52-22.7 2.8c-0.7 0.1-1.5 0.1-2.2 0.1-3.5 0-7.2-1-11.1-3-4.7-2.4-8.3-5.6-10.7-9.5l-32.3-52 22.7-2.8c0.8 0 1.6-0.1 2.3-0.1m0-3c-0.9 0-1.8 0.1-2.6 0.2l-22.7 2.8-4.7 0.6 2.5 4 32.3 52c2.7 4.4 6.7 7.9 11.9 10.6 4.3 2.2 8.5 3.3 12.5 3.3 0.9 0 1.7-0.1 2.6-0.2l22.7-2.8 4.7-0.6-2.5-4-32.3-52c-2.7-4.4-6.7-8-11.9-10.6-4.3-2.2-8.5-3.3-12.5-3.3z"/>
      </g>
      <path d="m275.4 265.9c-7.9 0.7-15.8 1.2-23.7 1.7l28.7 46.1c2.4 3.9 6 7.1 10.7 9.5s9.1 3.4 13.3 2.9l22.7-2.8-36.6-58.7c-5 0.4-10 0.9-15.1 1.3z" fill="#24C162"/>
      <path d="m303.8 263.3 27.4 44.1c2.4 3.9 6 7.1 10.7 9.5s9.1 3.4 13.3 2.9l22.7-2.8-35.8-57.5c-12.7 1.4-25.5 2.6-38.3 3.8z" fill="#24C162"/>
      <path d="m234.4 268.6c-11.6 0.7-23.2 1.6-34.7 3.2l30 48.2c2.4 3.9 6 7.1 10.7 9.5s9.1 3.4 13.3 2.9l22.7-2.8-32.3-52c-2.3-3.7-5.5-6.7-9.7-9z" fill="#24C162"/>
      <path d="m256.9 275.9 23.6 37.9c2.4 3.9 6 7.1 10.7 9.5s9.1 3.4 13.3 2.9l22.7-2.8-36-57.9c-12.8 0.7-21.7 8.2-34.3 10.4z" fill="#42EA86"/>
      <path d="m338.1 256.9c-7-0.2-21.4 7.6-33.4 7.9l26.5 42.7c2.4 3.9 6 7.1 10.7 9.5s9.1 3.4 13.3 2.9l22.7-2.8-33.2-53.3c0.1-0.1-3.2-6.8-6.6-6.9z" fill="#42EA86"/>
      <path d="m208.5 286 21.1 34c2.4 3.9 6 7.1 10.7 9.5s9.1 3.4 13.3 2.9l22.7-2.8-32.3-52c-1.2-1.9-4.3-5.2-4.3-5.2s-6.9-1.3-14.5 2.9c-4.2 2.5-16.7 10.7-16.7 10.7z" fill="#42EA86"/>
      <circle cx="307.6" cy="241.3" r="3.1" fill="#76FFAC"/>
      <circle cx="302.4" cy="222.9" r="2.9" fill="#76FFAC"/>
      <circle cx="251.6" cy="232.3" r="3.1" fill="#76FFAC"/>
      <circle cx="272.3" cy="250.7" r="8" fill="#76FFAC"/>
      <circle cx="237.2" cy="228.1" r="4.1" fill="#76FFAC"/>
      <circle cx="321.8" cy="246.8" r="4.1" fill="#76FFAC"/>
      <circle cx="290.1" cy="284.6" r="3.1" fill="#76FFAC"/>
      <circle cx="267.9" cy="277.4" r="2.9" fill="#76FFAC"/>
      <circle cx="345.5" cy="280.9" r="3.1" fill="#76FFAC"/>
      <circle cx="320.7" cy="270.9" r="4.1" fill="#76FFAC"/>
      <circle cx="240.1" cy="295.9" r="4.1" fill="#76FFAC"/>
      <path d="m373.3 519.7-116 14.4c-1.5 0.2-2.8-0.9-3-2.4s0.9-2.8 2.4-3l116-14.4c1.5-0.2 2.8 0.9 3 2.4 0.2 1.4-0.9 2.8-2.4 3z" fill="#fff"/>
      <path d="m153.6 82.4c0.8-0.1 1.6 0.1 2.5 0.5s1.5 1 2 1.8l10.7 17.3-4.2 0.5c-0.8 0.1-1.6-0.1-2.5-0.5s-1.5-1-2-1.8l-10.7-17.2 4.2-0.6z" fill="#fff"/>
      <path d="m163.1 81.3c0.8-0.1 1.6 0.1 2.5 0.5s1.5 1 2 1.8l10.7 17.3-4.2 0.5c-0.8 0.1-1.6-0.1-2.5-0.5-0.9-0.5-1.5-1-2-1.8l-10.7-17.3 4.2-0.5z" fill="#fff"/>
      <path d="m148.9 91.2c0.8-0.1 1.6 0.1 2.5 0.5s1.5 1 2 1.8l6 9.7-4.2 0.5c-0.8 0.1-1.6-0.1-2.5-0.5-0.9-0.5-1.5-1-2-1.8l-6-9.7 4.2-0.5z" fill="#fff"/>
      <path d="m374.1 66.7-22.4 2.8c-0.5 0.1-0.9-0.3-1-0.7-0.1-0.5 0.3-0.9 0.7-1l22.4-2.8c0.5-0.1 0.9 0.3 1 0.7 0.1 0.5-0.2 0.9-0.7 1z" fill="#fff"/>
      <path d="m373.2 59.1-22.4 2.8c-0.5 0.1-0.9-0.3-1-0.7-0.1-0.5 0.3-0.9 0.7-1l22.4-2.8c0.5-0.1 0.9 0.3 1 0.7 0.1 0.5-0.2 0.9-0.7 1z" fill="#fff"/>
      <path d="m375.1 74.3-22.4 2.8c-0.5 0.1-0.9-0.3-1-0.7-0.1-0.5 0.3-0.9 0.7-1l22.4-2.8c0.5-0.1 0.9 0.3 1 0.7 0.1 0.5-0.3 0.9-0.7 1z" fill="#fff"/>
      </svg>
    </div>
    <h1><?php echo esc_html__('Welcome Mharty', 'mharty') . ' ' . $current_version; ?></h1>
    <p><a target="_blank" href="<?php echo $mharty_url . '/blog/mharty-theme-6-0/';?>"><?php echo esc_html__("What's new in Mharty theme?", "mharty"); ?></a></p>
  </div>
  <div class="mh-welcome-panel-actions">
    <div class="mh-welcome-panel-action">
      <div class="mh-welcome-panel-svg-explore"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"> <path style="fill:#fff;" d="M90,5H9C7.8,5,6.7,6,6.7,7.2v67.5C6.7,76,7.8,77,9,77h35.1L29.9,91.2c-0.9,0.9-0.9,2.3,0,3.2 	c0.4,0.4,1,0.7,1.6,0.7c0.6,0,1.2-0.2,1.6-0.7l14.2-14.2v12.6c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2V80.2l14.2,14.2 	c0.4,0.4,1,0.7,1.6,0.7c0.6,0,1.2-0.2,1.6-0.7c0.9-0.9,0.9-2.3,0-3.2L54.9,77H90c1.2,0,2.2-1,2.2-2.2V7.2C92.3,6,91.2,5,90,5L90,5z 	 M11.2,9.5h76.5v54H11.2V9.5z M87.7,72.5H11.2V68h76.5V72.5z"></path> <path style="fill:#fff;" d="M64.3,34.7L41.8,18.9c-0.7-0.5-1.6-0.5-2.3-0.2s-1.2,1.2-1.2,2v31.5c0,0.8,0.5,1.6,1.2,2 	c0.3,0.2,0.7,0.3,1,0.3c0.5,0,0.9-0.1,1.3-0.4l22.5-15.8c0.6-0.4,1-1.1,1-1.8S64.9,35.1,64.3,34.7L64.3,34.7z M42.7,47.9V25.1 	l16.3,11.4L42.7,47.9L42.7,47.9z"></path> </svg></div>
      <div class="mh-welcome-panel-action-content">
        <h2><?php echo esc_html__('New Learning Hub', 'mharty'); ?></h2>
        <p><?php echo esc_html__('Sharpen your design skills and toolset with our educational content and videos.', 'mharty'); ?></p>
        <a target="_blank" href="<?php echo $mharty_url . '/blog/mharty-theme-6-5/';?>"><?php echo esc_html__('Start learning', 'mharty'); ?></a> </div>
    </div>

    <div class="mh-welcome-panel-action">
      <div class="mh-welcome-panel-svg-review"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M23.984 9.784c-0.044-0.181-0.188-0.322-0.366-0.366l-7.516-1.834-3.656-7.309c-0.084-0.169-0.256-0.275-0.447-0.275s-0.363 0.106-0.447 0.275l-3.653 7.309-7.519 1.838c-0.181 0.044-0.322 0.184-0.366 0.366-0.047 0.178 0.012 0.369 0.153 0.494l5.716 5.084-1.809 8.025c-0.044 0.191 0.028 0.391 0.184 0.509s0.366 0.134 0.541 0.044l7.2-3.875 7.2 3.872c0.075 0.041 0.156 0.059 0.237 0.059 0.106 0 0.213-0.034 0.303-0.103 0.156-0.119 0.228-0.316 0.184-0.509l-1.809-8.025 5.719-5.084c0.138-0.122 0.197-0.312 0.15-0.494zM17.231 14.813c-0.134 0.122-0.197 0.306-0.156 0.484l1.634 7.244-6.472-3.481c-0.075-0.041-0.156-0.059-0.237-0.059s-0.162 0.019-0.237 0.059l-6.472 3.481 1.634-7.244c0.041-0.178-0.019-0.363-0.156-0.484l-5.225-4.647 6.816-1.666c0.144-0.034 0.262-0.131 0.328-0.262l3.312-6.619 3.309 6.622c0.066 0.131 0.184 0.228 0.328 0.263l6.816 1.666-5.222 4.644z" style="fill:#ffffff;"></path></svg></div>
      <div class="mh-welcome-panel-action-content">
        <h2><?php echo esc_html__('Leave a review', 'mharty'); ?></h2>
        <p><?php echo esc_html__('Support Mharty theme today, tell your friends about us and show off your designs.', 'mharty'); ?></p>
        <a target="_blank" href="<?php echo $mharty_url . '/testimonials/';?>"><?php echo esc_html__('Leave a review', 'mharty'); ?></a></div>
    </div>
  </div>
  <!--actions--> 
  </div>
  <a class="mh-welcome-panel-close" href="#"><?php echo esc_html__('Hide welcome message', 'mharty'); ?></a>
  <a class="mh-welcome-panel-open" href="#"><?php echo esc_html__('Welcome message', 'mharty'); ?></a>
</div>
<?php
}

/**
 * Updated Popup
 */
function mh_updated_popup() {
	$updated = get_theme_mod( 'mh_updatetd_6_0', 'no' );
  $old_options = get_option( 'mh_mharty' );
    if ( 'yes' !== $updated && !empty( $old_options ) ) {
    ?>
<?php printf ( '<div class="mh-updated-popup-overlay"><div class="mh-updated-popup">
<div class="mh-updated-popup-img"></div>
<div class="mh-updated-progress"><div class="mh-updated-progress-bar"></div></div>
<a class="mh-updated-popup-button" href="%1$s">%2$s</a>
</div></div>',
			admin_url( 'admin.php?page=mh_start' ),
		__('Start Here', 'mharty')
				
				);  ?>
<?php
		}
  
   //get theme version to compare
  $current_version =mh_get_mharty_version();
  $version = get_option( 'mharty_version' );
  $updated = version_compare( $current_version, $version, '>' );
  if ( $updated ||  !$version ) {
    update_option( 'mharty_version', $current_version );
    //@todo add condition to check is it a big release?
    set_transient( 'mharty_updated_welcome', 1 );   
  }
  
}
add_action( 'admin_footer', 'mh_updated_popup' );