<?php
if ( ! defined( 'ABSPATH' ) || class_exists( 'MH_Installer', false ) )
	return;

/**
 * Plugin Installer Class
 *
 */
class MH_Installer{

	var $config;

	public function __construct( $config = array() ) {

		$defaults = array(
			'base' => '',
			'repo_slug' => '',
		);

		$this->config = wp_parse_args( $config, $defaults );
        
		
        if ( !empty ( $this->config['repo_slug'] ) ){
              if ( is_admin() ) {       
							add_filter( 'plugins_api', array( &$this, 'plugins_api_result' ), 10, 3 );
              }
        }
	}
	
	/**
	 * Filter Plugin API
	 */
	public function plugins_api_result( $res, $action, $args ) {
	
		$slug = $this->config['repo_slug'];
    $base = $this->config['base'];
		
		if ( is_array($args) )
			$args = (object)$args;
		
		$plugin_slug = '';
		
		if ( !isset( $args->slug ) ){
			 
			if ( isset( $_REQUEST['plugin'] ) ){
				$plugin_slug = wp_unslash( $_REQUEST['plugin'] );           
			}else{        
          if ( isset( $args->body['request'] ) ){
              $get_args_body = maybe_unserialize( $args->body['request'] );
              if ( isset( $get_args_body->slug ) ){
                  $plugin_slug = $get_args_body->slug;
              }
				}
				}
		
		}else{
			$plugin_slug = $args->slug;
				}
		
		
		
				
		if ( $plugin_slug == $base && $action == 'plugin_information' ){
       $data = mh_request_updates_data();
     if ( ! empty( $data ) && ( is_array( $data ) || is_object( $data )) && isset( $data[$slug] )) {
            $info = new stdClass;
            $info->name = $base;
            $info->version = $data[$slug]['version'];
            $info->download_link = esc_url_raw( $data[$slug]['package'] );
            $info->slug = $base;
		
            $info->external = true;

		
            if ( isset( $data[$slug]['sections'] ) ) {
                $info->sections = maybe_unserialize( $data[$slug]['sections'] );
		 }

            if ( isset( $data[$slug]['banners'] ) ) {
                $info->banners = maybe_unserialize( $data[$slug]['banners'] );
	}
	
            if ( isset( $data[$slug]['icons'] ) ) {
                $info->icons = maybe_unserialize( $data[$slug]['icons'] );
			}

            if( ! empty( $data[$slug]['sections'] ) ) {
                foreach( $data[$slug]['sections'] as $key => $section ) {
                    $info->$key = (array) $section;
			}
			}

            $res = $info;
					}
				}
		return $res;
			}
}