<?php
function mh_install_plugin($plugin) {

    //get the slug
    switch ($plugin) {
        case 'composer':
            $plugin_slug = 'mh-composer';
            break;
        case 'classiceditor':
            $plugin_slug = 'classic-editor';
            break;
        case 'classicwidgets':
            $plugin_slug = 'classic-widgets';
            break;
        case 'magazine':
            $plugin_slug = 'mh-magazine';
            break;
        case 'shop':
            $plugin_slug = 'mh-shop';
            break;
        case 'loveit':
            $plugin_slug = 'mh-loveit';
            break;
        case 'icons':
            $plugin_slug = 'mh-more-icons';
            break;
        case 'reviews':
            $plugin_slug = 'mh-reviews';
            break;
        case 'author':
            $plugin_slug = 'mh-author-page-cover';
            break;
        case 'shortcodes':
            $plugin_slug = 'mh-shortcodes';
            break;
        case 'socialproof':
            $plugin_slug = 'mh-social-proof';
            break;
    }

    $status = get_option('mharty_activation_key_status');

    if ('valid' !== $status) {
        $action = sprintf('<span class="not-active" aria-label="%1$s">%1$s</a>', __('Activate your theme to manage plugins', 'mharty'));
    } else {

        if (!in_array($plugin, mharty_active_plugins())) {

            //if plugin installed
            if (file_exists(WP_PLUGIN_DIR . '/' . $plugin_slug)) {
                $plugin_file = $plugin_slug . '/' . $plugin_slug . '.php';
                $url = wp_nonce_url(
                    add_query_arg(
                        [
                            'action' => 'activate',
                            'plugin' => $plugin_file,
                        ],
                        admin_url('plugins.php')
                    ),
                    'activate-plugin_' . $plugin_file
                );
                $action = sprintf(
                    '<a href="%1$s" class="activate" data-slug="%2$s" aria-label="%3$s">%3$s</a>',
                    esc_url($url),
                    esc_attr($plugin_slug),
                    __('Activate', 'mharty')
                );

                //if plugin is not installed
            } else {

                if (is_main_site()) {
                    $url = wp_nonce_url(
                        add_query_arg(
                            [
                                'action' => 'install-plugin',
                                'plugin' => $plugin_slug,
                            ],
                            self_admin_url('update.php')
                        ),
                        'install-plugin_' . $plugin_slug
                    );
                    $action = sprintf(
                        '<a href="%1$s" class="install-now" data-slug="%2$s" aria-label="%3$s">%3$s</a>',
                        esc_url($url),
                        esc_attr($plugin_slug),
                        __('Install', 'mharty')
                    );
                } else {
                    $action = sprintf(
                        /* translators: %s: URL to Import screen on the main site. */
                        __('<a href="%s">Go to main site plugins</a>.', 'mharty'),
                        get_admin_url(get_current_network_id(), 'plugins.php')
                    );
                }

            }

            //if plugin is active
        } else {

            $action = sprintf('<span class="installed" aria-label="%1$s">%1$s</a>', __('Active', 'mharty'));

            //show update button
            $cache = mh_request_updates_data();
            if (!empty($cache) && is_array($cache)) {
                $file_path = trailingslashit(WP_PLUGIN_DIR) . $plugin_slug . '/' . $plugin_slug . '.php';
                $get_plugin_data = get_plugin_data($file_path);
                //check available updates
                if ('classiceditor' !== $plugin && 'classicwidgets' !== $plugin) {
                    if ('loveit' === $plugin) {
                        $plugin = 'social';
                    }
                    if (version_compare(strip_tags($get_plugin_data['Version']), $cache[$plugin]['version'], '<')) {
                        $action = sprintf('<span class="installed" aria-label="%1$s">%1$s</a>', __('Active', 'mharty'));

                        if (is_main_site()) {
                            $update_file = $plugin_slug . '/' . $plugin_slug . '.php';
                            $url = self_admin_url('plugins.php?plugin_status=upgrade');

                            $action = sprintf(
                                '<a href="%1$s" class="update-now" data-slug="%2$s" aria-label="%3$s"><span></span>%4$s</a>',
                                esc_url($url),
                                esc_attr($plugin_slug),
                                __('Update', 'mharty'),
                                __('Update to', 'mharty') . ' ' . $cache[$plugin]['version']
                            );
                        } else {
                            $action = sprintf(
                                /* translators: %s: URL to Import screen on the main site. */
                                __('<a href="%s">Go to main site plugins</a>.', 'mharty'),
                                get_admin_url(get_current_network_id(), 'plugins.php')
                            );
                        }
                    }

                }

            } //end of update button

        }
    }
    return $action;
}

function mh_setup_plugins_data() {

    if (!class_exists('MHComposer', false)) {
        new MH_Installer(['base' => 'mh-composer', 'repo_slug' => 'composer']);
    } else {
        new MH_Updater(['base' => 'mh-composer/mh-composer.php', 'repo_slug' => 'composer']);
    }
    if (!class_exists('MHShop', false)) {
        new MH_Installer(['base' => 'mh-shop', 'repo_slug' => 'shop']);
    } else {
        new MH_Updater(['base' => 'mh-shop/mh-shop.php', 'repo_slug' => 'shop']);
    }
    if (!class_exists('MHLoveitClass', false)) {
        new MH_Installer(['base' => 'mh-loveit', 'repo_slug' => 'social']);
    } else {
        new MH_Updater(['base' => 'mh-loveit/mh-loveit.php', 'repo_slug' => 'social']);
    }
    if (!class_exists('MHReviewsClass', false)) {
        new MH_Installer(['base' => 'mh-reviews', 'repo_slug' => 'reviews']);
    } else {
        new MH_Updater(['base' => 'mh-reviews/mh-reviews.php', 'repo_slug' => 'reviews']);
    }
    if (!class_exists('MHMagazine', false)) {
        new MH_Installer(['base' => 'mh-magazine', 'repo_slug' => 'magazine']);
    } else {
        new MH_Updater(['base' => 'mh-magazine/mh-magazine.php', 'repo_slug' => 'magazine']);
    }
    if (!class_exists('MHMoreIconsClass', false)) {
        new MH_Installer(['base' => 'mh-more-icons', 'repo_slug' => 'icons']);
    } else {
        new MH_Updater(['base' => 'mh-more-icons/mh-more-icons.php', 'repo_slug' => 'icons']);
    }
    if (!class_exists('Mh_Author_Page_Cover', false)) {
        new MH_Installer(['base' => 'mh-author-page-cover', 'repo_slug' => 'author']);
    } else {
        new MH_Updater(['base' => 'mh-author-page-cover/mh-author-page-cover.php', 'repo_slug' => 'author']);
    }
    //check also for old version
    if (!class_exists('MHShortcodesClass', false) && !function_exists('mhsc_shortcodes_init')) {
        new MH_Installer(['base' => 'mh-shortcodes', 'repo_slug' => 'shortcodes']);
    } else {
        new MH_Updater(['base' => 'mh-shortcodes/mh-shortcodes.php', 'repo_slug' => 'shortcodes']);
    }

    if (! defined('MH_SOCIAL_PROOF_VERSION')) {
        new MH_Installer(['base' => 'mh-social-proof', 'repo_slug' => 'socialproof']);
    } else {
        new MH_Updater(['base' => 'mh-social-proof/mh-social-proof.php', 'repo_slug' => 'socialproof']);
    }

}
add_action('init', 'mh_setup_plugins_data');
