<?php
function mh_request_updates_data() {

    $data = '';

    if (get_site_transient('mh_captured_updates_data')) {
        $data = get_site_transient('mh_captured_updates_data');

    } else {
        $key = trim(get_option('mharty_activation_key', ''));
        if (!empty($key)) {
            $remote_url = add_query_arg(['repositories' => 'all', 'get_updates' => 'get'], apply_filters('mh_request_updates_data_url', 'https://mharty.com'));

            $remote_request = ['timeout' => 15, 'body' => ['key' => $key], 'user-agent' => 'WordPress;' . home_url()];

            $request = wp_remote_post($remote_url, $remote_request);

            if (!is_wp_error($request) && ($request['response']['code'] == 200)) {
                $request = json_decode(wp_remote_retrieve_body($request), true);

                //store for 3hrs
                set_site_transient('mh_captured_updates_data', $request, 10800);
                $data = get_site_transient('mh_captured_updates_data');

                //send install data
                mh_send_install_data($key);
            } else {
                /* If data is not an object */
                $data = new WP_Error('plugins_api_failed', esc_html__('An unknown error occurred', 'mharty'), wp_remote_retrieve_body($request));

            }
        }
    }

    return $data;
}
